import java.io.*;
import java.util.*;

public class TextUI {
	private Nemo nemo;
	private BufferedReader in;
	private int leftMargin;
	private int topMargin;

	public static void main(String[] args) {
		new TextUI().run();
	}

	public TextUI() {
		init();
	}

	private void init() {
		StringReader sr = new StringReader(
			"3 3 \n"
			+ "3 \n 1 \n 1 \n"
			+ "1 1 \n 2 \n 1 \n");
		try {
			nemo = new Nemo(sr);
		}
		catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
		in = new BufferedReader(new InputStreamReader(System.in));
		preparePrint();
	}

	public void run() {
		while (true) {
			print();
			if (nemo.finished())
				break;
			prompt();
		}
	}

	private void preparePrint() {
		for (int i = 0; i < nemo.getNRows(); i++) {
			Numbers row = nemo.getRow(i);
			if (row.size() > leftMargin)
				leftMargin = row.size();
		}
		for (int i = 0; i < nemo.getNCols(); i++) {
			Numbers col = nemo.getCol(i);
			if (col.size() > topMargin)
				topMargin = col.size();
		}
	}

	private void print() {
		for (int i = 0; i < topMargin; i++) {
			for (int j = 0; j < leftMargin; j++) {
				System.out.print("  ");
			}
			for (int j = 0; j < nemo.getNCols(); j++) {
				Numbers col = nemo.getCol(j);
				if (i < col.size()) {
					System.out.print(col.get(i) + " ");
				} else {
					System.out.print("  ");
				}
			}
			System.out.println("");
		}
		for (int i = 0; i < nemo.getNRows(); i++) {
			Numbers row = nemo.getRow(i);
			for (int j = 0; j < leftMargin; j++) {
				if (j < row.size()) {
					System.out.print(row.get(j) + " ");
				} else {
					System.out.print("  ");
				}
			}
			for (int j = 0; j < nemo.getNCols(); j++) {
				if (nemo.marked(i, j)) {
					System.out.print("* ");
				} else {
					System.out.print("  ");
				}
			}
			System.out.println("");
		}
	}

	private void prompt() {
		System.out.print("Toggle which pixel? ");
		Vector v = new Vector();
		String s = null;
		try {
			s = in.readLine();
		}
		catch (IOException e) {
			e.printStackTrace();
			return;
		}

		StringTokenizer st = new StringTokenizer(s);
		while (st.hasMoreTokens()) {
			v.addElement(st.nextToken());
		}
		if (v.size() != 2) {
			System.out.println("Unknown command: " + s);
			return;
		}

		int row = Integer.parseInt((String) v.elementAt(0));
		int col = Integer.parseInt((String) v.elementAt(1));
		toggle(row, col);
	}

	private void toggle(int row, int col) {
		if (nemo.marked(row, col)) {
			nemo.unmark(row, col);
		} else {
			nemo.mark(row, col);
		}
	}
}
