import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class Picture extends JPanel {
	private Nemo nemo;
	private Dimension d;
	private int height;

	public Picture(Nemo nemo) {
		this.nemo = nemo;
		addMouseListener();
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		// g.drawRect(0, 0, d.width-1, d.height-1);
		Color save = g.getColor();
		for (int row = 0; row < nemo.getNRows(); row++) {
			for (int col = 0; col < nemo.getNCols(); col++) {
				if (nemo.marked(row, col)) {
					g.setColor(Color.darkGray);
				} else {
					g.setColor(Color.lightGray);
				}
				g.fillRect(1 + col*height, 1 + row*height,
					height - 2, height - 2);
			}
		}
		g.setColor(save);
	}

	public Dimension getPreferredSize() {
		FontMetrics fm = getGraphics().getFontMetrics();
		height = fm.getHeight();
		d = new Dimension(nemo.getNCols() * height + 1,
			nemo.getNRows() * height + 1);
		return d;
	}

	private void addMouseListener() {
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				if (nemo.finished())
					return;
				int row = e.getY() / height;
				int col = e.getX() / height;
				if (nemo.marked(row, col)) {
					nemo.unmark(row, col);
				} else {
					nemo.mark(row, col);
				}
				repaint();
				if (nemo.finished()) {
					// System.out.println("finished!");
					JOptionPane.showMessageDialog(null,
						"Finished!");
					// System.exit(0);
				}
			}
		});
	}
}
