/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WEBVIEWER_H
#define WEBVIEWER_H

// #include <ktextbrowser.h>
#include <qcursor.h>
#include <qtimer.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <QCloseEvent>
#include <kurl.h>
#include <kparts/browserextension.h>
#include <q3vbox.h>
#include <qlineedit.h>
#include <kapplication.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmenu.h>
#include <khtml_part.h>
#include <qlayout.h>
#include <kio/jobclasses.h>
#include <kstandarddirs.h>
#include <krun.h>
#include <kcursor.h>

#include "webwindow.h"
#include "utils.h"

// class KTextBrowser;

class WebViewer: public WebForm1 {
    Q_OBJECT
public:
    WebViewer(QWidget *parent = 0, const char *name = 0);
    ~WebViewer();
    void openURL(const QString &url);

protected slots:
    void openURLRequest(const KUrl &url, const KParts::OpenUrlArguments &args );
    void createNewWindow( const KUrl &url, const KParts::OpenUrlArguments &args );
    void started(KIO::Job *);    // Started to download the requested URL
    void completed();            // Requested URL download completed
    void timerTimeout();

private:
    Q3VBoxLayout* MyDialog1Layout;
    // QLineEdit *location;
    Q3VBox * vbox;
    KHTMLPart *browser;
    QString sUrl;
    void closeEvent ( QCloseEvent * e );

signals:
    void newUrlRequested(const KUrl &url, const KParts::OpenUrlArguments &oArgs, const KParts::BrowserArguments &bArgs);
    void newWindowRequested(const KUrl &, const KParts::OpenUrlArguments &, const KParts::BrowserArguments &, const KParts::WindowArgs &, KParts::ReadOnlyPart *&);
};

#endif
