/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ALLOWFRIENDFORM_H
#define ALLOWFRIENDFORM_H

#include <kstandarddirs.h>
#include <kglobal.h>
#include <kaboutdata.h>
#include <kcomponentdata.h>

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
//Added by qt3to4:
#include <Q3VBoxLayout>
#include <Q3Frame>
#include <Q3GridLayout>
#include <Q3HBoxLayout>
#include <QLabel>

class Q3VBoxLayout;
class Q3HBoxLayout;
class Q3GridLayout;
class QSpacerItem;
class Q3Frame;
class QLabel;
class QPushButton;

class AllowFriendForm : public QDialog {
    Q_OBJECT

public:
    AllowFriendForm( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~AllowFriendForm();

    Q3Frame* frame3;
    QLabel* pixmapLabel1;
    QLabel* useridLabel;
    Q3Frame* frame4;
    QLabel* textLabel1_2;
    QLabel* messageLabel;
    QPushButton* profileButton;
    QPushButton* acceptButton;
    QPushButton* rejectButton;
    QPushButton* cancelButton;

protected:
    Q3VBoxLayout* AllowFriendFormLayout;
    Q3HBoxLayout* frame3Layout;
    QSpacerItem* spacer3;
    QSpacerItem* spacer4;
    QSpacerItem* spacer5;
    Q3VBoxLayout* frame4Layout;
    Q3VBoxLayout* layout5;
    Q3HBoxLayout* layout3;
    QSpacerItem* spacer2;
    Q3HBoxLayout* layout1;
    QSpacerItem* spacer1;

protected slots:
    virtual void languageChange();

private:
    QPixmap image0;
    QPixmap image1;
    QPixmap image2;

};

#endif // ALLOWFRIENDFORM_H
