/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "utils.h"
#include "../nateon/util/common.h"

extern nmconfig stConfig;

LNMUtils::LNMUtils(QObject *parent, const char *name)
	: QObject(parent, name)
{
}


LNMUtils::~LNMUtils()
{
}

#include "utils.moc"

// #define NETDEBUG 1

void LNMUtils::openURL( const QString &sURL )
{
	QString sCommand;
	if ( stConfig.usedefaultwebbrowser ) {
		sCommand = stConfig.defaultwebbrowser;
		sCommand += " ";
		sCommand += "'";
		sCommand += sURL;
		sCommand += "'";
#ifdef NETDEBUG
		kdDebug() << stConfig.defaultwebbrowser << " : "<< sCommand << endl;
#endif
		system( sCommand.data() );
	} else {
#ifdef NETDEBUG
		kdDebug() << "KRun (" << sURL << ")" << endl;
#endif
		KRun::runURL( sURL, "text/html");
	}
	return;
}

void LNMUtils::sendMail(const QString & sEMails)
{
	QString sCommand;
	if ( QFile::exists( "/bin/xdg-email" ) ) {
		sCommand = "/bin/xdg-email";
	} else if ( QFile::exists( "/usr/bin/xdg-email" ) ) {
		sCommand = "/usr/bin/xdg-email";
	} else if ( QFile::exists( "/usr/local/bin/xdg-email" ) ) {
		sCommand = "/usr/local/bin/xdg-email";
	} else {
#ifdef NETDEBUG
		kdDebug() << "KRun (" << sEMails << ")" << endl;
#endif
		QString sMails("mailto:");
		sMails += sEMails;
		new KRun( sMails );
		return;
	}
	sCommand += " ";
	sCommand += "'";
	sCommand += sEMails;
	sCommand += "'";
#ifdef NETDEBUG
	kdDebug() << sCommand << endl;
#endif
	system( sCommand.data() );
	return;
}
