/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef P2PSERVER_H
#define P2PSERVER_H

#include <qptrdict.h>
#include <qstringlist.h>
#include <kextsock.h>

#include "p2pconnection.h"
#include "../currentaccount.h"

class Client;

/**
   @author Doo-Hyun Jang <ring0320@nate.com>
*/
class P2PServer : public P2PConnection
{
Q_OBJECT
public:
    P2PServer(QObject *parent = 0, const char *name = 0);
    ~P2PServer();
    void startServer();
    void stopServer();

    int getPort() { return m_nPort; }
    void setPort( int nPort ) { m_nPort = nPort; }
    // void ConnectToFR(QString &sIP, int nPort, const QString & YourID, const QString & MyID, const QString &DPCookie, const QString &FRCookie);
    void setCurrentAccount(CurrentAccount* CurrentAccount) { pCurrentAccount=CurrentAccount; }

protected:
    ServerSocket* m_server;
    CurrentAccount* pCurrentAccount;
    QString m_sServer;
    int m_nPort;
    


protected slots:
    void slotNewClient(QSocket* socket);
    void slotClientDisconnected();
    void slotSocketRead();
    void slotSocketReadFR();
    void slotSendATHCtoFR();
    void slotSendATHC();
    void slotConnectP2PFR( const QStringList& slCommand );
    void slotConnectToP2P(const QStringList& slCommand);
    // void slotP2PSocketError();
    void slotTimeOut(SendFileInfo* pSendFileInfo);
    void slotReceivedREFR( const QStringList& slCommand);
    void slotSendFRIN();

signals:
    void connTimeOut( SendFileInfo* );
};

#endif
