#include "buddylistview.h"
#include "contactlist.h"

BuddyListView::BuddyListView(QWidget* parent, const char* name/*=0*/) :
	KListView(parent, name)
{
}

BuddyListView::~BuddyListView()
{
}

void BuddyListView::contentsMousePressEvent(QMouseEvent* e)
{
	QPoint vp = contentsToViewport(e->pos());
	ContactList* item = (ContactList*)itemAt(vp);
	if (item && item->hasHompy() && item->richText() &&
		item->parent())
	{
			item->richText()->adjustSize();

			//printf("korone>> e->pos() x:%d y:%d\n",
			//	e->pos().x(), e->pos().y());
			int marginX = treeStepSize() * item->depth();
			//printf("marginX:%d\n", marginX);

			// 18: hompy button size
			int hompyX1 = marginX + item->richText()->width() - 18;
			int hompyX2 = hompyX1 + 18;

			//printf("korone>> x1:%d x2:%d\n", hompyX1, hompyX2);
			if (e->pos().x() >= hompyX1 && e->pos().x() <= hompyX2)
			{
				emit clickedHompy(item);						
				return;
			}
	}
	
	KListView::contentsMousePressEvent(e);
}

#include "buddylistview.moc"
