/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "p2pconnection.h"

int Client::m_count = 0;

void Client::openSaveFile(QString pPath)
{
	QString sFileName( m_pSendFileInfo->getFileName() );
	// sFileName.replace("%20", " ");
	QString pFilePath = pPath + "/" + sFileName;
	if ( QFile::exists( pFilePath ) )
		QFile::remove ( pFilePath );
	qFile.setName(pFilePath);
	qFile.open( IO_Raw | IO_WriteOnly | IO_Append );
}

void Client::writeSaveFile(const QByteArray &qArray, unsigned long size)
{
	ulWriteSum += size;
	ulPacketSum = 0;
	qFile.writeBlock(qArray, size);
}

void Client::closeSaveFile()
{
	qFile.close();
}

P2PConnection::P2PConnection(QObject *parent, const char *name)
	: QObject(parent, name), m_nTrid(0)
{
	m_clients.clear();
	m_SendFileInfo.clear();
}


P2PConnection::~P2PConnection()
{
}

void P2PConnection::addSendFileInfo(SendFileInfo * pSendFileInfo)
{
	m_SendFileInfo.append(pSendFileInfo);
}

/*!
  socket 값으로 파일 정보 Class를 구하는 함수.
*/
SendFileInfo * P2PConnection::getSendFileInfoBySocket(int Socket)
{
	SendFileInfo* pSendFileInfo;
	for ( pSendFileInfo = m_SendFileInfo.first(); pSendFileInfo; pSendFileInfo = m_SendFileInfo.next() )
		if ( pSendFileInfo ) {
			QSocket* pSock = pSendFileInfo->getSocket();
			if ( pSock ) {
				if ( pSock->socket() == Socket)
					return pSendFileInfo;
			}
		}
	return 0;
}

/*!
  SS Cookie값으로 파일 정보 Class를 구하는 함수.
*/
SendFileInfo * P2PConnection::getSendFileInfoBySSCookie(QString sCookie)
{
	SendFileInfo* pSendFileInfo;
	for ( pSendFileInfo = m_SendFileInfo.first(); pSendFileInfo; pSendFileInfo = m_SendFileInfo.next() )
		if ( pSendFileInfo )
			if ( pSendFileInfo->getSSCookie() == sCookie )
				return pSendFileInfo;
	return 0;
}

/*!
  DP Cookie값으로 파일 정보 Class를 구하는 함수.
*/
SendFileInfo * P2PConnection::getSendFileInfoByDPCookie(QString sCookie)
{
	SendFileInfo* pSendFileInfo;
	for ( pSendFileInfo = m_SendFileInfo.first(); pSendFileInfo; pSendFileInfo = m_SendFileInfo.next() )
		if ( pSendFileInfo->getDPCookie() == sCookie )
			return pSendFileInfo;
	return 0;
}

SendFileInfo * P2PConnection::getSendFileInfoByID(QString sID)
{
	SendFileInfo* pSendFileInfo;

	for ( pSendFileInfo = m_SendFileInfo.first(); pSendFileInfo; pSendFileInfo = m_SendFileInfo.next() )
		if  ( ( pSendFileInfo->getYourID() == sID ) &&  ( !pSendFileInfo->isConnected() ) )
			return pSendFileInfo;
	return 0;
}

SendFileInfo * P2PConnection::getSendFileInfoByDPTid(int sTid)
{
	SendFileInfo* pSendFileInfo;

	for ( pSendFileInfo = m_SendFileInfo.first(); pSendFileInfo; pSendFileInfo = m_SendFileInfo.next() )
		if  ( pSendFileInfo->getDPTid() == sTid )
			return pSendFileInfo;
	return 0;
}


/*!
  ATHC를 받으면...
*/
void P2PConnection::gotATHC(const QStringList & slCommand, SendFileInfo * pSendFileInfo)
{
	QString sCommand;
	sCommand = "FILE";
	sCommand += " ";
	sCommand += QString::number(getTrid());
	sCommand += " ";
	sCommand += "ACCEPT";
	sCommand += " ";
	sCommand += pSendFileInfo->getSSCookie();
	sCommand += " ";
	sCommand += "0";
	sCommand += "\r\n";

	sendCommand_noTid(pSendFileInfo->getSocket(), sCommand);

	emit AcceptOk(pSendFileInfo);
}

int P2PConnection::sendCommand(QSocket * pSocket, const QString & sPrefix, const QString & sText)
{
	QTextStream stream( pSocket );
	int nTid = getTrid();

	QString sCommand = sPrefix + " " + QString::number(nTid) + " " + sText;
	stream << sCommand; // << endl;

	pSocket->flush();

	emit OutgoingMessage("[ P2P ] {" + sCommand +"}");

	return nTid;
}

void P2PConnection::sendCommand_noTid(QSocket * pSocket, const QString & sText)
{
	QTextStream stream( pSocket );
	stream << sText; // << endl;

	pSocket->flush();

	emit OutgoingMessage("[ P2P ] {" + sText +"}");

	return;
}

/*!
  명령어 TID 값, 명령어 입력때 마다 증가가 된다.
*/
int P2PConnection::getTrid()
{
	return m_nTrid++;
}

void P2PConnection::SendFile(QSocket * socket, Client * client, unsigned long ulStart)
{
	// QDataStream stream(socket);
	// double ulTotal = 0;
	double ulSum = 0;
	int nIdx = 0;
	int nPercent = 0;


	SendFileInfo* pSendFileInfo;
	pSendFileInfo = client->fileInfo();

	if (!pSendFileInfo)
	{
		return;
	}

	/*!
	QSocketDevice * pSockDev = socket->socketDevice ();
	pSockDev->setBlocking ( TRUE );
	 */

	QFile *pFile = new QFile( pSendFileInfo->getFileName() );
	bool bOpen = pFile->open( IO_Raw | IO_ReadOnly );
	if ( !bOpen )
	{
#ifdef NETDEBUG
		kdDebug() << "Open_Error !!!" << endl;
#endif
		return;
	}
	
	bool bRet = pFile->at( ulStart );
	if ( !bRet )
	{
#ifdef NETDEBUG
		kdDebug() << "Open_at_Error !!!" << endl;
#endif
		return;
	}

	pSendFileInfo->setFile( pFile );
	
	QSocketNotifier *sn = new QSocketNotifier( socket->socket(), QSocketNotifier::Write );
	pSendFileInfo->setSocketNotifier( sn );
	connect( sn, SIGNAL( activated( int ) ), SLOT( slotSendFile( int ) ) );
}

void P2PConnection::slotSendFile(int nSocket)
{
	SendFileInfo* pSendFileInfo	= getSendFileInfoBySocket( nSocket );

	if ( ! pSendFileInfo )
		return;

	if ( pSendFileInfo->isCanceled() )
	{
		pSendFileInfo->getChatView()->sendFILE_CANCEL( pSendFileInfo->getSSCookie() );
		pSendFileInfo->getSocket()->flush();
		pSendFileInfo->getSocketNotifier()->setEnabled( FALSE );
		pSendFileInfo->getFile()->close();
		return;
	}

	if ( pSendFileInfo->getFile()->atEnd() )
	{
		pSendFileInfo->getSocketNotifier()->setEnabled( FALSE );
		pSendFileInfo->getFile()->close();
		return;
	}
	
	char data[8192];
	// data = (char*)malloc(8192);
	memset(data, 0x00, 8192);
	unsigned long ulDataLength = pSendFileInfo->getFile()->readBlock(data, 4096);
	
	QCString header;
	header = "FILE " + QString::number( ++(pSendFileInfo->m_nCount) ) +" DATA " + QString::number(ulDataLength) + "\r\n";
	
	int rawSize = ulDataLength + header.length();
	
	char *rawData = new char[rawSize];
	memcpy( rawData, header, header.length() );
	memcpy( rawData + header.length(), data, ulDataLength);
	
	QString sTemp;
	sTemp = header.stripWhiteSpace();
	sTemp += " [Size: ";
			// sTemp += QString::number( header.length() + ulDataLength );
	sTemp += QString::number( rawSize );
	sTemp += "bytes]";
	
	emit OutgoingMessage("[ P2P ] {" + sTemp +"}");
	
	int nRet = pSendFileInfo->getSocket()->writeBlock( rawData, rawSize );
	
	if ( nRet == -1 )
	{
#ifdef NETDEBUG
		kdDebug() << "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" << endl;
#endif
		pSendFileInfo->getSocketNotifier()->setEnabled( FALSE );
		pSendFileInfo->getFile()->close();
		return;
	}
	
	emit updateProgress( pSendFileInfo->getSSCookie(), pSendFileInfo->getSum(), pSendFileInfo->getFileSize(), pSendFileInfo->getPercent( ulDataLength ) );
}


void P2PConnection::RecvFile(QSocket * socket, Client * client)
{
	QCString pData;

	char rawblock[2048];
	memset(rawblock, 0x00, 2048);

	QCString sCommandLine;
	QStringList slCommand;
	int nBytesRemaining, nBytesRead;
  
	float ulTotal = 0.0;
	float ulSum = 0.0;
	KNateonBuffer m_Buffer;

	do
	{
		// Read in a block from the socket
		nBytesRead = socket->readBlock( rawblock, 1024 );

		// Find out how much data remains in the socket
		nBytesRemaining = socket->bytesAvailable();

		// If the noBytesRead is less than zero, it's an error code, so exit
		if ( nBytesRead < 0 )
		{
			//KMessageBox::error(0, i18n("adwaawawdaw"));
			return;
		}

		/*! 전송된 파일 받는 부분 */
		if ( client->isBin() )
		{
			SendFileInfo* pSendFileInfo = client->fileInfo();

			if ( pSendFileInfo->isCanceled() )
			{
				pSendFileInfo->getChatView()->sendFILE_CANCEL( pSendFileInfo->getSSCookie() );
				pSendFileInfo->getSocket()->flush();
				// socket->close();
				return;
			}

			client->addPacket(rawblock, nBytesRead);

			KNateonBuffer bTemp;
			bTemp = client->getPacket();

			if ( client->isDone() )
			{
				unsigned long bSize = bTemp.size();
				client->writeSaveFile( bTemp.left(bSize), bSize );

				sendCommand(socket, "FILE", "END N 0\r\n");
				client->closeSaveFile();
				client->setText();

				ulTotal = client->getFileSize();

				emit updateProgress( pSendFileInfo->getSSCookie(), ulTotal, ulTotal, 100);
				// emit finishTransfer( pSendFileInfo->getSSCookie() );
				emit finishTransfer( pSendFileInfo );
				return;
			}

			
			QString sFindString;
			sFindString.sprintf("FILE %d DATA ", client->getPacketNum() );
			int nFind = bTemp.findString((char*) sFindString.ascii() );
			
			/*
			int nFind = bTemp.findString((char*) "FILE " );
			int nFind2 = bTemp.findString((char*) " DATA " );
			if ( nFind != -1 && nFind2 != -1 )
			*/
			// int nFind = bTemp.findString_re( "DATA" );
			// kdDebug() << "FILE xx DATA : " << nFind << endl;
			if ( nFind != -1 )
			{
				client->incPacketNum();
				char *pData = bTemp.data();
				char *ch = (pData + nFind);
				int i=0;
				bool bFound = false;
				while(1)
				{
					if (*ch == '\n')
					{
						bFound = true;
						break;
					}
					ch++;
					if ( ( bTemp.size() - (nFind + i) ) <= 0)
						break;

					i++  ;
				}
				/*! \n 이 없으면 한번더 패킷을 받는다. */
				if (bFound)
				{
					char sCmd[1024];
					memset(sCmd, 0x00, 1024);
					strncpy(sCmd, (pData+nFind), i);

					int nPSize = nFind;
					client->writeSaveFile(bTemp.left(nPSize), nPSize);
					ulSum = (float) client->getPacketSum();
					ulTotal = (float) client->getFileSize();
					int nPercent = (int)((ulSum / ulTotal) * 100);

					// SendFileInfo* pSendFileInfo = client->fileInfo();
					emit updateProgress( pSendFileInfo->getSSCookie(), ulSum, ulTotal, nPercent );
					client->removePacket(nPSize + i + 1);
					emit IncomingMessage("[ P2P ]-{" + QString(sCmd) + "}-");
				}
			}
		}
		else
		{
			// QString pRaw( rawblock );
			m_Buffer.add( rawblock, nBytesRead );
			while ( true )
			{
				int nIndex = m_Buffer.findNewline();
				if (nIndex == -1) break;

				sCommandLine = m_Buffer.left( nIndex );

				emit IncomingMessage("[ P2P ] {" + sCommandLine + "}");

				slCommand = QStringList::split( " ", QString::fromUtf8( sCommandLine ) );

				if ( slCommand[0] == "ATHC")
				{
					if (slCommand[2] != "100") /*! 리눅스가 P2P 서버 */
					{
						/*!
						  로컬 컴퓨터의 P2P nego를 위한 포트를 상대편에게 알려준다.
						  처음 P2P네고는 DP서버를 통해서 하고,
						  이후 nego는 6004번 포트로 하게 된다.
						  6004번 포트가 사용되고 있는지 확인해서 6005, 6006... 으로 증가해 가면서
						  사용할 수 있는 포트를 찾는다.
						*/
						sendCommand_noTid(socket, "ATHC " + slCommand[1] + " 100 6004 0\r\n");
						// sendCommand_noTid(socket, "ATHC " + slCommand[1] + " 100 0\r\n");
						SendFileInfo* pSendFileInfo = getSendFileInfoByDPCookie( slCommand[4] );
						if (pSendFileInfo)
						{
							if ( pSendFileInfo->isReceive() )
							{
								/*!
								  내가 파일을 받는 쪽이면, SSCookie와 DPCookie를 모두 가지고 있음.
								  DPCookie를 가지고 SendFileInfo를 찾고,
								  파일 받기를 수락(Accept) 하면, SendFileInfo의 SSCookie를 사용해서
								  상대에게 FILE 0 ACCEPT {SSCookie} 를 보냄.
								  상대는 SSCookie를 보고 등록되있는 SendFileInfo에서 찾아
								  해당 P2P 세션으로 파일을 전송하게 됨.
								*/
								/*! pSendFileInfo가 있고, 먼저 접속되있지 않을때 */
								pSendFileInfo->setSocket(socket);
								pSendFileInfo->setConnected();
								client->setSendFileInfo( pSendFileInfo );
								gotATHC(slCommand, pSendFileInfo);
							}
						}
					}
#if 0
					else /*! 상대가 P2P서버,  ATHC 0 100 6004 0 을 받았을때... */
					{
						SendFileInfo* pSendFileInfo = client->fileInfo();
						if ( pSendFileInfo )
							if ( pSendFileInfo->isReceive() ) /*! 파일을 받는것이면, Accept를 보냄. */
								gotATHC(slCommand, pSendFileInfo);
					}
#endif
				}
				else if (slCommand[0] == "FILE")
				{
					if ( slCommand[2] == "ACCEPT" )
					{
						/*!
						  slCommand[0] => FILE
						  slCommand[1] => 0
						  slCommand[2] => ACCEPT
						  slCommand[3] => 838472:934
						  slCommand[4] => 0
						*/
						SendFileInfo* pSendFileInfo;
						pSendFileInfo = getSendFileInfoBySSCookie( slCommand[3] );

						if (pSendFileInfo)
						{
							QString sCommand;
							QString sFileName;
							QString sFilePath(pSendFileInfo->getFileName());
							if ( sFilePath.findRev("/") != -1 )
								sFileName = sFilePath.right( sFilePath.length() - sFilePath.findRev("/") - 1 );
							else
								sFileName = sFilePath;

							sCommand = "FILE 0 INFO FILENAME ";

							/*
							  sCommand = "FILE 0 INFO ";
							  sCommand += sFileName;
							  sCommand += " ";
							*/
							sCommand += QString::number( pSendFileInfo->getFileSize() );
							sCommand += " CHAT 0\r\n";
							sendCommand_noTid(socket, sCommand);
#if 1
							/// ----
							pSendFileInfo->setSocket(socket);
							client->setSendFileInfo( pSendFileInfo );
							/// ----
#endif
						}
					}
					else if ( slCommand[2] == "START" )
					{
						SendFile( socket, client, slCommand[3].toULong() );
					}
					else if ( slCommand[2] == "END" )
					{
						socket->disconnect();
						socket->close();
						SendFileInfo* pSendFileInfo = client->fileInfo();
						// QString sCookie( pSendFileInfo->getSSCookie() );
						// delete client;
						// emit socket->connectionClosed();
						emit finishTransfer( pSendFileInfo );
					}
					else if ( slCommand[2] == "DATA" )
					{
						client->setBin();
						
						/*! 설정에서 저장 디렉토리를 가지고 와야 함. */
						if ( !QDir( stConfig.filedownloadpath ).exists() )
							stConfig.filedownloadpath = QDir::homeDirPath();
						client->openSaveFile( stConfig.filedownloadpath );
						
						/*! DATA 순서 번호 초기화 */
						client->setPacketNum( slCommand[1].toInt() + 1 );
						
						int nCmdLen = sCommandLine.length();
						client->addPacket( (rawblock + nCmdLen + 1), (nBytesRead - nCmdLen - 1) );
					}
					else if ( slCommand[2] == "INFO" )
					{
						sendCommand_noTid(socket, "FILE 0 START 0 0\r\n");
					}
				}
				else if ( slCommand[0] == "FRIN")
				{
					if ( slCommand[2] == "100" )
					{
						SendFileInfo* pSendFileInfo = client->fileInfo();
						emit sendCTOCFR( pSendFileInfo );
					}
				}
				m_Buffer.remove( nIndex + 2 );
			}
		}
		memset(rawblock, 0x00, 2048);
	}
	while(nBytesRemaining > 0);
}

void P2PConnection::sendAccept(SendFileInfo * pSendFileInfo)
{
/*
  QString sCommand;
  sCommand = "FILE ";
  sCommand += QString::number(getTrid()) + " ";
  sCommand += "ACCEPT ";
  sCommand += pSendFileInfo->getSSCookie() + " ";
  sCommand += "0\r\n";
  sendCommand_noTid(pSendFileInfo->getSocket(), sCommand);
*/
}

void P2PConnection::sendReject(SendFileInfo * pSendFileInfo)
{
	QString sCommand;
	sCommand = "FILE ";
	sCommand += QString::number(getTrid()) + " ";
	sCommand += "CANCEL ";
	sCommand += pSendFileInfo->getSSCookie() + " ";
	sCommand += "0\r\n";
	sendCommand_noTid(pSendFileInfo->getSocket(), sCommand);
}






#if 0
bool P2PConnection::openConnection()
{

}
#endif

#include "p2pconnection.moc"
