/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knateoncommon.h"
#include "addfriendview.h"

AddFriendView::AddFriendView(QWidget *parent, const char *name)
	: AddFriendForm(parent, name)
{
	initalize();
}


AddFriendView::~AddFriendView()
{
}


#include "addfriendview.moc"


void AddFriendView::initalize()
{
	lineeditID->setText( QString::null );
	texteditMessage->setText( QString::null );
	buttonRequire->setEnabled( FALSE );
	connect( buttonRequire, SIGNAL( clicked() ), SLOT( slotRequire() ) );
	connect( texteditMessage, SIGNAL( textChanged() ), SLOT( slotTextCheck() ) );
	// connect(buttonCancel, SIGNAL( clicked() ), this, SLOT( slotCancel() ) );
}

void AddFriendView::slotRequire()
{
	accept();
	emit addFriendRequire( this );
}

/*
  void AddFriendView::slotCancel()
  {
  reject();
  }
*/

void AddFriendView::clear()
{
	lineeditID->setText("");
	texteditMessage->setText("");
	comboBox1->setCurrentItem(0);
}



void AddFriendView::slotNotFound()
{
	KMessageBox::information (this, UTF8("아이디를 찾을 수 없습니다."), UTF8("친구 추가 에러") );
}

void AddFriendView::slotTextCheck()
{
	if ( texteditMessage->text(). stripWhiteSpace().length() == 0 )
		buttonRequire->setEnabled( FALSE );
	else
		buttonRequire->setEnabled( TRUE );
}
