/***************************************************************************
 *   Copyright (C) 2005 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "buddylist.h"


Buddy * BuddyList::getBuddyByHandle( const QString sHandle ) const
{
    QPtrListIterator<Buddy> iterator(m_BuddyList);
    Buddy *pBuddy;

    while(iterator.current() != 0)
    {
        pBuddy = iterator.current();
        if(pBuddy->getHandle() == sHandle)
        {
            return pBuddy;
        }
        ++iterator;
    }

    return 0;
}


QString BuddyList::getBuddyNickByHandle( const QString sHandle ) const
{
	Buddy *pBuddy;
	pBuddy = getBuddyByHandle(sHandle);

	return pBuddy->getNick();
}


const QPtrList< Buddy > & BuddyList::getBuddyList() const
{
    return m_BuddyList;
}

/*!
  \fn BuddyList::addBuddy(Buddy* pBuddy)
*/
Buddy* BuddyList::addBuddy(Buddy* pBuddy)
{
	m_BuddyList.append(pBuddy);
  
    // emit buddyAdded(pBuddy);
  
	return pBuddy;
}

Buddy* BuddyList::getBuddyByID(QString sID) const
{
	QPtrListIterator<Buddy> iterator(m_BuddyList);
	Buddy *pBuddy;
  
	while(iterator.current() != 0)
	{
		pBuddy = iterator.current();
		if(pBuddy->getUID() == sID)
		{
			return pBuddy;
		}
		++iterator;
	}
  
	return 0;
}

QString BuddyList::getBuddyIDByHandle(const QString sHandle) const
{
	Buddy *pBuddy;
	pBuddy = getBuddyByHandle(sHandle);
  
	return pBuddy->getUID();
}

const QPtrList< Buddy > & BuddyList::getBuddyListByGID(QString sGID)
{
	QPtrListIterator<Buddy> iterator(m_BuddyList);
	Buddy *pBuddy;
	QPtrList<Buddy> rBuddyList;
	rBuddyList.clear();
	while(iterator.current() != 0)
	{
		pBuddy = iterator.current();
		if ( pBuddy->getGID() == sGID )
		{
			rBuddyList.append(pBuddy);
		}
		++iterator;
	}
  
	return rBuddyList;
}

#include "buddylist.moc"



Buddy * BuddyList::getBuddyByCyworldCMN(QString sCMN) const
{
	QPtrListIterator<Buddy> iterator(m_BuddyList);
	Buddy *pBuddy;
	
	while(iterator.current() != 0)
	{
		pBuddy = iterator.current();
		if( pBuddy->getCyworld_CMN() == sCMN )
		{
			return pBuddy;
		}
		++iterator;
	}
	
	return 0;
}

Buddy * BuddyList::getBuddyByHompyMajorCMN(QString sCMN) const
{
	QPtrListIterator<Buddy> iterator(m_BuddyList);
	Buddy *pBuddy;
	
	while(iterator.current() != 0)
	{
		pBuddy = iterator.current();
		if( pBuddy->getMajorCMN() == sCMN )
		{
			return pBuddy;
		}
		++iterator;
	}
	
	return 0;
}