#include <qapplication.h>
#include "mykeyboard.h"
#include "mylineedit.h"

MyLineEdit::MyLineEdit( QWidget *parent, const char *name )
    : QLineEdit( parent, name )
{
}

MyLineEdit::~MyLineEdit()
{
}

void MyLineEdit::mouseReleaseEvent(QMouseEvent*)
{
	QPoint	point;

	MyKeyboard* keyboard = new MyKeyboard(this, "keyboard", true);

	//  Ű ġ 
	point = getPtKeyboard(keyboard);
	keyboard->move(point);

	keyboard->exec();
}

QPoint MyLineEdit::getPtKeyboard(MyKeyboard* keyboard)
{
	QWidget	*d = QApplication::desktop();
    int		w = d->width();		// ȭ üũ width
    int		h = d->height();	// ȭ üũ height
	QPoint	point;
	QPoint	ptTmp;

	// keyboard edit ġ ؿ ߵ Ѵ
	point = QPoint(mapToGlobal(rect().bottomLeft()));
	point.setY(point.y() + 26);

 	// ȭ鿵 Ѿ ġ Ѵ
	if (point.x() < 0)
	{
		point.setX(0);
	}
	else if (point.x() + keyboard->width() > w)
	{
		point.setX(w - keyboard->width());
	}
	if (point.y() < 0)
	{
		point.setY(0);
	}
	else if (point.y() + keyboard->height() > h)
	{
		ptTmp = QPoint(mapToGlobal(rect().topLeft()));
		point.setY(ptTmp.y() - keyboard->height());
	}

	return point;
}

void MyLineEdit::slotMyInsert(const QString& str)
{
	if (str == QString(QChar(0x08)))	// backspace  
		backspace();
	else
		insert(str);
}
