<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="kr.co.leaderway.mywork.menu.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="kr.co.leaderway.util.*" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>
<script type="text/javascript" src="js/dtree.js"></script>
<link type="text/css" rel="stylesheet" href="css/dtree.css">
<%

List<Menu> menuList = (List<Menu>) request.getAttribute("menuList");

String currentURL = UrlTool.getCurrentURL(request);

%>

<script language="JavaScript">

$(document).ready(function() {
    
	var menuNo = getURLParameter('menuNo');

	if (menuNo == 'null') {
		
	} else {	
		d.openTo(menuNo);
		menuView(menuNo);		
	}
	
});

function menuList(menuNo) {
	if (menuNo) {
		f.action = "MenuAction.do?mode=list_menu&menuNo=" + menuNo;
	} else {
		f.action = "MenuAction.do?mode=list_menu";
	}
	
	f.submit();
}

function menuLower(menuNo) {

	var url  = url_of_context + "/MenuAction.do";
	
	$.ajax({
		url: url,
		data: { mode: 'lower_menu',
			    no: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'json',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				
				if (dataGet[0].ok) {					
					menuList(dataGet[0].targetNo);
				} else {
					alert('error occurred while lowering menu:' + dataGet[0].message);
				}
				
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function menuModifyForm(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'modify_menu_form',
			    no: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'html',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				$('#menuInfoDiv').html(dataGet);
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function menuModify(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";
	
	$.ajax({
		url: url,
		data: { mode: 'modify_menu',
			    no: menuNo,
			    title: document.menuModifyForm.title.value,
			    url: document.menuModifyForm.url.value,
				isAjax: 'Y'
			  },
		dataType: 'json',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				
				if (dataGet[0].ok) {					
					menuList(dataGet[0].targetNo);
				} else {
					alert('error occurred while modifing menu:' + dataGet[0].message);
				}
				
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function menuRemove(menuNo) {
	if ( confirm("정말 삭제하시겠습니까?") ) {
		
		var url  = url_of_context + "/MenuAction.do";
		
		$.ajax({
			url: url,
			data: { 
					mode: 'delete_menu',
				    no: menuNo,
					isAjax: 'Y'
				  },
			dataType: 'json',
			cache: false,
			success: function(dataGet, status) {
				if (status == "success") {
					
					if (dataGet[0].ok) {						
						menuList();
					} else {
						alert('error occurred while removing menu:' + dataGet[0].message);
					}
					
				}
			},
			error: function(xhr, textStatus, errorThrown) {
				alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
			}
		});
		
	}
}

function menuAddBelowForm(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'add_menu_form',
			    no: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'html',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				$('#menuInfoDiv').html(dataGet);
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function menuAddBelow(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'add_menu',
				title: document.menuAddForm.title.value,
				url: document.menuAddForm.url.value,
			    holderNo: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'json',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				if (dataGet[0].ok) {					
					menuList(dataGet[0].targetNo);
				} else {
					alert('error occurred while adding menu:' + dataGet[0].message);
				}
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function menuView(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'view_menu',
			    no: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'html',
		cache: false,
		success: function(dataGet, textStatus) {
			if (textStatus == "success") {
				//alert(dataGet);
				$('#menuInfoDiv').html(dataGet);

			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function accessGroupAssignForm(menuNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'assign_menu_access_group_form',
			    no: menuNo,
				isAjax: 'Y'
			  },
		dataType: 'html',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				$('#menuInfoDiv').html(dataGet);
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
}

function addAccessGroup(menuNo) {

	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'add_access_group',
				no: menuNo,
				groupNo: document.menuAccessGroupAssignForm.groupNo.value,
				isAjax: 'Y'
			  },
		dataType: 'json',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				if (dataGet[0].ok) {					
					accessGroupAssignForm(dataGet[0].targetNo);
				} else {
					alert('error occurred while adding menu access group:' + dataGet[0].message);
				}
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
	
}

function deleteAccessGroup(menuNo, groupNo) {
	
	var url  = url_of_context + "/MenuAction.do";

	$.ajax({
		url: url,
		data: { mode: 'delete_access_group',
				no: menuNo,
				groupNo: groupNo,
				isAjax: 'Y'
			  },
		dataType: 'json',
		cache: false,
		success: function(dataGet, status) {
			if (status == "success") {
				if (dataGet[0].ok) {					
					accessGroupAssignForm(dataGet[0].targetNo);
				} else {
					alert('error occurred while deleting menu access group:' + dataGet[0].message);
				}
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem while retrieving the HTML data:\n" + xhr + ":" + textStatus + ":" + errorThrown);
		}
	});
	
}
</script>

<form name="f" method="post">

	
  	<!-- list -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB">
	  	<tr>
			<td width="30%" bgcolor="#FFFFFF" valign="top">
	         	<table width=200 bgcolor="#FFFFFF">
				    <div id="categoryTree">
					</div>
				</table>
         	</td>
         	<td width="70%" bgcolor="#FFFFFF" valign="top">
	         	<div id="menuInfoDiv"></div>
         	</td>
	  	</tr>	  	
  	</table>
  	<!-- /list -->	 
  		
</form>

<script>
 d = new dTree('d');
 
 //d.add(0,-1,'home', 'javascript:menuView(\'\');');
</script>
<%
Iterator menuIter = menuList.iterator();

while ( menuIter.hasNext() ) {
	Menu menu = (Menu)menuIter.next();
%>

<script>			
	d.add('<%=menu.getNo()%>','<%=menu.getHolderNo()%>','<%=menu.getTitle()%>','javascript:menuView(\'<%=menu.getNo()%>\');');		
</script>

<%
}
%>
<script>

document.getElementById('categoryTree').innerHTML=d;

</script>