package kr.co.leaderway.mywork.system.initialize;

import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import kr.co.leaderway.mywork.system.ConfigManager;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class ConfigInitialize extends HttpServlet {
	
	private CompositeConfiguration config = null;
	/**
	 * 
	 */

	public void init() throws ServletException {

		Enumeration names = getServletConfig().getInitParameterNames();
		
		config = new CompositeConfiguration();
		
		while (names.hasMoreElements()) {
			
			String name = (String)names.nextElement();
			String value = getServletConfig().getInitParameter(name).trim();
	
			System.out.println(name+" : "+value);

			if (name.startsWith("xml")) {
     
				try {
					System.out.println("Loading Config : " + value);
					config.addConfiguration(new XMLConfiguration(value));
					
				} catch (ConfigurationException e) {
					e.printStackTrace();
				}

			} else if (name.startsWith("properties")) {
				
				try {
					System.out.println("Loading Config : " + value);
					config.addConfiguration(new PropertiesConfiguration(value));
				} catch (ConfigurationException e) {
					
					e.printStackTrace();
				}
				
			} else {
          
			}
	
		}
		
		ConfigManager.getInstance().setConfig(config);
		
	}
	
}