package kr.co.leaderway.mywork.menu.action;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.common.form.ResponseForm;
import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.menu.model.Menu;
import kr.co.leaderway.mywork.right.model.AccessGroup;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.BindUtil;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import net.sf.json.JSONArray;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MenuAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	//private Log log = LogFactory.getLog(this.getClass());
	
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_menu")) {
			
			String addedMenuNo = add_menu(mapping, form, request, response);
			
			List<ResponseForm> list=new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo(addedMenuNo);
			responseForm.setMessage("ok!");
			responseForm.setOk(true);
			
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			
			/*
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			return redirect;
			*/

		} else if (mode.equals("add_menu_form")) {
			
			String holderNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
			request.setAttribute("holderNo", holderNo);
			request.setAttribute("contentTitle", "메뉴 관리 - 추가");
			return mapping.findForward("menu_add_form");
			
		} else if (mode.equals("view_menu")) {
			
			view_menu(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 관리 - 메뉴 정보보기");
			
			return mapping.findForward("menu_view");
			
		} else if (mode.equals("modify_menu_form")) {
			 
			view_menu(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "메뉴 관리 - 수정");	
			return mapping.findForward("menu_modify_form");
			
		} else if (mode.equals("modify_menu")) {
			
			modify_menu(mapping, form, request, response);
				
			List<ResponseForm> list=new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo((String)request.getParameter("no"));
			responseForm.setMessage("ok!");
			responseForm.setOk(true);
			
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			/*
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "view_menu");
			redirect.addParameter("no", no);
			return redirect;
			*/
			
		} else if (mode.equals("lower_menu")) {
			
			int result = lower_menu(mapping, form, request, response);
	
			List<ResponseForm> list = new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo((String)request.getParameter("no"));
			
			if (result == 1) {
				responseForm.setMessage("ok!");
				responseForm.setOk(true);
			} else {
				responseForm.setMessage("제일 마지막 메뉴이거나 변경중 오류가 발생하였습니다.");
				responseForm.setOk(false);
			}
			
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			
			/*
			String groupId_string = request.getParameter("groupId") != null ? (String) request.getParameter("groupId") : "";
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			redirect.addParameter("groupId", groupId_string );
			return redirect;
			*/
			
		} else if (mode.equals("delete_menu")) {
			
			int deletedCnt = delete_menu(mapping, form, request, response);
				
			List<ResponseForm> list=new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo((String)request.getParameter("no"));
			
			if (deletedCnt == 1) {
				responseForm.setMessage("ok!");
				responseForm.setOk(true);
			} else if (deletedCnt == 0){
				responseForm.setMessage("하위 메뉴가 있는 메뉴는 삭제하실 수 없습니다.");
				responseForm.setOk(false);
			} else {
				responseForm.setMessage("한개 이상의 메뉴가 삭제되었습니다. 프로그램 담당자에게 연락바랍니다.");
				responseForm.setOk(false);
			}
			
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			
			/*
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			return redirect;
			*/
			
		} else if (mode.equals("assign_menu_access_group_form")) {
			
			view_menu(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 관리 - 접근 권한 그룹 할당");		
			
			return mapping.findForward("menu_access_group_assign_form");
			
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
				
			List<ResponseForm> list=new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo((String)request.getParameter("no"));
						
			responseForm.setMessage("ok!");
			responseForm.setOk(true);
						
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			
			/*
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "assign_menu_form");
			redirect.addParameter("no", no);
			return redirect;
			*/
			
		} else if (mode.equals("delete_access_group")) {
				
			delete_access_group(mapping, form, request, response);
				
			List<ResponseForm> list=new ArrayList<ResponseForm>(); 
			
			ResponseForm responseForm = new ResponseForm();
			responseForm.setTargetNo((String)request.getParameter("no"));
						
			responseForm.setMessage("ok!");
			responseForm.setOk(true);
						
			list.add(responseForm);
			
			JSONArray jsonArray = JSONArray.fromObject(list);
			
			String showJsonObject = jsonArray.toString ();
			PrintWriter pw = response.getWriter();
			pw.write(showJsonObject);

			return null;
			
			/*
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "assign_menu_form");
			redirect.addParameter("no", no);
			return redirect;
			*/
			
	    } else { // list_menu
	    	
	    	list_menu(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "메뉴 관리 - 리스트");

	    	return mapping.findForward("menu_list");
	    	
	    }
		
	}
	
	private void list_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String holderNo = request.getParameter("holderNo") != null ? (String) request.getParameter("holderNo") : "";
		
		Menu menu = new Menu();
		menu.setHolderNo(holderNo);
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		List<Menu> menuList = menuService.getMenuList(menu);
		
		request.setAttribute("menuList", menuList);

	}

	private String add_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		//MenuNewForm menuForm = (MenuNewForm) form;
		Menu menu = new Menu();
		BindUtil.bind(request, menu);
		
		menu.setTitle(new String(menu.getTitle().getBytes("8859_1"),"UTF-8"));
		
		//PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.addMenu(menu);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return menu.getNo();
		
	}

	private int delete_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		Menu menu = new Menu();
		BindUtil.bind(request, menu);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		int deletedCnt = menuService.deleteMenu(menu.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
		return deletedCnt;

	}

	private void view_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		Menu menu = menuService.getMenuByNo(menuNo);
		
		request.setAttribute("menu", menu);		
		
		List<AccessGroup> accessGroupList  = menuService.getAccessGroupList(menuNo);
		
		request.setAttribute("accessGroupList", accessGroupList);	

	}

	private void modify_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		//MenuNewForm menuForm = (MenuNewForm) form;
		
		Menu menu = new Menu();
		BindUtil.bind(request, menu);
		
		menu.setTitle(new String(menu.getTitle().getBytes("8859_1"),"UTF-8"));
		//PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		
		menuService.updateMenu(menu);

	}
	
	private int lower_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
			
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		return menuService.lowerMenu(menuNo);
	
	}
	
	private void add_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
	
		String groupNo = request.getParameter("groupNo");
		
		//MenuForm menuForm = (MenuForm) form;
		
		//Menu menu = new Menu();
		//PropertyUtils.copyProperties(menu, menuForm);
		
		Menu menu = new Menu();
		BindUtil.bind(request, menu);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.addAccessGroup(menu, groupNo);
		
	}
	
	private void delete_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String groupNo = request.getParameter("groupNo");
		
		//MenuForm menuForm = (MenuForm) form;
		
		//Menu menu = new Menu();
		//PropertyUtils.copyProperties(menu, menuForm);
		Menu menu = new Menu();
		BindUtil.bind(request, menu);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.deleteAccessGroup(menu, groupNo);
	}
}
