package kr.co.leaderway.mywork.businessProcess.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkException.MyWorkNotAuthorizedException;
import kr.co.leaderway.mywork.businessProcess.BusinessProcessService;
import kr.co.leaderway.mywork.businessProcess.form.BusinessForm;
import kr.co.leaderway.mywork.businessProcess.form.BusinessProcessForm;
import kr.co.leaderway.mywork.businessProcess.model.Business;
import kr.co.leaderway.mywork.businessProcess.model.BusinessAssigneeInfo;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcess;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcessRoleGroupSearchParameter;
import kr.co.leaderway.mywork.businessProcess.model.BusinessSearchParameter;
import kr.co.leaderway.mywork.businessProcess.model.BusinessStatusInfo;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.extAttr.model.ExtAttr;
import kr.co.leaderway.mywork.extAttr.model.ExtAttrReferenced;
import kr.co.leaderway.mywork.network.NetworkService;
import kr.co.leaderway.mywork.network.form.NetworkForm;
import kr.co.leaderway.mywork.network.model.Network;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.statics.AccessType;
import kr.co.leaderway.mywork.statics.UserType;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.model.User;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class BusinessAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_business")) {
			
			add_business(mapping, form, request, response);
			
			BusinessForm businessForm = (BusinessForm) form;
			
			Business business = new Business();
			PropertyUtils.copyProperties(business, businessForm);
			
			String processNo = business.getProcessNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "list_business");
			redirect.addParameter("processNo", processNo);
			return redirect;

		} else if (mode.equals("add_business_form")) {
			
			list_accessible_process(mapping, form, request, response);
			
			list_process_ext_attr(mapping, form, request, response);
			
			list_process_step_ext_attr(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 추가");
			return mapping.findForward("business_add_form");
			
		} else if (mode.equals("view_business")) {
			
			view_business(mapping, form, request, response);
			request.setAttribute("contentTitle", "업무 관리 - 업무 정보보기");
			
			return mapping.findForward("business_view");
			
		} else if (mode.equals("modify_business_form")) {
			 
			view_business(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 수정");	
			return mapping.findForward("business_modify_form");
			
		} else if (mode.equals("modify_business")) {
			
			modify_business(mapping, form, request, response);
				
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "view_business");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_business")) {
			
			delete_business(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "list_business");
			return redirect;
				
		} else if (mode.equals("assign_access_group_form")) {
			
			view_business(mapping, form, request, response);
			request.setAttribute("contentTitle", "업무 관리 - 프로젝트 접근 그룹 할당");
			
			return mapping.findForward("business_access_group_assign_form");
		
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
			
			delete_access_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
	    	
		} else if (mode.equals("move_business_status_form")) {
			
			view_business(mapping, form, request, response);
			list_process_step_ext_attr(mapping, form, request, response);
			
			return mapping.findForward("business_status_move_form");
			
		} else if (mode.equals("move_business")) {
			
			move_business(mapping, form, request, response);
			
			String processNo = request.getParameter("processNo") != null ? request.getParameter("processNo") : "0";
			String roleNo = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessAction") );
			redirect.addParameter("mode", "list_business");
			redirect.addParameter("processNo", processNo);
			redirect.addParameter("roleNo", roleNo);
			return redirect;
			
		} else if (mode.equals("list_business")) {
			
			list_accessible_process(mapping, form, request, response);
			
			list_business(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 - 리스트");

	    	return mapping.findForward("business_list");
	    	
		} else if (mode.equals("list_business_treated_by_me")) {
	    	
			list_accessible_process(mapping, form, request, response);
			
	    	list_business_alter(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "업무 이력 - 리스트");
			
	    	return mapping.findForward("business_list_alter");
	    	
		} else { // list_accessible_process
			
			list_accessible_process(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 - 리스트");

	    	return mapping.findForward("process_accessible_list");
			
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_business(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String processNo = request.getParameter("processNo");
		
		String roleNo = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
		
		BusinessProcess businessProcess = new BusinessProcess();
		businessProcess.setNo(processNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("businessProcess", businessProcess, nowUserNo, Integer.parseInt(AccessType.browsing), remoteUserIpAddressBin)) {   // 비지니스 프로세스에 브라우징 권한이 있어야 비지니스 리스팅 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to list businesses on this business process");
		}
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		String status = request.getParameter("status") != null ? request.getParameter("status") : "0";
		
		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		BusinessSearchParameter businessSearchParameter = new BusinessSearchParameter();
		businessSearchParameter.setProcessNo(processNo);
		businessSearchParameter.setCurrentPage(page);
		businessSearchParameter.setRowsPerPage(per_page);
		businessSearchParameter.setTime(time);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		List businessProcessExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processNo);
		
		businessSearchParameter.setExtAttrs(businessProcessExtAttrList);
		
		if (roleNo.equals("0")) {
			businessSearchParameter.setStatus(status);
		} else {
			businessSearchParameter.setStatus(roleNo);
		}
		
		if (search.equals("title")) {
			businessSearchParameter.setTitle(search_string);
		} else if (search.equals("contents")) {
			businessSearchParameter.setContents(search_string);
		} else if (search.equals("writer")) {
			businessSearchParameter.setName(search_string);
		} else if (search.equals("title-contents")) {
			businessSearchParameter.setAll(search_string);
		}
		
		MyWorkList businessList = businessProcessService.getBusinessList(businessSearchParameter); 
		
		request.setAttribute("businessList", businessList);
		
		List roleList = rightService.getRoleRightListOnObjectByUserNo("businessProcess", businessProcess, nowUserNo);
		
		request.setAttribute("roleList", roleList);
	
	}

	private void list_business_alter(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String processNo = request.getParameter("processNo");
		
		String roleNo = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
		
		BusinessProcess businessProcess = new BusinessProcess();
		businessProcess.setNo(processNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("businessProcess", businessProcess, nowUserNo, Integer.parseInt(AccessType.browsing), remoteUserIpAddressBin)) {   // 비지니스 프로세스에 브라우징 권한이 있어야 비지니스 리스팅 가능
		throw new MyWorkNotAuthorizedException("user doesn't have right to list businesses on this business process");
		}
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		String status = request.getParameter("status") != null ? request.getParameter("status") : "0";
		
		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		BusinessSearchParameter businessSearchParameter = new BusinessSearchParameter();
		businessSearchParameter.setProcessNo(processNo);
		businessSearchParameter.setCurrentPage(page);
		businessSearchParameter.setRowsPerPage(per_page);
		businessSearchParameter.setTime(time);
		businessSearchParameter.setUserNo(nowUserNo);
		
		if (roleNo.equals("0")) {
			businessSearchParameter.setStatus(status);
		} else {
			businessSearchParameter.setStatus(roleNo);
		}
		
		if (search.equals("title")) {
			businessSearchParameter.setTitle(search_string);
		} else if (search.equals("contents")) {
			businessSearchParameter.setContents(search_string);
		} else if (search.equals("writer")) {
			businessSearchParameter.setName(search_string);
		} else if (search.equals("title-contents")) {
			businessSearchParameter.setAll(search_string);
		}
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		MyWorkList businessList = businessProcessService.getBusinessListAlter(businessSearchParameter); 
		
		request.setAttribute("businessList", businessList);
		
		List roleList = rightService.getRoleRightListOnObjectByUserNo("businessProcess", businessProcess, nowUserNo);
		
		request.setAttribute("roleList", roleList);
	
	}
	
	private void add_business(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BusinessForm businessForm = (BusinessForm) form;
		
		Business business = new Business();
		PropertyUtils.copyProperties(business, businessForm);
		
		HttpSession session = request.getSession();
		
		String processNo = business.getProcessNo();
		
		BusinessProcess businessProcess = new BusinessProcess();
		businessProcess.setNo(processNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("businessProcess", businessProcess, nowUserNo, Integer.parseInt(AccessType.write), remoteUserIpAddressBin)) {   // 비지니스 프로세츠에 쓰기 권한이 있어야 비지니스 추가 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to add business to this business process");
		}
		
		User user = new User();
		user.setNo(nowUserNo);
		business.setOwner(user);
		business.setUserNo(nowUserNo);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		
		List businessProcessExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processNo);
		
		Iterator businessProcessExtAttrListIter = businessProcessExtAttrList.iterator();
		
		List extAttrReferencedList = new ArrayList();
		
		while (businessProcessExtAttrListIter.hasNext()) {
			ExtAttr extAttr = (ExtAttr)businessProcessExtAttrListIter.next();
			
			String attrNo = extAttr.getNo();
			String attrTypeName = extAttr.getAttrTypeName();
			String attrDataType = extAttr.getAttrDataType();
			String attrTableName = extAttr.getAttrTableName();
			String attrTypeNo = extAttr.getAttrTypeNo();
			String attrDataValue = request.getParameter(attrTypeName);
			
			ExtAttrReferenced businessExtAttr = new ExtAttrReferenced();
			businessExtAttr.setAttrNo(attrNo);
			businessExtAttr.setAttrTypeNo(attrTypeNo);
			businessExtAttr.setAttrTypeName(attrTypeName);
			businessExtAttr.setAttrDataType(attrDataType);
			businessExtAttr.setAttrDataValue(attrDataValue);
			businessExtAttr.setAttrTableName(attrTableName);
			
			extAttrReferencedList.add(businessExtAttr);
		
		}
		
		String toBeStatus = businessProcessService.getStartBusinessStep(processNo);
		
		List businessProcessStepExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(toBeStatus);
		
		Iterator businessProcessStepExtAttrListIter = businessProcessStepExtAttrList.iterator();
		
		List extAttrStepReferencedList = new ArrayList();
		
		while (businessProcessStepExtAttrListIter.hasNext()) {
			ExtAttr extAttr = (ExtAttr)businessProcessStepExtAttrListIter.next();
			
			String attrNo = extAttr.getNo();
			String attrTypeName = extAttr.getAttrTypeName();
			String attrDataType = extAttr.getAttrDataType();
			String attrTableName = extAttr.getAttrTableName();
			String attrTypeNo = extAttr.getAttrTypeNo();
			String attrDataValue = request.getParameter(toBeStatus + "_" + attrTypeName);
			
			ExtAttrReferenced businessExtAttr = new ExtAttrReferenced();
			businessExtAttr.setAttrNo(attrNo);
			businessExtAttr.setAttrTypeNo(attrTypeNo);
			businessExtAttr.setAttrTypeName(attrTypeName);
			businessExtAttr.setAttrDataType(attrDataType);
			businessExtAttr.setAttrDataValue(attrDataValue);
			businessExtAttr.setAttrTableName(attrTableName);
			
			extAttrStepReferencedList.add(businessExtAttr);
			
		}
		
		business.setExtAttrReferencedList(extAttrReferencedList);
		business.setExtAttrStepReferencedList(extAttrStepReferencedList);
		
		String businessNo = businessProcessService.addBusiness(business);
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_business(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.deleteNetwork(networkForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_business(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String processNo = request.getParameter("selected_process_no") != null ? (String) request.getParameter("selected_process_no") : "";
		String businessNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		String roleNo = request.getParameter("roleNo") != null ? (String) request.getParameter("roleNo") : "";
		
		String toBeStatus = request.getParameter("toBeStatus") != null ? (String) request.getParameter("toBeStatus") : "";
		String toBeStepButtonName = request.getParameter("toBeStepButtonName") != null ? (String) request.getParameter("toBeStepButtonName") : "";
		String toBeStepLane = request.getParameter("toBeStepLane") != null ? (String) request.getParameter("toBeStepLane") : "";
		
		request.setAttribute("toBeStepButtonName", new String(toBeStepButtonName.getBytes("8859_1"),"UTF-8"));
		
		log.info("toBeStatus:" + toBeStatus);
		log.info("roleNo:" + roleNo);
		BusinessSearchParameter businessSearchParameter = new BusinessSearchParameter();
		businessSearchParameter.setNo(businessNo);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		List businessProcessExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processNo);
		
		businessSearchParameter.setExtAttrs(businessProcessExtAttrList);
		
		Business business = businessProcessService.findBusiness(businessSearchParameter);
		
		BusinessProcess businessProcess = new BusinessProcess();
		businessProcess.setNo(business.getProcessNo());
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("businessProcess", businessProcess, nowUserNo, Integer.parseInt(AccessType.read), remoteUserIpAddressBin)) {   // 비지니스 프로세스에 일기 권한이 있어야 비지니스 읽기 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to read business to this business process");
		}
		
		request.setAttribute("business", business);		
		
		List nextAvailableBusinessProcessStepList = businessProcessService.findNextAvailableBusinessProcessStepList(business.getStatusNo());
		request.setAttribute("nextAvailableBusinessProcessStepList", nextAvailableBusinessProcessStepList);
		log.info("nextAvailableBusinessProcessStepList size:" + nextAvailableBusinessProcessStepList.size());
		
		if (!toBeStatus.equals("") && !toBeStatus.equals("0")) {
				
			BusinessProcessRoleGroupSearchParameter businessProcessRoleGroupSearchParameter = new BusinessProcessRoleGroupSearchParameter();
			businessProcessRoleGroupSearchParameter.setProcessNo(business.getProcessNo());
			businessProcessRoleGroupSearchParameter.setRoleRight(toBeStatus);
			
			List businessProcessRoleGroupList = businessProcessService.findBusinessProcessRoleGroupList(businessProcessRoleGroupSearchParameter);
			request.setAttribute("businessProcessRoleGroupList", businessProcessRoleGroupList);
			
		}
		
		List businessStatusInfoList = (List) businessProcessService.findBusinessStatusList(businessSearchParameter);
		
		request.setAttribute("businessStatusInfoList", businessStatusInfoList);	

	}

	private void modify_business(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		Network network = new Network();
		PropertyUtils.copyProperties(network, networkForm);
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.updateNetwork(network);

	}
	
	private void add_access_group(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_access_right_string = request.getParameter("access_right");
		int selected_access_right = Integer.parseInt(selected_access_right_string);
		
		BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
		
		BusinessProcess businessProcess = new BusinessProcess();
		PropertyUtils.copyProperties(businessProcess, businessProcessForm);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.addAccessGroup(businessProcess, selected_groupno, selected_groupTypeNo, selected_access_right);
	
	}
	
	private void delete_access_group(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.deleteAccessGroup(selected_groupno);
	
	}
	
	private void list_accessible_process(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		List processAccessibleList = businessProcessService.getAccessibleBusinessProcessListByUserNo(nowUserNo); 
		
		request.setAttribute("processAccessibleList", processAccessibleList);
		
	}
	
	private void move_business(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		BusinessForm businessForm = (BusinessForm) form;
		
		Business business = new Business();
		PropertyUtils.copyProperties(business, businessForm);
		
		BusinessStatusInfo businessStatusInfo = new BusinessStatusInfo();
		businessStatusInfo.setBusinessNo(business.getNo());
		businessStatusInfo.setComments(business.getComments());
		
		BusinessProcess businessProcess = new BusinessProcess();
		businessProcess.setNo(business.getProcessNo());
		
		String toBeStatus = request.getParameter("toBeStatus") != null ? request.getParameter("toBeStatus") : "0";
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		
		BusinessSearchParameter businessSearchParameter = new BusinessSearchParameter();
		businessSearchParameter.setNo(business.getNo());
		Business businessNow = businessProcessService.findBusiness(businessSearchParameter);
		
		log.info("businessNow.getStatusNo():" + businessNow.getStatusNo());
		if (businessNow.getStepNo().equals("0")) {
			throw new Exception("businessStatusNo is invalid");
		}
		log.info("---------------------------------------------");
		log.info("---------------------------------------------");
		log.info("---------------------------------------------");
		log.info("---------------------------------------------");
		log.info("businessStatusNo:" + businessNow.getStatusNo());
		log.info("toBeStatus:" + toBeStatus);
		log.info("---------------------------------------------");
		log.info("---------------------------------------------");
		log.info("---------------------------------------------");
		
		int assignedCount = rightService.getAssignedCountWithInBusinessStatusOnBusinessProcess(businessNow.getStatusNo(), nowUserNo);
		
		log.info("assignedCount:" + assignedCount);
		
		if (assignedCount == 0) {
			throw new MyWorkNotAuthorizedException("this work is specifically assigned and you are not assigned to do this work for this business on this process");
		}
		
		if (!rightService.haveRole("businessProcess", businessProcess, nowUserNo, businessNow.getStepNo(), remoteUserIpAddressBin)) {   // 프로세스에 권한이 있어야 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to do this work on this process");
		}

		List extAttrStepReferencedList = new ArrayList();
		
		if (toBeStatus.equals("0")) { // backward
			
			BusinessStatusInfo beforeBusinessStatus = businessProcessService.findBeforeBusinessStatusInfo(businessNow.getStatusNo());
			businessStatusInfo.setStatus(beforeBusinessStatus.getStatus());
			
			List beforeBusinessAssigneeList = businessProcessService.findBusinessAssigneeList(beforeBusinessStatus.getNo());
			for (int i = 0 ; i < beforeBusinessAssigneeList.size() ; i++ ) {
				log.info("beforeBusinessAssigneeList:" + beforeBusinessAssigneeList.get(0).toString());
			}
			
			if (beforeBusinessAssigneeList.size() > 0) {
				BusinessAssigneeInfo businessAssigneeInfoGet = (BusinessAssigneeInfo)beforeBusinessAssigneeList.get(0);
				
				if (businessAssigneeInfoGet.getAssigneeType() != 0) {  // assignee 가 없는 경우
					businessStatusInfo.setBusinessAssigneeInfoList(beforeBusinessAssigneeList);
				}
			}
			
		} else {
			
			businessStatusInfo.setStatus(toBeStatus);
			
			
			String devListJoined = request.getParameter("devList") != null ? request.getParameter("devList") : "";
			log.info("devListJoined:" + devListJoined + ":");
			if (devListJoined.length() > 0) {
				String devs[] = devListJoined.split("@delimiter@");
				
				for (int i = 0 ; i < devs.length ; i++) {
					BusinessAssigneeInfo businessAssigneeInfo = new BusinessAssigneeInfo();
					businessAssigneeInfo.setAssignee(devs[i]);
					
					if (devs[i].substring(0, 4).equals("USER")) {
						businessAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.USER));
					} else if (devs[i].substring(0, 4).equals("USGR")) {
						businessAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.USERGROUP));
					} else if (devs[i].substring(0, 4).equals("ACGR")) {
						businessAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.ACCESSGROUP));
					} else {
						throw new Exception("assignee no invalid");
					}
		
					businessStatusInfo.addBusinessAssigneeInfo(businessAssigneeInfo);
		
				}
			}
			
			////////////////
			List businessProcessStepExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(toBeStatus);
			
			Iterator businessProcessStepExtAttrListIter = businessProcessStepExtAttrList.iterator();
			
			while (businessProcessStepExtAttrListIter.hasNext()) {
				ExtAttr extAttr = (ExtAttr)businessProcessStepExtAttrListIter.next();
				
				String attrNo = extAttr.getNo();
				String attrTypeName = extAttr.getAttrTypeName();
				String attrDataType = extAttr.getAttrDataType();
				String attrTableName = extAttr.getAttrTableName();
				String attrTypeNo = extAttr.getAttrTypeNo();
				String attrDataValue = request.getParameter(toBeStatus + "_" + attrTypeName);
				
				ExtAttrReferenced businessExtAttr = new ExtAttrReferenced();
				businessExtAttr.setAttrNo(attrNo);
				businessExtAttr.setAttrTypeNo(attrTypeNo);
				businessExtAttr.setAttrTypeName(attrTypeName);
				businessExtAttr.setAttrDataType(attrDataType);
				businessExtAttr.setAttrDataValue(attrDataValue);
				businessExtAttr.setAttrTableName(attrTableName);
				
				extAttrStepReferencedList.add(businessExtAttr);
				
			}
			
			///////////////////////
		}
		
		businessStatusInfo.setExtAttrStepReferencedList(extAttrStepReferencedList);
		businessStatusInfo.setUserNo(nowUserNo);
		
		businessProcessService.moveBusinessStatus(businessStatusInfo);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	}
	
	private void list_process_ext_attr(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
	
		String processNo = request.getParameter("processNo") != null ? (String) request.getParameter("processNo") : "";
	
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		
		List businessProcessExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processNo);
		request.setAttribute("businessProcessExtAttrList", businessProcessExtAttrList);
	
	}
	
	private void list_process_step_ext_attr(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String processStepNo = request.getParameter("toBeStatus") != null ? (String) request.getParameter("toBeStatus") : "";
		
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		
		if (processStepNo.equals("")) {
			String processNo = request.getParameter("processNo") != null ? (String) request.getParameter("processNo") : "";
			processStepNo = businessProcessService.getStartBusinessStep(processNo);
			request.setAttribute("toBeStatus", processStepNo);
		}
		List businessProcessStepExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processStepNo);
		request.setAttribute("businessProcessStepExtAttrList", businessProcessStepExtAttrList);
	
	}
	
		
}