package kr.co.leaderway.mywork.MyWorkaction.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.MyWorkAction.MyWorkActionService;
import kr.co.leaderway.mywork.MyWorkAction.model.MyWorkActionGroup;
import kr.co.leaderway.mywork.MyWorkaction.form.MyWorkActionGroupForm;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class MyWorkActionGroupAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_action_group")) {
			
			add_action_group(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionGroupAction") );
			redirect.addParameter("mode", "list_action_group");
			return redirect;

		} else if (mode.equals("add_action_group_form")) {
			request.setAttribute("contentTitle", "액션 관리 - 그룹 추가");
			return mapping.findForward("action_group_add_form");
			
		} else if (mode.equals("view_action_group")) {
			
			view_action_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "액션 관리 - 액션 그룹 상세 보기");
			
			return mapping.findForward("action_group_view");
			
		} else if (mode.equals("modify_action_group_form")) {
			request.setAttribute("contentTitle", "액션 관리 - 액션 그룹 수정");
			view_action_group(mapping, form, request, response);
				
			return mapping.findForward("action_group_modify_form");
			
		} else if (mode.equals("modify_action_group")) {
			
			modify_action_group(mapping, form, request, response);
				
			MyWorkActionGroupForm myWorkActionGroupForm = (MyWorkActionGroupForm) form;
			String no = myWorkActionGroupForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionGroupAction") );
			redirect.addParameter("mode", "view_action_group");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("assign_holder_form")) {
			
			view_action_group(mapping, form, request, response);
			
			return mapping.findForward("holder_assign_form");
			
		/*
		} else if (mode.equals("assign_holder")) {
				
			assign_holder(mapping, form, request, response);
					
			String menuGroupId = request.getParameter("no");
			int menuGroupNo = Integer.parseInt(menuGroupId);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionGroupAction") );
			redirect.addParameter("mode", "assign_holder_form");
			redirect.addParameter("no", menuGroupNo);
			return redirect;
		*/	
		} else if (mode.equals("delete_action_group")) {
			
			delete_action_group(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionGroupAction") );
			redirect.addParameter("mode", "list_action_group");
			return redirect;
		
		/*
		} else if (mode.equals("delete_assigned")) {
			
			delete_assigned(mapping, form, request, response);
				
			String menuGroupId = request.getParameter("no");
			int menuGroupNo = Integer.parseInt(menuGroupId);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionGroupAction") );
			redirect.addParameter("mode", "assign_holder_form");
			redirect.addParameter("no", menuGroupNo);
			return redirect;
		*/
	    } else { // list_action_group
	    	
	    	list_action_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "액션 관리 - 액션 그룹 리스트");
	    	return mapping.findForward("action_group_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_action_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		List actionGroupList = myWorkActionService.getActionGroupList();
		
		request.setAttribute("actionGroupList", actionGroupList);
		
	}

	private void add_action_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionGroupForm actionGroupForm = (MyWorkActionGroupForm) form;
		
		MyWorkActionGroup actionGroup = new MyWorkActionGroup();
		PropertyUtils.copyProperties(actionGroup, actionGroupForm);
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.addActionGroup(actionGroup);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_action_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionGroupForm myWorkActionGroupForm = (MyWorkActionGroupForm) form;

		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.deleteActionGroup(myWorkActionGroupForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_action_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String actionGroupNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";

		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		MyWorkActionGroup actionGroup = myWorkActionService.getActionGroupByNo(actionGroupNo);
		
		request.setAttribute("actionGroup", actionGroup);		

	}

	private void modify_action_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionGroupForm myWorkActionGroupForm = (MyWorkActionGroupForm) form;
		
		MyWorkActionGroup myWorkActionGroup = new MyWorkActionGroup();
		PropertyUtils.copyProperties(myWorkActionGroup, myWorkActionGroupForm);

		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.updateActionGroup(myWorkActionGroup);

	}
	
	/*
	private void assign_holder(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupId = request.getParameter("no");
		int menuGroupNo = Integer.parseInt(menuGroupId);
		
		String assignNo_string = request.getParameter("assign_no");
		int assignNo = Integer.parseInt(assignNo_string);
		
		//MenuGroupManager manager = MenuGroupManager.instance();
		//manager.assignHolder(menuGroupNo, assignNo);	
		MenuServiceDelegate menuService = new MenuServiceDelegate(ServiceType.ServiceLocal);
		menuService.assignHolder(menuGroupNo, assignNo);
	
	}
	
	private void delete_assigned(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupId = request.getParameter("no");
		int menuGroupNo = Integer.parseInt(menuGroupId);
		
		String assigned_no_string = request.getParameter("assigned_no");
		int assignedNo = Integer.parseInt(assigned_no_string);
		
		//MenuGroupManager manager = MenuGroupManager.instance();
		//manager.deleteHolder(menuGroupNo, assignedNo);	
		MenuServiceDelegate menuService = new MenuServiceDelegate(ServiceType.ServiceLocal);
		menuService.deleteHolder(menuGroupNo, assignedNo);
	
	}
	*/
	
}
