package kr.co.leaderway.mywork.MyWorkaction.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.MyWorkAction.MyWorkActionService;
import kr.co.leaderway.mywork.MyWorkAction.model.MyWorkAction;
import kr.co.leaderway.mywork.MyWorkAction.model.MyWorkActionSearchParameter;
import kr.co.leaderway.mywork.MyWorkaction.form.MyWorkActionForm;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class MyWorkActionAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_action")) {
			
			add_action(mapping, form, request, response);
			
			MyWorkActionForm actionForm = (MyWorkActionForm) form;
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionAction") );
			redirect.addParameter("mode", "list_action");
			redirect.addParameter("groupId", actionForm.getMethodGroup());
			return redirect;

		} else if (mode.equals("add_action_form")) {
			
			request.setAttribute("contentTitle", "액션 관리 - 추가");
			return mapping.findForward("action_add_form");
			
		} else if (mode.equals("view_action")) {
			
			view_action(mapping, form, request, response);
			request.setAttribute("contentTitle", "액션 관리 - 액션 정보보기");
			return mapping.findForward("action_view");
			
		} else if (mode.equals("modify_action_form")) {
			
			view_action(mapping, form, request, response);
			request.setAttribute("contentTitle", "액션 관리 - 액션 정보 수정");
			return mapping.findForward("action_modify_form");
			
		} else if (mode.equals("modify_action")) {
			
			modify_action(mapping, form, request, response);
				
			MyWorkActionForm actionForm = (MyWorkActionForm) form;
			String no = actionForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionAction") );
			redirect.addParameter("mode", "view_action");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_action")) {
			
			delete_action(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionAction") );
			redirect.addParameter("mode", "list_action");
			return redirect;
			
		} else if (mode.equals("assign_action_form")) {
			
			view_action(mapping, form, request, response);
			request.setAttribute("contentTitle", "액션 관리 - 액션 access 그룹 할당");
			return mapping.findForward("action_assign_form");
			
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
				
			MyWorkActionForm actionForm = (MyWorkActionForm) form;
			String no = actionForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionAction") );
			redirect.addParameter("mode", "assign_action_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
				
			delete_access_group(mapping, form, request, response);
				
			MyWorkActionForm actionForm = (MyWorkActionForm) form;
			String no = actionForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MyWorkActionAction") );
			redirect.addParameter("mode", "assign_action_form");
			redirect.addParameter("no", no);
			return redirect;
				
	    } else { // list_action
	    	
	    	list_action(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "액션 관리 - 리스트");
	    	return mapping.findForward("action_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_action(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		String groupId = request.getParameter("groupId") != null ? (String) request.getParameter("groupId") : "";
		
		if (groupId.equals("") ) {
			groupId = "0";
		}

		MyWorkActionSearchParameter myWorkActionSearchParameter = new MyWorkActionSearchParameter();
		myWorkActionSearchParameter.setMethodGroup(groupId);
		myWorkActionSearchParameter.setCurrentPage(page);
		myWorkActionSearchParameter.setRowsPerPage(per_page);
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		MyWorkList actionList = myWorkActionService.getActionListByMethodGroup(myWorkActionSearchParameter);
		
		request.setAttribute("actionList", actionList);

	}

	private void add_action(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionForm actionForm = (MyWorkActionForm) form;
		
		MyWorkAction action = new MyWorkAction();
		PropertyUtils.copyProperties(action, actionForm);
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.addAction(action);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_action(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionForm actionForm = (MyWorkActionForm) form;
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.deleteAction(actionForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_action(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String actionNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		MyWorkAction action = myWorkActionService.getActionByNo(actionNo);
		
		request.setAttribute("action", action);		
		
		List accessGroupList = myWorkActionService.getAccessGroupListByNo(actionNo);
		
		request.setAttribute("accessGroupList", accessGroupList);		

	}

	private void modify_action(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MyWorkActionForm actionForm = (MyWorkActionForm) form;
		
		MyWorkAction action = new MyWorkAction();
		PropertyUtils.copyProperties(action, actionForm);
		
		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.updateAction(action);

	}
	
	private void add_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
	
		String selected_groupno = request.getParameter("selected_groupno");
		
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		
		MyWorkActionForm actionForm = (MyWorkActionForm) form;
		
		MyWorkAction action = new MyWorkAction();
		PropertyUtils.copyProperties(action, actionForm);

		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.addAccessGroup(action, selected_groupno, selected_groupTypeNo);
		
	}
	
	private void delete_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String selected_groupno = request.getParameter("selected_groupno");
		
		MyWorkActionForm actionForm = (MyWorkActionForm) form;
		
		MyWorkAction action = new MyWorkAction();
		PropertyUtils.copyProperties(action, actionForm);

		MyWorkActionService myWorkActionService = (MyWorkActionService)ServiceCallUtil.call(MyWorkActionService.class, getServiceType("MyWorkActionService"));
		myWorkActionService.deleteAccessGroup(selected_groupno);
		
	}
	
}
