package kr.co.leaderway.CustomTag.Paging;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class TotalRowsTag extends BodyTagSupport {
	public int doAfterBody() throws JspTagException	{
		int totalPage = 0;
		PagingTag parent = (PagingTag) findAncestorWithClass( this, PagingTag.class );
		
		if ( parent == null )	{
			throw new JspTagException( "부모 태그(PagingTag.class)가 없습니다." );
		}
		
		totalPage = Integer.parseInt( getBodyContent().getString().trim() );
		parent.setTotalRows( totalPage );
		
		return SKIP_BODY;
	}
}
