<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="java.lang.Math" %>
<%@ page import="kr.co.leaderway.mywork.schedule.model.*" %>
<%@ page import="kr.co.leaderway.util.DateTool" %>
<%@ page import="kr.co.leaderway.mywork.util.ColorTool" %>
<%@ page import="org.apache.commons.logging.Log" %>
<%@ page import="org.apache.commons.logging.LogFactory" %>

<%

Log log = LogFactory.getLog("schedule/show_day.jsp");

SolarLunarListSet solarLunarListSet = (SolarLunarListSet)request.getAttribute("solarLunarListSet");
String start_string = request.getParameter("start") == null ? "0" : (String)request.getParameter("start");
long start = Long.parseLong(start_string);
String end_string = request.getParameter("end") == null ? "0" : (String)request.getParameter("end");
long end = Long.parseLong(end_string);
String date_start = DateTool.TimeStampToDateString(start, "M/d");

String week_show_array[] = {"일", "월", "화", "수", "목", "금", "토"};

long target_start = start;
long target_end = end;

String target_date = DateTool.TimeStampToDateString(target_start, "yyyyMMdd");
System.out.println("target_date:" + target_date);

int target_year = Integer.parseInt(target_date.substring(0,4));
int target_month = Integer.parseInt(target_date.substring(4,6));
int target_day = Integer.parseInt(target_date.substring(6,8));
int target_week = DateTool.weekDayOfDate(target_year, target_month, target_day) - 1;

String target_month_show = "" + target_month;
String target_day_show = "" + target_day;

SolarLunar solarLunar = solarLunarListSet.getSolarLunarBySolarDate(target_date);
List nowScheduleList = solarLunar.getScheduleList();

String bgcolor = "#F5EDE3";

%>
<table width=100% cellspacing=0 border=0 cellpadding=0>
  <tr>
    <td width=100% bgcolor=#C5C5B5 class=middletitle style="line-height:300%">
       <font size=+3><%=target_month_show %> 월 <%=target_day_show %> 일</font>
       <font size=+1><%=week_show_array[target_week]%></font>
    </td>
  </tr>
</table>

<table width=100% cellspacing=0 border=0 cellpadding=0 bgcolor=#E6DDCC>
  <tr height=100%>
    <td width=20>
      <table width=100% cellspacing=1 border=0 cellpadding=2>
<%

     for (int j = 0 ; j < 24 ; j++) {
%>
       <tr>
         <td width=20 align="center" bgcolor=#D5CCBB>
           <%=j%>
         </td>
       </tr>
<%
     }
%>

      </table>
    </td>
<%
int scheduleCnt = nowScheduleList.size();
if (scheduleCnt == 0) {
   out.println("<td width=100% bgcolor=#F5EDE3></td>");
}

Iterator nowScheduleListIter = nowScheduleList.iterator();
while (nowScheduleListIter.hasNext()) {
	Schedule nowSchedule = (Schedule)nowScheduleListIter.next();
	
	double width = 100 / scheduleCnt;
	String width_string = width + "%";
%>
	<td width=" + width_string + " height="100%">
	<table width=100% height=100% cellspacing=1 border=0 cellpadding=2>
<%   
	String title = nowSchedule.getTitle();
	String title_view = "<a href = \"ScheduleAction.do?mode=view_schedule&no=" + nowSchedule.getNo() + "&category=" + nowSchedule.getCategory() + "\">" + nowSchedule.getTitle() + "</a>";
	String text = nowSchedule.getText();
	int eventType = nowSchedule.getEventType();
	int repeatType = nowSchedule.getRepeatType();
   
   	String content_bgcolor_temp = ColorTool.getColor(nowSchedule.getNo());
    String content_bgcolor = "#" + content_bgcolor_temp;
	
	double upper_height = 0;
	double lower_height = 0;
	String left_panel = "";
	String right_panel = "";
	String left_bgcolor = bgcolor;
	String right_bgcolor = bgcolor;
	String center_bgcolor = content_bgcolor;

	int target_day_now = 0;
	if (nowSchedule.getIsLunar() == 1) {
		target_day_now = Integer.parseInt(solarLunar.getLunarDate().substring(6,8));
	} else {
		target_day_now = Integer.parseInt(solarLunar.getSolarDate().substring(6,8));
	}	   

	String start_time_show = "";
	String end_time_show = "";
	double start_time_sec = 0;
	double end_time_sec = 0;
	int start_day = 0;
	int end_day = 0;
	double from_time = 0;
	double to_time = 0;
	double start_time = 0;
	double end_time = 0;
	
	if (eventType == 1) {
   		if (repeatType == 1) {
   			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	 		start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
	 		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	 		end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	 		
	 		upper_height = ((double)start_time_sec / 86400) * 100;
	 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	 
      	} else if (repeatType == 2) {
      		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	 
        	upper_height = ((double)start_time_sec / 86400) * 100;
	 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	 
		} else if (repeatType == 3) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
        
        	upper_height = ((double)start_time_sec / 86400) * 100;
	 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;

		} else if (repeatType == 4) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		 	end_time_sec = start_time_sec;
			
		 	upper_height = ((double)start_time_sec / 86400) * 100;
		 	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;

		} else if (repeatType == 5) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		 	end_time_sec = start_time_sec;
			
		 	upper_height = ((double)start_time_sec / 86400) * 100;
		 	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;

		}
	} else if (eventType == 2 || eventType == 4) {
		if (repeatType == 1) {
			long start_time_unixtimestamp = DateTool.dateStringToTimeStamp(nowSchedule.getFromDate() + nowSchedule.getFromTime(), "yyyyMMddhhmmss");
	        
	        start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	        long end_time_unixtimestamp_date = DateTool.dateStringToTimeStamp(nowSchedule.getToDate() + "000000", "yyyyMMddhhmmss");

	        end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
 			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	        double end_time_unixtimestamp = end_time_unixtimestamp_date + end_time_sec;
 			
	        upper_height = ((double)(start_time_unixtimestamp - target_start) / 86400) * 100;
	        lower_height = ((double)(target_end - end_time_unixtimestamp) / 86400) * 100;
	        
		} else if (repeatType == 2) {
			if (Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {
     			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		    	
		    	start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		    	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
				end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	
				upper_height = ((double)start_time_sec / 86400) * 100;
				lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
			} else {
		    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
		    		start_time_show = "";
		    		start_time_sec = 0;
		    	} else {
		    		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		    		start_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		    	}

		    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
		    		end_time_show = "";
		    		end_time_sec = 86400;
		    	} else {
		    		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		    		end_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		    	}

		    	upper_height = ((double)start_time_sec / 86400) * 100;
		    	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	
	        	left_panel = "<<";
	        	right_panel = ">>";
		    	left_bgcolor = content_bgcolor;
		    	right_bgcolor = content_bgcolor;
		    	center_bgcolor = bgcolor;
 			}

		} else if (repeatType == 3) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	
	     	if (nowSchedule.getFromWeek() < nowSchedule.getToWeek() || (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
		 		start_day = target_day - target_week + nowSchedule.getFromWeek();
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - target_week + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
	        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
	        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
	     	} else if (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) > Integer.parseInt(nowSchedule.getToTime()) && target_week == nowSchedule.getFromWeek()) {
		   		start_day = target_day;
		   		start_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		    	end_day = target_day;
		    	end_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	
		    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
		       		end_time_show = "";
		       		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
		       		start_time_show = "";
		       		from_time = target_start;
		    	}
	
		    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
	
	        	left_panel = "<<";
	        	right_panel = ">>";
		    	left_bgcolor = content_bgcolor;
		    	right_bgcolor = content_bgcolor;
		    	center_bgcolor = bgcolor;
	     	} else if (target_week < nowSchedule.getFromWeek()) {
		    	start_day = target_day - target_week - (7 - nowSchedule.getFromWeek());
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - target_week + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
		    	if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
		       		end_time_show = "";
		       		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
		       		start_time_show = "";
		       		from_time = target_start;
		    	}
	
		    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
	     	} else if (target_week >= nowSchedule.getFromWeek()) {
		    	start_day = target_day - target_week + nowSchedule.getFromWeek();
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - target_week + 7 + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
		 		if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
		       		end_time_show = "";
		      		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
		       		start_time_show = "";
		      		from_time = target_start;
		    	}
	
		    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		    	log.error("unhandled situation.. fix it!!");
		 	}

		} else if (repeatType == 4) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	
	     	if (nowSchedule.getFromDays() < nowSchedule.getToDays() || (nowSchedule.getFromDate().equals(nowSchedule.getToDate())) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {
		       	int month_modified = target_month + 1;
		       	int month_modified_minus = target_month - 1;
	           	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	           	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
				if (nowSchedule.getFromDays() < target_day_now) {
					upper_height = -1;
				} else if (nowSchedule.getFromDays() > target_day_now) {
					upper_height = -1;
				} else {
					upper_height = ((double)(from_time - target_start) / 86400) * 100;
				}
			
				if (nowSchedule.getToDays() < target_day_now) {
					lower_height = -1;
				} else if (nowSchedule.getToDays() > target_day_now) {
					lower_height = -1;
				} else {
					lower_height = ((double)(target_end - to_time) / 86400) * 100;
				}
	     	} else if (nowSchedule.getFromDays() <= target_day) {
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	int end_month = target_month + 1;
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
	        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		   		int from_month = target_month - 1;
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
	        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		 	}

		} else if (repeatType == 5) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		 	start_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		 	end_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		 	
	     	if (Integer.parseInt(nowSchedule.getFromDate()) < Integer.parseInt(nowSchedule.getToDate()) || (nowSchedule.getFromDate().equals(nowSchedule.getToDate()) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	       		to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
	       		upper_height = ((double)(from_time - target_start) / 86400) * 100;
	       		lower_height = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		    	int from_month_day = Integer.parseInt(nowSchedule.getFromDate().substring(2,6));
		    	int target_month_day = target_month + target_day;
	
		    	if (from_month_day <= target_month_day) {
		    		int target_year_modified = target_year + 1;
	        		from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        		to_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        		upper_height = ((double)(from_time - target_start) / 86400) * 100;
	        		lower_height = ((double)(target_end - to_time) / 86400) * 100;
		    	} else {
		    		int target_year_modified = target_year - 1;
	        		from_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getFromDate().substring(4,6)), Integer.parseInt(nowSchedule.getFromDate().substring(6,8)), Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        		to_time = DateTool.dateStringToTimeStamp(target_year, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        		upper_height = ((double)(from_time - target_start) / 86400) * 100;
	        		lower_height = ((double)(target_end - to_time) / 86400) * 100;
		    	}
		 	}
	
		}
	} else if (eventType == 3) {
		upper_height = 0;
		lower_height = 0;
	}
   
	if (upper_height < 0) {
		upper_height = 0;
		start_time_show = "<<";
	}
	if (lower_height < -0.002) {
		lower_height = 0;
		end_time_show = ">>";
	}
   
	double center_height = 100 - (upper_height + lower_height);
	  
	String title_in_content = "";
	String title_in_fore = nowSchedule.getTitle();
	String title_in_after = "";
	String start_time_in_content = "";
	String start_time_in_fore = start_time_show;
	String end_time_in_content = "";
	String end_time_in_after = end_time_show;
	
	if (center_height < 20 && (eventType == 2 || eventType == 4)) {
		
		if (upper_height > lower_height) {
	    	title_in_content = "";
			title_in_fore = title_view;
			title_in_after = "";
		} else {
			title_in_content = "";
			title_in_fore = "";
			title_in_after = nowSchedule.getTitle();
		}
	
		start_time_in_content = "";
		start_time_in_fore = start_time_show;
		end_time_in_content = "";
		end_time_in_after = end_time_show;

	} else if (center_height < 20 && eventType == 1) {
		if (upper_height > lower_height) {
			title_in_content = "";
			title_in_fore = title_view;
			title_in_after = "";
		} else {
			title_in_content = "";
			title_in_fore = "";
			title_in_after = title_view;
		}
		start_time_in_content = "";
		start_time_in_fore = start_time_show;
		end_time_in_content = "";
		end_time_in_after = "";
	} else if (eventType == 3) {
		title_in_fore = "";
		title_in_after = "";
		title_in_content = title_view;
		start_time_in_content = "00:00";
		start_time_in_fore = "";
		end_time_in_content = "24:00";
	} else {
		title_in_content = title_view;
		title_in_fore = "";
		title_in_after = "";
		start_time_in_fore = "";
		start_time_in_content = start_time_show;
		end_time_in_content = end_time_show;
		end_time_in_after = "";
	}

	
	String valign_upper = "bottom";
	String valign_lower = "top";

	

	
	if (upper_height > 0) {
%>
        <tr>
          <td width=100% height=<%=upper_height%>% bgcolor=<%=left_bgcolor%> id=111>
            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>
	      <tr>
	        <td align=left valign=top><%=left_panel%></td>
	      </tr>
	      <tr>
	        <td align="center" valign=bottom><b><%=title_in_fore%></b></td>
	      </tr>
<%  
		if (!start_time_in_fore.equals("")) {
%>
	      <tr>
	        <td height=10 align=left valign=bottom><%=start_time_in_fore%></td>
	      </tr>
<%
		}
%>
	    </table>
	  </td>
        </tr>
<%
	}
%>
        <tr>
          <td width=100% height=<%=center_height%>% bgcolor=<%=center_bgcolor%> id=222>
            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>
	      <tr>
	        <td align=left valign=top><%=start_time_in_content%></td>
	      </tr>
	      <tr>
	        <td align="center" valign=middle><b><%=title_in_content%></b></td>
	      </tr>
	      <tr>
	        <td align="right" valign=bottom><%=end_time_in_content%></td>
	      </tr>
	    </table>
	  </td>
        </tr>
<%
	if (lower_height > 0) {
%>
        <tr>
          <td width=100% height=<%=lower_height%>% bgcolor=<%=right_bgcolor%> id=333>
            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>
<% 
		if (!end_time_in_after.equals("")) {
%>
	      <tr>
	        <td height=10 align="right" valign=top><%=end_time_in_after%></td>
	      </tr>
<%
		}
%>
	      <tr>
	        <td align="center" valign=top><b><%=title_in_after%></b></td>
	      </tr>
	      <tr>
	        <td align="right" valign=bottom><%=right_panel%></td>
	      </tr>
	    </table>
	  </td>
        </tr>
<%
	}
%>
      </table>
    </td>
<%
}
%>
  </tr>
</table>