<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.schedule.model.*" %>
<%@ page import="kr.co.leaderway.util.DateTool" %>
<%@ page import="kr.co.leaderway.mywork.util.ColorTool" %>
<%@ page import="org.apache.commons.logging.Log" %>
<%@ page import="org.apache.commons.logging.LogFactory" %>

<%

Log log = LogFactory.getLog("schedule/calendar_with_content.jsp");

%>
<SCRIPT LANGUAGE="JavaScript">

var current_week_start = 0;

function mysubmit(){
	document.calendar.submit();
}

function view_schedule(scheduleNo) {
	url = "ScheduleAction.do?mode=view_schedule&no=" + scheduleNo + "&before_url=" + Base64.encode(getUrlWithoutHostAndContext());
	location.href = url;      
}

function click_action(this_start, this_end, span, category){

	if (span == 'month') {
	   this_span = '&monthspan=1';
	} else if (span == 'weekspan') {
	   this_span = '&weekspan=1';
	} else if (span == 'week') {
	   this_span = '&week=1';
	} else if (span == 'dayspan') {
	   this_span = '&dayspan=1';
	} else if (span == 'dayspan2') {
	   this_span = '&dayspan=2';
	} else {
	   this_span = '';
	}
	
	if (category != "") {
	   this_category = '&category=' + category;
	} else {
	   this_category = '';
	}

  	//location.href='ScheduleAction.do?start=' + this_start + '&end=' + this_end + this_span + this_category;
  
  	if (span == 'month') {
     
  	} else if (span == 'weekspan' || span == 'week') {

  	  	if (this_start == 0) {
  	  	  	this_start = current_week_start;
  	  	}

		var scheduleHolderArray = new Array();
		
		var nowTimestamp = new Date();
		
		for (var i = 0 ; i < 7 ; i++) {
			var now_start = this_start + (i * 86400);
			nowTimestamp.setTime(now_start * 1000);
			var nowYear = nowTimestamp.getFullYear();
			var nowMonth = nowTimestamp.getMonth() + 1;
			nowMonth = padLeft('' + nowMonth,2);
			var nowDay = nowTimestamp.getDate();
			nowDay = padLeft('' + nowDay,2);
			
			var nowDate = nowYear + nowMonth + nowDay;
			
			nowSchedule = schedule_now.getSchedule(nowDate);
			
			scheduleHolderArray.push(nowSchedule);
			
		}
	  
		showWeekSchedule(scheduleHolderArray);
	  
	} else {
	 
		var startTimestamp = new Date();
		startTimestamp.setTime(this_start * 1000);
		var startYear = startTimestamp.getFullYear();
		var startMonth = startTimestamp.getMonth() + 1;
		startMonth = padLeft('' + startMonth,2);
		var startDay = startTimestamp.getDate();
		startDay = padLeft('' + startDay,2);
		
		var startDate = startYear + startMonth + startDay;
		
		/*
		var endTimestamp = new Date();
		endTimestamp.setTime(this_end * 1000);
		var endYear = endTimestamp.getFullYear();
		var endMonth = endTimestamp.getMonth() + 1;
		endMonth = padLeft(endMonth,2);
		var endDay = endTimestamp.getDate();
		endDay = padLeft(endDay,2);
		var endDate = endYear + endMonth + endDay;
		*/
		
		var scheduleHolderGet = schedule_now.getSchedule(startDate);
		showDaySchedule(scheduleHolderGet);
		  
	}

}

function changeClassToUnSelected() {
	var start_date = schedule_now.getStartDate();
	var end_date = schedule_now.getEndDate();
	
	var startDateString = start_date + '';
	var start_year = startDateString.substring(0,4);
	var start_month = startDateString.substring(4,6);
	var start_day = startDateString.substring(6,8);
	
	var startDate = new Date(start_year, start_month - 1, start_day);
	var startTimeStamp = Math.floor(startDate.getTime()  / 1000);
	
	var now_date = start_date;
	var nowDate = new Date();
	for (var i = 0 ; now_date < end_date ; i++) {
		
		var nowTimeStamp = startTimeStamp + (86400 * i);
		nowDate.setTime(nowTimeStamp * 1000);
		 
		var nowYear = nowDate.getFullYear();
		var nowMonth = nowDate.getMonth() + 1;
		nowMonth = padLeft('' + nowMonth,2);
		var nowDay = nowDate.getDate();
		nowDay = padLeft('' + nowDay,2);
		
		now_date = nowYear + nowMonth + nowDay;
		
		var currentClass = getClass(now_date);

		if (currentClass == 'calendar_selected_cell_inrange' ) {
			changeClass(now_date, 'calendar_unselected_cell_inrange');
		} else if (currentClass == 'calendar_selected_cell_outrange' ) {
			changeClass(now_date, 'calendar_unselected_cell_outrange');
		} 
		
	}
}

function showWeekSchedule(scheduleHolderArray) {

	changeClassToUnSelected();
	
	var week_show_array = ["일", "월", "화", "수", "목", "금", "토"];

	var htmlString =  '<table width=100% cellspacing=1 border=0 cellpadding=2>';
	
	for (var i = 0 ; i < scheduleHolderArray.length ; i++) {

		var currentClass = getClass(scheduleHolderArray[i][0][0]);
		
		if (currentClass == 'calendar_unselected_cell_inrange' ) {
			changeClass(scheduleHolderArray[i][0][0], 'calendar_selected_cell_inrange');
		} else if (currentClass == 'calendar_unselected_cell_outrange' ) {
			changeClass(scheduleHolderArray[i][0][0], 'calendar_selected_cell_outrange');
		} 
		
		var target_year = scheduleHolderArray[i][0][0].substring(0,4);
		var target_month = scheduleHolderArray[i][0][0].substring(4,6);
		var target_day = scheduleHolderArray[i][0][0].substring(6,8);
	
		var date = new Date(target_year, target_month - 1, target_day);

		var target_start = Math.floor(date.getTime()  / 1000);
		var target_end = target_start + 86400;
		var target_week = date.getDay();

		var bgColor = '';
		
		var even = i % 2;
		if (even == 1) {
			bgColor = "#D5CCBB";
		} else {
			bgColor = "#E6DDCC";
		}
		
		var date_now = parseInt(target_month, 10) + '/' + parseInt(target_day, 10);

		htmlString += '	<tr>';
		htmlString += '		<td width="100" align="center" style="line-height:300%; cursor:pointer;" bgcolor=' + bgColor + '  class=middletitle>';
		htmlString += '  		<a href = javascript:onclick=click_action(' + target_start + ',' + target_end + ',"dayspan","1")><font size=+3>' + week_show_array[i] + '</font>';
		htmlString += '  		<br>' + date_now + '</a>';
		htmlString += '		</td>';
		htmlString += '		<td width=99% bgcolor=' + bgColor + '>';

		var scheduleHolder = scheduleHolderArray[i];
		if (scheduleHolder[0][4] == 0 && scheduleHolder[0][9] == 0 && scheduleHolder[0][14] == 0) {  // empty
			htmlString += '	<table width=100% cellspacing=1 border=0 cellpadding=2>';
			htmlString += '		<tr>';
			htmlString += '			<td width=100% bgcolor=' + bgColor + '></td>';
			htmlString += '		</tr>';
			htmlString += '	</table>';
		} else {
			htmlString += getShowDayInWeekScheduleHtml(scheduleHolder);
		}
		htmlString += '		</td>';
		htmlString += '	</tr>';
	}
	document.getElementById('contentDiv').innerHTML = htmlString;

	document.getElementById('week_schedule_show_button_td').style.display = 'none';

}

function getShowDayInWeekScheduleHtml(scheduleHolder) {
	
	var week_show_array = ["일", "월", "화", "수", "목", "금", "토"];

	var htmlString  = '';
	
	var target_year = scheduleHolder[0][0].substring(0,4);
	var target_month = scheduleHolder[0][0].substring(4,6);
	var target_day = scheduleHolder[0][0].substring(6,8);
	
	var date = new Date(target_year, target_month - 1, target_day);
	var target_week = date.getDay();

	for (var i = 0 ; i < scheduleHolder.length ; i++) {

		var fore_width = scheduleHolder[i][1];
		var left_bgcolor = scheduleHolder[i][2];
		var left_panel = scheduleHolder[i][3];
		var title_in_fore = scheduleHolder[i][4];
		var start_time_in_fore = scheduleHolder[i][5];
		
		var content_width = scheduleHolder[i][6];
		var center_bgcolor = scheduleHolder[i][7];
		var start_time_in_content = scheduleHolder[i][8];
		var title_in_content = scheduleHolder[i][9];
		var end_time_in_content = scheduleHolder[i][10];
		
		var after_width = scheduleHolder[i][11];
		var right_bgcolor = scheduleHolder[i][12];
		var end_time_in_after = scheduleHolder[i][13];
		var title_in_after = scheduleHolder[i][14];
		var right_panel = scheduleHolder[i][15];
		
		htmlString += '	<table width=100% cellspacing=1 border=0 cellpadding=2>';
		htmlString += '		<tr>';

   		if (fore_width > 0) {	

   			htmlString += '<td width=' + fore_width + '% bgcolor=' + left_bgcolor + '>';
   			htmlString += '<table width=100% cellspacing=0 border=0 cellpadding=0>';
   			htmlString += '<tr>';
   			htmlString += '	<td align=left>' + left_panel + '</td>';
   			htmlString += '	<td align="right"><b>' + title_in_fore + '</b></td>';
   			htmlString += '	<td align="right">' + start_time_in_fore + '</td>';
   			htmlString += '</tr>';
   			htmlString += '</table>';
   			htmlString += '</td>';

  		}
   
   		htmlString += '<td width=' + content_width + '% bgcolor=' + center_bgcolor + '>';
   		htmlString += '<table width=100% cellspacing=0 border=0 cellpadding=0>';
   		htmlString += ' <tr>';
   		htmlString += '   <td align=left>' + start_time_in_content + '</td>';
   		htmlString += '   <td align="center"><b>' + title_in_content + '</b></td>';
   		htmlString += '   <td align="right">' + end_time_in_content + '</td>';
   		htmlString += ' </tr>';
   		htmlString += '</table>';
   		htmlString += '</td>';

   		if (after_width > 0) {
     
   			htmlString += '<td width=' + after_width + '% bgcolor=' + right_bgcolor + '>';
   			htmlString += '<table width=100% cellspacing=0 border=0 cellpadding=0>';
   			htmlString += '<tr>';
   			htmlString += '<td align=left>' + end_time_in_after + '</td>';
   			htmlString += '<td align=left><b>' + title_in_after + '</b></td>';
   			htmlString += '<td align="right">' + right_panel + '</td>';
   			htmlString += '</tr>';
   			htmlString += '</table>';
   			htmlString += '</td>';

   		}

   		htmlString += '</tr>';  
   		htmlString += '</table>';

	}
	
	return htmlString;
	
}

function showDaySchedule(scheduleHolder) {

	changeClassToUnSelected();
	
	var currentClass = getClass(scheduleHolder[0][0]);

	if (currentClass == 'calendar_unselected_cell_inrange' ) {
		changeClass(scheduleHolder[0][0], 'calendar_selected_cell_inrange');
	} else if (currentClass == 'calendar_unselected_cell_outrange' ) {
		changeClass(scheduleHolder[0][0], 'calendar_selected_cell_outrange');
	} 
	
	var week_show_array = ["일", "월", "화", "수", "목", "금", "토"];

	var target_year = scheduleHolder[0][0].substring(0,4);
	var target_month = scheduleHolder[0][0].substring(4,6);
	var target_day = scheduleHolder[0][0].substring(6,8);
		
	var date = new Date(target_year, target_month - 1, target_day);
	var target_week = date.getDay();
	
	var htmlString =  '	<table width=100% cellspacing=0 border=0 cellpadding=0>';
		htmlString += '		<tr>';
		htmlString += '			<td width=100% bgcolor=#C5C5B5 class=middletitle style="line-height:300%">';
		htmlString += '   			<font size=+3>' + target_month + ' 월 ' + target_day + ' 일</font>';
		htmlString += '   			<font size=+1>' + week_show_array[target_week] + '</font>';
		htmlString += '  		</td>';
		htmlString += '  	</tr>';
		htmlString += '	</table>';

		htmlString += '<table width=100% cellspacing=0 border=0 cellpadding=0 bgcolor=#E6DDCC>';
		htmlString += '		<tr height=100%>';
		htmlString += '  		<td width=20>';
		htmlString += '    			<table width=100% cellspacing=1 border=0 cellpadding=2>';

	for (var i = 0 ; i < 24 ; i++) {
		htmlString += '	       			<tr>';
		htmlString += '         			<td width=20 align="center" bgcolor=#D5CCBB>';
	    htmlString += 							i;
	    htmlString += '         			</td>';
	    htmlString += '       			</tr>';
	}

		htmlString += '				</table>';
		htmlString += '			</td>';

	if (scheduleHolder[0][4] == 0 && scheduleHolder[0][9] == 0 && scheduleHolder[0][14] == 0) {  // empty
		htmlString += '			<td width=100% bgcolor=#F5EDE3></td>';
	} else {

		for (var i = 0 ; i < scheduleHolder.length ; i++) {

			var upper_height = scheduleHolder[i][1];
			var left_bgcolor = scheduleHolder[i][2];
			var left_panel = scheduleHolder[i][3];
			var title_in_fore = scheduleHolder[i][4];
			var start_time_in_fore = scheduleHolder[i][5];
			
			var center_height = scheduleHolder[i][6];
			var center_bgcolor = scheduleHolder[i][7];
			var start_time_in_content = scheduleHolder[i][8];
			var title_in_content = scheduleHolder[i][9];
			var end_time_in_content = scheduleHolder[i][10];
			
			var lower_height = scheduleHolder[i][11];
			var right_bgcolor = scheduleHolder[i][12];
			var end_time_in_after = scheduleHolder[i][13];
			var title_in_after = scheduleHolder[i][14];
			var right_panel = scheduleHolder[i][15];
			
			htmlString += '		<td width=" + width_string + " height="100%">';
			htmlString += '		<table width=100% height=100% cellspacing=1 border=0 cellpadding=2>';

			if (scheduleHolder[i][1] > 0) {
				htmlString += '		        <tr>';
				htmlString += '		          <td width=100% height=' + scheduleHolder[i][1] + '% bgcolor=' + scheduleHolder[i][2] + ' id=111>';
				htmlString += '		            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align=left valign=top>' + scheduleHolder[i][3] + '</td>';
				htmlString += '			      </tr>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align="center" valign=bottom><b>' + scheduleHolder[i][4] + '</b></td>';
				htmlString += '			      </tr>';
		 
				if (scheduleHolder[i][5] != "") {
			
				htmlString += '			      <tr>';
				htmlString += '			        <td height=10 align=left valign=bottom>' + scheduleHolder[i][5] + '</td>';
				htmlString += '			      </tr>';
			
				}
			
				htmlString += '			    </table>';
				htmlString += '			  </td>';
				htmlString += '		        </tr>';
			
			}
			
				htmlString += '		        <tr>';
				htmlString += '		          <td width=100% height=' + scheduleHolder[i][6] + '% bgcolor=' + scheduleHolder[i][7] + ' id=222>';
				htmlString += '		            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align=left valign=top>' + scheduleHolder[i][8] + '</td>';
				htmlString += '			      </tr>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align="center" valign=middle><b>' + scheduleHolder[i][9] + '</b></td>';
				htmlString += '			      </tr>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align="right" valign=bottom>' + scheduleHolder[i][10] + '</td>';
				htmlString += '			      </tr>';
				htmlString += '			    </table>';
				htmlString += '			  </td>';
				htmlString += '		        </tr>';
		
			if (scheduleHolder[i][11] > 0) {
				
				htmlString += '		        <tr>';
				htmlString += '		          <td width=100% height=' + scheduleHolder[i][11] + '% bgcolor=' + scheduleHolder[i][12] + ' id=333>';
				htmlString += '		            <table width=100% height=100% cellspacing=0 border=0 cellpadding=0>';
			
				if (scheduleHolder[i][13] != "") {
			
				htmlString += '			      <tr>';
				htmlString += '			        <td height=10 align="right" valign=top>' + scheduleHolder[i][13] + '</td>';
				htmlString += '			      </tr>';
			
				}
				
				htmlString += '			      <tr>';
				htmlString += '			        <td align="center" valign=top><b>' + scheduleHolder[i][14] + '</b></td>';
				htmlString += '			      </tr>';
				htmlString += '			      <tr>';
				htmlString += '			        <td align="right" valign=bottom>' + scheduleHolder[i][15] + '</td>';
				htmlString += '			      </tr>';
				htmlString += '			    </table>';
				htmlString += '			  </td>';
				htmlString += '		        </tr>';
			
			}
			
			htmlString += '		      </table>';
			htmlString += '		    </td>';
			
		}
			
		htmlString += '		  </tr>';
		htmlString += '		</table>';
	}

	document.getElementById('contentDiv').innerHTML = htmlString;

	document.getElementById('week_schedule_show_button_td').style.display = '';

	var date = new Date(target_year, target_month - 1, target_day);
	var target_week = date.getDay();
	
	current_week_start = Math.floor(date.getTime()  / 1000) - (target_week * 86400);
}

function ScheduleModule(scheduleList) {
	this.scheduleList = scheduleList;

	this.startDate = '00000000';
	this.endDate = '00000000';
}

ScheduleModule.prototype.addSchedule = function(	target_date,
		
													upper_height,
											      	left_bgcolor,
											    	left_panel,
											    	title_in_fore,
											    	start_time_in_fore,
											    											    	
											    	center_height,
											    	center_bgcolor,
											    	start_time_in_content,
											    	title_in_content,
											    	end_time_in_content,
											    											    	
											    	lower_height,
											    	right_bgcolor,
											    	end_time_in_after,
											    	title_in_after,
											    	right_panel) {
	var scheduleArray = [ 	target_date,
	                    	
	                    	upper_height,
	                    	left_bgcolor,
	                    	left_panel,
	                    	title_in_fore,
	                    	start_time_in_fore,
	                    	                    	
	                    	center_height,
	                    	center_bgcolor,
	                    	start_time_in_content,
	                    	title_in_content,
	                    	end_time_in_content,  
	                    	                  	
	                    	lower_height,
	                    	right_bgcolor,
	                    	end_time_in_after,
	                    	title_in_after,
	                    	right_panel];

	this.scheduleList.push(scheduleArray);	
}

ScheduleModule.prototype.getSchedule = function(target_date) {

	var nowScheduleList = new Array();
	for (var i = 0 ; i < this.scheduleList.length ; i++) {
		if (this.scheduleList[i][0] == target_date) {
			nowScheduleList.push(this.scheduleList[i]);
			
		}
	}

	if (nowScheduleList == '') {
		var emptySchedule = [target_date, '0', '0', '0', '0', '0' 
			  	  						, '0', '0', '0', '0', '0'	
			  	  						, '0', '0', '0', '0', '0'	];
		nowScheduleList.push(emptySchedule)
	}
	return nowScheduleList;
}

ScheduleModule.prototype.getAllSchedule = function() {
	return this.scheduleList;
}

ScheduleModule.prototype.setStartDate = function(startDate) {
	this.startDate = startDate;
}

ScheduleModule.prototype.setEndDate = function(endDate) {
	this.endDate = endDate;
}

ScheduleModule.prototype.getStartDate = function() {
	return this.startDate;
}

ScheduleModule.prototype.getEndDate = function() {
	return this.endDate;
}

var scheduleHolder = new Array();
var schedule_now = new ScheduleModule(scheduleHolder);

</SCRIPT>
<%

SolarLunarListSet solarLunarListSet = (SolarLunarListSet)request.getAttribute("solarLunarListSet");

LastSolarLunarOfLunarMonthListSet lastSolarLunarOfLunarMonthListSet = (LastSolarLunarOfLunarMonthListSet)request.getAttribute("lastSolarLunarOfLunarMonthListSet");

String year_string = request.getParameter("year") == null ? "0" : (String)request.getParameter("year");
int year = Integer.parseInt(year_string);
String month_string = request.getParameter("month") == null ? "0" : (String)request.getParameter("month");
int month = Integer.parseInt(month_string);
String day_string = request.getParameter("day") == null ? "0" : (String)request.getParameter("day");
int day = Integer.parseInt(day_string);
String week_string = request.getParameter("week") == null ? "0" : (String)request.getParameter("week");
int week = Integer.parseInt(week_string);
String start_string = request.getParameter("start") == null ? "0" : (String)request.getParameter("start");
long start = Long.parseLong(start_string);
String end_string = request.getParameter("end") == null ? "0" : (String)request.getParameter("end");
long end = Long.parseLong(end_string);
String dayspan_string = request.getParameter("dayspan") == null ? "0" : (String)request.getParameter("dayspan");
int dayspan = Integer.parseInt(dayspan_string);
String weekspan_string = request.getParameter("weekspan") == null ? "0" : (String)request.getParameter("weekspan");
int weekspan = Integer.parseInt(weekspan_string);
String monthspan_string = request.getParameter("monthspan") == null ? "0" : (String)request.getParameter("monthspan");
int monthspan = Integer.parseInt(monthspan_string);
String category_string = request.getParameter("category") == null ? "" : (String)request.getParameter("category");
String category_url = category_string;

long start_mod = 0;
int last_day = 0;
if (dayspan == 1) {
	start_mod = start + (86400 * 15);
	year = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "yyyy"));
	month = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "MM"));
	day = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "dd"));
} else if (dayspan == 2) {
	start_mod = start - (86400 * 15);
	year = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "yyyy"));
	month = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "MM"));
	day = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "dd"));
} else if (weekspan != 1 && start != 0) {
	year = Integer.parseInt(DateTool.TimeStampToDateString(start, "yyyy"));
	month = Integer.parseInt(DateTool.TimeStampToDateString(start, "MM"));
	day = Integer.parseInt(DateTool.TimeStampToDateString(start, "dd"));
} else if (weekspan == 1 && end != 0) {
	year = Integer.parseInt(DateTool.TimeStampToDateString(end, "yyyy"));
	month = Integer.parseInt(DateTool.TimeStampToDateString(end, "MM"));
	day = 1;
} else if (start == 0 && end == 0 && year != 0 && month != 0) {
  	day = 1;
  	start = DateTool.dateStringToTimeStamp(year, month, day, 0, 0, 0);
  	last_day = DateTool.lastDayOfMonth(year, month);
  	end = DateTool.dateStringToTimeStamp(year, month, last_day, 23, 59, 59);
  	monthspan = 1;
} else {
	year = DateTool.yearOfToday();
	month = DateTool.monthOfToday();
	day = DateTool.dayOfToday();

	last_day = DateTool.lastDayOfMonth(year, month);
	start = DateTool.dateStringToTimeStamp(year, month, 1, 0, 0, 0);
  	end = DateTool.dateStringToTimeStamp(year, month, last_day, 23, 59, 59);
  	monthspan = 1;

}

if(year > 0 || month > 0 || day > 0) { // 상황에 따라 현재 날자값을 설정한다.

    if(year > 9999) {
    	year = 9999;
    } else if(year < 1) {
    	year = 1;
    }

    if(month > 12) {
        year++;
        month = 1;
    } else if(month < 1) {
        year--;
        month = 12;
    }

    last_day = DateTool.lastDayOfMonth(year, month);

    if(day > last_day) {
        month++;
        day = 1;
        last_day = DateTool.lastDayOfMonth(year, month);
    } else if(day < 1) {
        month--;
        last_day = DateTool.lastDayOfMonth(year, month);
        day = last_day; // 현재 날짜를 마지막 일로 변경한다.
    }

} else { // 입력값이 없을 경우 현재일을 기준으로 출력한다.

	year = DateTool.yearOfToday();
	month = DateTool.monthOfToday();
	day = DateTool.dayOfToday();

	last_day = DateTool.lastDayOfMonth(year, month);

}

// 다음해, 다음달, 다음일, 이전해, 이전달, 이전일 의 값을 설정한다.
int re_year = year - 1;
int re_month = month - 1;
int re_day = day - 1;
int pre_year = year + 1;
int pre_month = month + 1;
int pre_day = day + 1;

int this_year = DateTool.yearOfToday();
int this_month = DateTool.monthOfToday();
int this_day = DateTool.dayOfToday();
int this_week = DateTool.weekDayOfToday() - 1;

long this_day_start = DateTool.dateStringToTimeStamp(this_year, this_month, this_day, 0, 0, 0);
long this_day_end = DateTool.dateStringToTimeStamp(this_year, this_month, this_day, 23, 59, 59);

long this_week_start = this_day_start - (this_week * 86400);
long this_week_end = this_day_end + ((6 - this_week) * 86400);
int this_month_last_day = DateTool.lastDayOfMonth(this_year, this_month);
long this_month_start = DateTool.dateStringToTimeStamp(this_year, this_month, 1, 0, 0, 0);
long this_month_end = DateTool.dateStringToTimeStamp(this_year, this_month, this_month_last_day, 23, 59, 59);

int now_month_last_day = DateTool.lastDayOfMonth(year, month);
long now_month_start = DateTool.dateStringToTimeStamp(year, month, 1, 0, 0, 0);
long now_month_end = DateTool.dateStringToTimeStamp(year, month, now_month_last_day, 23, 59, 59);

long before_month_start = DateTool.dateStringToTimeStamp(year, re_month, 1, 0, 0, 0);
int before_month_last_day = DateTool.lastDayOfMonth(year, re_month);
long before_month_end = DateTool.dateStringToTimeStamp(year, re_month, before_month_last_day, 23, 59, 59);

long next_month_start = DateTool.dateStringToTimeStamp(year, pre_month, 1, 0, 0, 0);
int next_month_last_day = DateTool.lastDayOfMonth(year, pre_month);
long next_month_end = DateTool.dateStringToTimeStamp(year, pre_month, next_month_last_day, 23, 59, 59);

String category = "";
%>
<table width=100% border=0>
<tr valign=top>
    <td style='padding:5px'>

    <table width=100% bgcolor=#FFFFFF cellSpacing=0 cellPadding=0 border=0>
    <tr>
        <td style='font-size:30px; font-weight:bold; font-family:Pyunji R; padding-left:10px'><%=year%>년 <%=month%>월</td>
        <td align="center">
		<form name="calendar" method=post action="ScheduleAction.do"> 
        <table>
        <tr>
            <td align="center">
            <a href='ScheduleAction.do?year=<%=re_year%>&month=<%=month%>&monthspan=1<%=category_url%>'">◁년</a>
            <a href='ScheduleAction.do?start=<%=before_month_start%>&end=<%=before_month_end%>&monthspan=1<%=category_url%>'">◁월</a>
            <a href='ScheduleAction.do?start=<%=this_week_start%>&end=<%=this_week_end%>&week=1<%=category_url%>'">이번주</a>
            <a href='ScheduleAction.do?start=<%=next_month_start%>&end=<%=next_month_end%>&monthspan=1<%=category_url%>'">월▷</a>
            <a href='ScheduleAction.do?year=<%=pre_year%>&month=<%=month%>&monthspan=1<%=category_url%>'">년▷</a>
            </td>
	    	<td width=10>&nbsp;</td>
            <td style="padding-top:3px" align="center">
	            <input type=hidden name=category value="">
	            <input type=text name=year size=4 maxlength=4 value="<%=year%>" onClick="this.select()" style="text-align:center" class="input_box"> 년&nbsp;
	            <input type=text name=month size=2 maxlength=2 value="<%=month%>" onClick="this.select()" style="text-align:center" class="input_box"> 월&nbsp;
	            <a href="#" onclick="mysubmit()">이동</a>
            </td>
        </tr>    
        </table>        
        </form>
        </td>
    </tr>
    </table>

    <!-- 날자 출력 부분 [시작] -->
    <table width=100% bgcolor=#F5EDE3 cellSpacing=1 cellPadding=0 border=0>
    <tr class=list_title>
        <td width=20 bgcolor=#C5C5B5 style="cursor:pointer;" onclick="click_action(<%=now_month_start%>,<%=now_month_end%>,'month','<%=category%>');">&nbsp;</td>
        <td width=14% bgcolor=#C5C5B5 align="center">일</td>
        <td width=14% bgcolor=#C5C5B5 align="center">월</td>
        <td width=14% bgcolor=#C5C5B5 align="center">화</td>
        <td width=14% bgcolor=#C5C5B5 align="center">수</td>
        <td width=14% bgcolor=#C5C5B5 align="center">목</td>
        <td width=14% bgcolor=#C5C5B5 align="center">금</td>
        <td width=14% bgcolor=#C5C5B5 align="center">토</td>
    </tr>
    <tr class=calendar_cell_all>

<%

// 시작요일을 구한다.
int start_weekdays = DateTool.startWeekDayOfMonth(year, month) - 1; 
int week_interval =  before_month_last_day - (start_weekdays - 1);
long week_start = DateTool.dateStringToTimeStamp(year, re_month, week_interval, 0, 0, 0);
long week_end = week_start + (86400 * 7) - 1;

//이달의 처음부터 시작요일까지 공백처리 한다.
%>
<td width=20 bgcolor=#C5C5B5 style="cursor:pointer;" onclick="click_action(<%=week_start%>,<%=week_end%>,'weekspan','<%=category%>');">&nbsp;</td>
<%
String day_bgcolor = "";
String show_schedule_num = "";
String bold_start = "";
String bold_end = "";
String lunar_date_get = "";
String lunar_date_get_now = "";
String now_year_string = "";
String now_month_string = "";
String now_day_string = "";


for(int i = 1; i <= start_weekdays; i++) {
    int show_day = before_month_last_day - (start_weekdays - i);
    long start_date = DateTool.dateStringToTimeStamp(year, re_month, show_day, 0, 0, 0);
    long end_date = DateTool.dateStringToTimeStamp(year, re_month, show_day, 23, 59, 59);
    boolean selected = DateTool.amIBetween(start, end, year, re_month, show_day);

    day_bgcolor = "#CCCCCC";
    /*
	if (selected) {
   		day_bgcolor = "#E6DDCC";
    } else {
  		day_bgcolor = "#CCCCCC";
	}
	*/
	
	now_year_string = "" + year;
	if (re_month < 1) {
		now_year_string = "" + (year - 1);
		now_month_string = "12";
	} else if (re_month < 10) {
		now_month_string = "0" + re_month;
	} else {
		now_month_string = "" + re_month;
	}

	if (show_day < 10) {
		now_day_string = "0" + show_day;
	} else {
		now_day_string = "" + show_day;
	}
	lunar_date_get = solarLunarListSet.getLunarDate(now_year_string + now_month_string + now_day_string);
	lunar_date_get_now = Integer.parseInt(lunar_date_get.substring(4,6)) + "/" + Integer.parseInt(lunar_date_get.substring(6,8));

	
	if (this_year == year && this_month == re_month && this_day == show_day) {
		bold_start = "<b>";
		bold_end = "</b>";
	} else {
		bold_start = "";
		bold_end = "";
	}	
%>
	<script language="JavaScript">
		if (schedule_now.getStartDate() == '00000000') {
			schedule_now.setStartDate(<%=now_year_string + now_month_string + now_day_string%>);
		}
	</script>
	
		<td id=<%=now_year_string + now_month_string + now_day_string%> valign=top class="calendar_unselected_cell_outrange">
     		<table width=100% cellspacing=0 border=0 cellpadding=0>
				<tr>
			    	<td style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'dayspan','<%=category%>');"><%=bold_start%><%=show_day%><%=bold_end%></td>
			    	<td align="right" style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'dayspan','<%=category%>');"><font color=#888888>[<%=lunar_date_get_now%>]</font></td>
				</tr>
<%
	
	List scheduleList = solarLunarListSet.getScheduleListOfDate(now_year_string + now_month_string + now_day_string);
	Iterator scheduleListItor = scheduleList.iterator();

	while (scheduleListItor.hasNext()) {
		Schedule schedule = (Schedule)scheduleListItor.next();
		String content_bgcolor_temp = ColorTool.getColor(schedule.getNo());
	    String content_bgcolor = "#" + content_bgcolor_temp;
%>
				<tr>
	            	<td colspan=2 bgcolor=<%=content_bgcolor%>><a href=javascript:onclick=view_schedule('<%=schedule.getNo()%>')><%=schedule.getTitle()%></a></td>
		  		</tr>
<%
	}
%>
			</table>
   		</td>
<%
}

int now_week = 0;
String day_style = "";
// 해당월의 1부터 마지막 날까지 반복한다.
for(int i = 1; i <= last_day; i++) {

    start_weekdays++; // 현재 요일값을 다음 요일값으로 증가.
    now_week = start_weekdays % 7; // 현재 요일을 값을 구한다.

    //##### 날짜 특성화 표시 #####
    if(i == day) {
    	day_style = "green; font-weight:bold; font-size:14px"; // 현재일 (검색일)
    } else {

    //##### 토요일, 일요일, 지정 휴일 특성화 표시 #####
        if(now_week == 1) {
        	day_style = "red"; // 일요일 표시
        } else if(now_week == 0) {
        	day_style = "blue"; // 토요일 표시  
        }   
         
        else {
        	day_style = "gray"; // 평일 표시
        } 

    }

	boolean selected = DateTool.amIBetween(start, end, year, month, i);

	/*
	if (selected) {
   		day_bgcolor = "#D5CCBB";
    } else {
  		day_bgcolor = "#AAAAAA";
	}
	*/
	
	long start_date = DateTool.dateStringToTimeStamp(year, month, i, 0, 0, 0);
	long end_date = DateTool.dateStringToTimeStamp(year, month, i, 23, 59, 59);

	now_year_string = "" + year;
	if (month < 10) {
		now_month_string = "0" + month;
	} else {
		now_month_string = "" + month;
	}
	
	if (i < 10) {
		now_day_string = "0" + i;
	} else {
		now_day_string = "" + i;
	}
	lunar_date_get = solarLunarListSet.getLunarDate(now_year_string + now_month_string + now_day_string);
	lunar_date_get_now = Integer.parseInt(lunar_date_get.substring(4,6)) + "/" + Integer.parseInt(lunar_date_get.substring(6,8));

	if (this_year == year && this_month == month && this_day == i) {
		bold_start = "<b>";
		bold_end = "</b>";
	} else {
		bold_start = "";
		bold_end = "";
	}

%>
		<td id=<%=now_year_string + now_month_string + now_day_string%> valign=top class="calendar_unselected_cell_inrange">
	    	<table width=100% cellspacing=0 border=0 cellpadding=0>
		  		<tr>
		    		<td style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'none','<%=category%>');"><%=bold_start%><%=i%><%=bold_end%></td>
		    		<td align="right" style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'none','<%=category%>');"><font color=#888888>[<%=lunar_date_get_now%>]</font></td>
		  		</tr>
<%
	List scheduleList = solarLunarListSet.getScheduleListOfDate(now_year_string + now_month_string + now_day_string);
	Iterator scheduleListItor = scheduleList.iterator();

	while (scheduleListItor.hasNext()) {
		Schedule schedule = (Schedule)scheduleListItor.next();
		String content_bgcolor_temp = ColorTool.getColor(schedule.getNo());
	    String content_bgcolor = "#" + content_bgcolor_temp;
%>
				<tr>
	            	<td colspan=2 bgcolor=<%=content_bgcolor%>><a href=javascript:onclick=view_schedule('<%=schedule.getNo()%>')><%=schedule.getTitle()%></a></td>
		  		</tr>
<%
	}
%>
			</table>
	    </td>
<%	    
    // 현재 주일값이 0(토)이며, 현재 달의 마지막 날이 아닐 때 다음줄로 이동한다. 
    if(now_week == 0 && i != last_day) {
       week_interval =  before_month_last_day - (start_weekdays - 1);
       week_start = end_date + 1;
       week_end = week_start + (86400 * 7) - 1;
%>
	   </tr><tr class=calendar_cell_all>
       <td width=20 bgcolor=#C5C5B5 style="cursor:pointer;" onclick="click_action(<%=week_start%>, <%=week_end%>, 'week','<%=category%>');">&nbsp;</td>
<%
	}

    }

    // 이달의 마지막 요일부터 나머지를 공백처리 한다.
    if(now_week > 0) {
        for(int i = now_week; i < 7; i++) {
		   	int show_day = i - now_week + 1;
		   	long start_date = DateTool.dateStringToTimeStamp(year, pre_month, show_day, 0, 0, 0);
		   	long end_date = DateTool.dateStringToTimeStamp(year, pre_month, show_day, 23, 59, 59);
	        boolean selected = DateTool.amIBetween(start, end, year, pre_month, show_day);
	        
	        /*
		   	if (selected) {
		    	day_bgcolor = "#E6DDCC";
	        } else {
	   	   		day_bgcolor = "#CCCCCC";
		   	}
	        */

			now_year_string = "" + year;
			if (pre_month > 12) {
				now_year_string = "" + (year + 1);
				now_month_string = "01";
			} else if (pre_month < 10) {
				now_month_string = "0" + pre_month;
			} else {
				now_month_string = "" + pre_month;
			}
			
			if (show_day < 10) {
				now_day_string = "0" + show_day;
			} else {
				now_day_string = "" + show_day;
			}
			lunar_date_get = solarLunarListSet.getLunarDate(now_year_string + now_month_string + now_day_string);
			lunar_date_get_now = Integer.parseInt(lunar_date_get.substring(4,6)) + "/" + Integer.parseInt(lunar_date_get.substring(6,8));
	
			if (this_year == year && this_month == pre_month && this_day == show_day) {
				bold_start = "<b>";
				bold_end = "</b>";
			} else {
				bold_start = "";
				bold_end = "";
			}
%>
	<script language="JavaScript">
		schedule_now.setEndDate(<%=now_year_string + now_month_string + now_day_string%>);
	</script>
        <td id=<%=now_year_string + now_month_string + now_day_string%> valign=top class="calendar_unselected_cell_outrange">
	        <table width=100% cellspacing=0 border=0 cellpadding=0>
		  		<tr>
				    <td style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'dayspan2','<%=category%>');"><%=bold_start%><%=show_day%><%=bold_end%></td>
				    <td align="right" style="cursor:pointer;" onclick="click_action(<%=start_date%>,<%=end_date%>,'dayspan2','<%=category%>');"><font color=#888888>[<%=lunar_date_get_now%>]</font></td>
		  		</tr>
<%
	List scheduleList = solarLunarListSet.getScheduleListOfDate(now_year_string + now_month_string + now_day_string);
	Iterator scheduleListItor = scheduleList.iterator();

	while (scheduleListItor.hasNext()) {
		Schedule schedule = (Schedule)scheduleListItor.next();
		String content_bgcolor_temp = ColorTool.getColor(schedule.getNo());
	    String content_bgcolor = "#" + content_bgcolor_temp;
%>
				<tr>
	            	<td colspan=2 bgcolor=<%=content_bgcolor%>><a href=javascript:onclick=view_schedule('<%=schedule.getNo()%>')><%=schedule.getTitle()%></a></td>
		  		</tr>
<%
	}
%>
			</table>
	    </td>
<%
		}
    }
%>

    </tr>
    </table>
    <!-- 날자 출력 부분 [끝] -->
    
    <table width=100% bgcolor=#FFFFFF cellSpacing=1 cellPadding=0 border=0>
    <tr>
<%
	String is_week_span = "";
    if (week == 1 || weekspan == 1) {
    	long before_week_start = start - (86400 * 7);
    	long before_week_end = end - (86400 *7);
    	long next_week_start = start + (86400 * 7);
    	long next_week_end = end + (86400 * 7);
		if (day < 7 && day > 1) {
		   is_week_span = "weekspan=1";
		} else {
		   is_week_span  = "week=1";
		}

%>
      <td align=left>
        <a href = "ScheduleAction.do?start=<%=before_week_start%>&end=<%=before_week_end%>&<%=is_week_span%><%=category_url%>">|이전주 보기|</a>
      </td>
      <td align="right">
        <a href = "ScheduleAction.do?start=<%=next_week_start%>&end=<%=next_week_end%>&week=1<%=category_url%>">|다음주 보기|</a>
      </td>
<%
    } else if (monthspan == 1) {
%>
      <td align=left>
        <a href = "ScheduleAction.do?start=<%=before_month_start%>&end=<%=before_month_end%>&monthspan=1<%=category_url%>">|이전달 보기|</a>
      </td>
      <td align="right">
        <a href = "ScheduleAction.do?start=<%=next_month_start%>&end=<%=next_month_end%>&monthspan=1<%=category_url%>">|다음달 보기|</a>
      </td>
<%
    } else {
    	long before_day_start = start - 86400;
    	long before_day_end = start - 1;
    	long next_day_start = start + 86400;
    	long next_day_end = start + (86400 * 2) - 1;
%>
      <td align=left>
        <a href = "ScheduleAction.do?start=<%=before_day_start%>&end=<%=before_day_end%><%=category_url%>">|이전일 보기|</a>
      </td>
      <td align="right">
        <a href = "ScheduleAction.do?start=<%=next_day_start%>&end=<%=next_day_end%><%=category_url%>">|다음일 보기|</a>
      </td>
<%
    }
%>
    </tr>
    </table>
    </td>
</tr>
</table> 

<table width=100% cellspacing=1 border=0 cellpadding=2>
  <tr>
    <td align="left"><b>|<a href="ScheduleAction.do?mode=add_schedule_form">일정 등록</a>|</b></td>
    <td id="week_schedule_show_button_td" align="right" style="display:none"><b>|<a href = javascript:onclick=click_action(0,0,'week','<%=category%>')>주 일정보기</a>|</b></td>
  </tr>
</table>

<table width=100% cellspacing=1 border=0 cellpadding=2>
  <tr>
	<td style='padding:5px'>
		<div id='contentDiv'>
		</div>
	</td>
  </tr>
</table>
<%

List solarLunarList = solarLunarListSet.getSolarLunarList();
Iterator solarLunarListIter = solarLunarList.iterator();
while (solarLunarListIter.hasNext()) {
	SolarLunar nowSolarLunar = (SolarLunar)solarLunarListIter.next();
	
	String target_date = nowSolarLunar.getSolarDate();
	
	int target_year = Integer.parseInt(target_date.substring(0,4));
	int target_month = Integer.parseInt(target_date.substring(4,6));
	int target_day = Integer.parseInt(target_date.substring(6,8));
	int target_week = DateTool.weekDayOfDate(target_year, target_month, target_day) - 1;

	long target_start = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, 0, 0, 0);
	long target_end = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, 23, 59, 59);
	
	String target_month_show = "" + target_month;
	String target_day_show = "" + target_day;

	//SolarLunar solarLunar = solarLunarListSet.getSolarLunarBySolarDate(target_date);
	List nowScheduleList = nowSolarLunar.getScheduleList();
	
	
	
	int scheduleCnt = nowScheduleList.size();
	if (scheduleCnt == 0) {
	   //out.println("<td width=100% bgcolor=#F5EDE3></td>");
	}

	Iterator nowScheduleListIter = nowScheduleList.iterator();
	while (nowScheduleListIter.hasNext()) {
		Schedule nowSchedule = (Schedule)nowScheduleListIter.next();
		
		double width = 100 / scheduleCnt;
		String width_string = width + "%";
	
		String title = nowSchedule.getTitle();
		String title_view = "<a href = javascript:onclick=view_schedule(\"" + nowSchedule.getNo() + "\")>" + nowSchedule.getTitle() + "</a>";
		String text = nowSchedule.getText();
		int eventType = nowSchedule.getEventType();
		int repeatType = nowSchedule.getRepeatType();
	   
	   	String content_bgcolor_temp = ColorTool.getColor(nowSchedule.getNo());
	    String content_bgcolor = "#" + content_bgcolor_temp;
		
	    String bgcolor = "#F5EDE3";
	  	
		int even = target_week % 2;
		if (even == 1) {
			bgcolor = "#D5CCBB";
		} else {
			bgcolor = "#E6DDCC";
		}
		
		double upper_height = 0;
		double lower_height = 0;
		String left_panel = "";
		String right_panel = "";
		String left_bgcolor = bgcolor;
		String right_bgcolor = bgcolor;
		String center_bgcolor = content_bgcolor;
	
		int target_day_now = 0;
		if (nowSchedule.getIsLunar() == 1) {
			target_day_now = Integer.parseInt(nowSolarLunar.getLunarDate().substring(6,8));
		} else {
			target_day_now = Integer.parseInt(nowSolarLunar.getSolarDate().substring(6,8));
		}	   
	
		String start_time_show = "";
		String end_time_show = "";
		double start_time_sec = 0;
		double end_time_sec = 0;
		int start_day = 0;
		int end_day = 0;
		double from_time = 0;
		double to_time = 0;
		double start_time = 0;
		double end_time = 0;
		
		if (eventType == 1) {
	   		if (repeatType == 1) {
	   			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		 		start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		 		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		 		end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		 		
		 		upper_height = ((double)start_time_sec / 86400) * 100;
		 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
		 
	      	} else if (repeatType == 2) {
	      		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
				start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
				end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
				end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		 
	        	upper_height = ((double)start_time_sec / 86400) * 100;
		 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
		 
			} else if (repeatType == 3) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
				start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
				end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
				end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	        
	        	upper_height = ((double)start_time_sec / 86400) * 100;
		 		lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	
			} else if (repeatType == 4) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
				start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			 	end_time_sec = start_time_sec;
				
			 	upper_height = ((double)start_time_sec / 86400) * 100;
			 	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	
			} else if (repeatType == 5) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
				start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			 	end_time_sec = start_time_sec;
				
			 	upper_height = ((double)start_time_sec / 86400) * 100;
			 	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
	
			}
		} else if (eventType == 2 || eventType == 4) {
			if (repeatType == 1) {
				long start_time_unixtimestamp = DateTool.dateStringToTimeStamp(nowSchedule.getFromDate() + nowSchedule.getFromTime(), "yyyyMMddhhmmss");
		        
		        start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		        long end_time_unixtimestamp_date = DateTool.dateStringToTimeStamp(nowSchedule.getToDate() + "000000", "yyyyMMddhhmmss");
	
		        end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	 			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		        double end_time_unixtimestamp = end_time_unixtimestamp_date + end_time_sec;
	 			
		        upper_height = ((double)(start_time_unixtimestamp - target_start) / 86400) * 100;
		        lower_height = ((double)(target_end - end_time_unixtimestamp) / 86400) * 100;
		        
			} else if (repeatType == 2) {
				if (Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {
	     			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			    	
			    	start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			    	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
					end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		
					upper_height = ((double)start_time_sec / 86400) * 100;
					lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
				} else {
			    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
			    		start_time_show = "";
			    		start_time_sec = 0;
			    	} else {
			    		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			    		start_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
			    	}
	
			    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
			    		end_time_show = "";
			    		end_time_sec = 86400;
			    	} else {
			    		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			    		end_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			    	}
	
			    	upper_height = ((double)start_time_sec / 86400) * 100;
			    	lower_height = ((86400 - (double)end_time_sec) / 86400) * 100;
		
		        	left_panel = "<<";
		        	right_panel = ">>";
			    	left_bgcolor = content_bgcolor;
			    	right_bgcolor = content_bgcolor;
			    	center_bgcolor = bgcolor;
	 			}
	
			} else if (repeatType == 3) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
				end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		
		     	if (nowSchedule.getFromWeek() < nowSchedule.getToWeek() || (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
			 		start_day = target_day - target_week + nowSchedule.getFromWeek();
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
			    	end_day = target_day - target_week + nowSchedule.getToWeek();
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		
		        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		     	} else if (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) > Integer.parseInt(nowSchedule.getToTime()) && target_week == nowSchedule.getFromWeek()) {
			   		start_day = target_day;
			   		start_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
			    	end_day = target_day;
			    	end_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		
			    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
			       		end_time_show = "";
			       		to_time = target_end;
			    	}
		
			    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
			       		start_time_show = "";
			       		from_time = target_start;
			    	}
		
			    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
			    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		
		        	left_panel = "<<";
		        	right_panel = ">>";
			    	left_bgcolor = content_bgcolor;
			    	right_bgcolor = content_bgcolor;
			    	center_bgcolor = bgcolor;
		     	} else if (target_week < nowSchedule.getFromWeek()) {
			    	start_day = target_day - target_week - (7 - nowSchedule.getFromWeek());
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
			    	end_day = target_day - target_week + nowSchedule.getToWeek();
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		
			    	if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
			       		end_time_show = "";
			       		to_time = target_end;
			    	}
		
			    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
			       		start_time_show = "";
			       		from_time = target_start;
			    	}
		
			    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
			    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
		     	} else if (target_week >= nowSchedule.getFromWeek()) {
			    	start_day = target_day - target_week + nowSchedule.getFromWeek();
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
			    	end_day = target_day - target_week + 7 + nowSchedule.getToWeek();
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		
			 		if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
			       		end_time_show = "";
			      		to_time = target_end;
			    	}
		
			    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
			       		start_time_show = "";
			      		from_time = target_start;
			    	}
		
			    	upper_height = ((double)(from_time - target_start) / 86400) * 100;
			    	lower_height = ((double)(target_end - to_time) / 86400) * 100;
			 	} else {
			    	log.error("unhandled situation.. fix it!!");
			 	}
	
			} else if (repeatType == 4) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		
		     	if (nowSchedule.getFromDays() < nowSchedule.getToDays() || (nowSchedule.getFromDate().equals(nowSchedule.getToDate())) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {

		     		int month_modified = target_month + 1;
			       	int month_modified_minus = target_month - 1;
		           	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		           	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		           	
		           	int now_from_days = nowSchedule.getFromDays();
		           	if (now_from_days <= 1) {
		           		if (nowSchedule.getIsLunar() == 1) {
		           			SolarLunar lastLunarMonthSolarLunar = (SolarLunar)lastSolarLunarOfLunarMonthListSet.getSolarLunarByLunarYearMonth(nowSolarLunar.getLunarDate().substring(0,6));
		           			lastLunarMonthSolarLunar.getLunarDate().substring(6,8);
		           			now_from_days = Integer.parseInt(lastLunarMonthSolarLunar.getLunarDate().substring(6,8)) + nowSchedule.getFromDays();
		        		} else {
		        			now_from_days = DateTool.lastDayOfMonth(Integer.parseInt(nowSolarLunar.getSolarDate().substring(0,4)), Integer.parseInt(nowSolarLunar.getSolarDate().substring(4,6))) + nowSchedule.getFromDays();
		        		}	
		           		 
		           	} else {
		           		now_from_days = nowSchedule.getFromDays();
		           	}
		           	
					if (now_from_days < target_day_now) {
						upper_height = -1;
					} else if (now_from_days > target_day_now) {
						upper_height = -1;
					} else {
						upper_height = ((double)(from_time - target_start) / 86400) * 100;
					}
				
					int now_to_days = nowSchedule.getToDays();
		           	if (now_to_days <= 1) {
		           		if (nowSchedule.getIsLunar() == 1) {
		           			SolarLunar lastLunarMonthSolarLunar = (SolarLunar)lastSolarLunarOfLunarMonthListSet.getSolarLunarByLunarYearMonth(nowSolarLunar.getLunarDate().substring(0,6));
		           			lastLunarMonthSolarLunar.getLunarDate().substring(6,8);
		           			now_to_days = Integer.parseInt(lastLunarMonthSolarLunar.getLunarDate().substring(6,8)) + nowSchedule.getToDays();
		        		} else {
		        			now_to_days = DateTool.lastDayOfMonth(Integer.parseInt(nowSolarLunar.getSolarDate().substring(0,4)), Integer.parseInt(nowSolarLunar.getSolarDate().substring(4,6))) + nowSchedule.getToDays();
		        		}	
		           		 
		           	} else {
		           		now_to_days = nowSchedule.getToDays();
		           	}
		           	
					if (now_to_days < target_day_now) {
						lower_height = -1;
					} else if (now_to_days > target_day_now) {
						lower_height = -1;
					} else {
						lower_height = ((double)(target_end - to_time) / 86400) * 100;
					}
					
		     	} else if (nowSchedule.getFromDays() <= target_day) {
		     		
		     		from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
			    	int end_month = target_month + 1;
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
			 	} else {
			 		
			 		int from_month = target_month - 1;
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		        	upper_height = ((double)(from_time - target_start) / 86400) * 100;
		        	lower_height = ((double)(target_end - to_time) / 86400) * 100;
			 	}
	
			} else if (repeatType == 5) {
				start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			 	start_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
			 	end_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
			 	
		     	if (Integer.parseInt(nowSchedule.getFromDate()) < Integer.parseInt(nowSchedule.getToDate()) || (nowSchedule.getFromDate().equals(nowSchedule.getToDate()) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
		        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		       		to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		
		       		upper_height = ((double)(from_time - target_start) / 86400) * 100;
		       		lower_height = ((double)(target_end - to_time) / 86400) * 100;
			 	} else {
			    	int from_month_day = Integer.parseInt(nowSchedule.getFromDate().substring(2,6));
			    	int target_month_day = target_month + target_day;
		
			    	if (from_month_day <= target_month_day) {
			    		int target_year_modified = target_year + 1;
		        		from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		        		to_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		        		upper_height = ((double)(from_time - target_start) / 86400) * 100;
		        		lower_height = ((double)(target_end - to_time) / 86400) * 100;
			    	} else {
			    		int target_year_modified = target_year - 1;
		        		from_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getFromDate().substring(4,6)), Integer.parseInt(nowSchedule.getFromDate().substring(6,8)), Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		        		to_time = DateTool.dateStringToTimeStamp(target_year, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		        		upper_height = ((double)(from_time - target_start) / 86400) * 100;
		        		lower_height = ((double)(target_end - to_time) / 86400) * 100;
			    	}
			 	}
		
			}
		} else if (eventType == 3) {
			upper_height = 0;
			lower_height = 0;
		}
	   
		if (upper_height < 0) {
			upper_height = 0;
			start_time_show = "<<";
		}
		if (lower_height < -0.002) {
			lower_height = 0;
			end_time_show = ">>";
		}
	   
		double center_height = 100 - (upper_height + lower_height);
		  
		String title_in_content = "";
		String title_in_fore = nowSchedule.getTitle();
		String title_in_after = "";
		String start_time_in_content = "";
		String start_time_in_fore = start_time_show;
		String end_time_in_content = "";
		String end_time_in_after = end_time_show;
		
		if (center_height < 20 && (eventType == 2 || eventType == 4)) {
			
			if (upper_height > lower_height) {
		    	title_in_content = "";
				title_in_fore = title_view;
				title_in_after = "";
			} else {
				title_in_content = "";
				title_in_fore = "";
				title_in_after = nowSchedule.getTitle();
			}
		
			start_time_in_content = "";
			start_time_in_fore = start_time_show;
			end_time_in_content = "";
			end_time_in_after = end_time_show;
	
		} else if (center_height < 20 && eventType == 1) {
			if (upper_height > lower_height) {
				title_in_content = "";
				title_in_fore = title_view;
				title_in_after = "";
			} else {
				title_in_content = "";
				title_in_fore = "";
				title_in_after = title_view;
			}
			start_time_in_content = "";
			start_time_in_fore = start_time_show;
			end_time_in_content = "";
			end_time_in_after = "";
		} else if (eventType == 3) {
			title_in_fore = "";
			title_in_after = "";
			title_in_content = title_view;
			start_time_in_content = "00:00";
			start_time_in_fore = "";
			end_time_in_content = "24:00";
		} else {
			title_in_content = title_view;
			title_in_fore = "";
			title_in_after = "";
			start_time_in_fore = "";
			start_time_in_content = start_time_show;
			end_time_in_content = end_time_show;
			end_time_in_after = "";
		}
	
		
		String valign_upper = "bottom";
		String valign_lower = "top";

%>
	<script language="JavaScript">
		schedule_now.addSchedule('<%= target_date %>', '<%= upper_height %>', '<%= left_bgcolor %>', '<%= left_panel %>', '<%= title_in_fore %>', '<%= start_time_in_fore %>' 
													 , '<%= center_height %>', '<%= center_bgcolor %>', '<%= start_time_in_content %>', '<%= title_in_content %>', '<%= end_time_in_content %>'	
													 , '<%= lower_height %>', '<%= right_bgcolor %>', '<%= end_time_in_after %>', '<%= title_in_after %>', '<%= right_panel %>'	);
	</script>
<%
	}
}
%>