<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.bug.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="org.apache.commons.logging.Log" %>
<%@ page import="org.apache.commons.logging.LogFactory" %>
<%@ page import="kr.co.leaderway.util.*" %>
<%@ page import="kr.co.leaderway.mywork.statics.*" %>
<%@ page import="kr.co.leaderway.mywork.util.TypeTool" %>
<%@ page import="org.apache.struts.util.MessageResources" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>

<%

Log log = LogFactory.getLog("aa");

String mode = request.getParameter("mode") == null ? "" : (String)request.getParameter("mode");

String roleNo = request.getParameter("roleNo") == null ? "0" : (String)request.getParameter("roleNo");

MyWorkList bugReportingList = (MyWorkList) request.getAttribute("bugReportingList");
String projectNo_selected = request.getParameter("projectNo") == null ? "0" : (String) request.getParameter("projectNo");

String currentURL = UrlTool.getCurrentURL(request);
int totalRows = bugReportingList.getTotalRows();
int pageNum = bugReportingList.getPageNum();


int selectedPage = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
int perPage = request.getParameter("per_page") != null ? Integer.parseInt(request.getParameter("per_page")) : 10;
String bugStatus = request.getParameter("bug_status") != null ? request.getParameter("bug_status") : "";

if (pageNum < selectedPage) {
	selectedPage = pageNum;
}

String time = request.getParameter("time") !=null ? request.getParameter("time") : "";
String category = request.getParameter("category") != null ? request.getParameter("category") : "";
String search = request.getParameter("search") != null ? request.getParameter("search") : "";
String search_string = request.getParameter("search_string")  != null ? request.getParameter("search_string") : "";
search_string = new String(search_string.getBytes("8859_1"),"UTF-8");

String title_selected = "";
String contents_selected = "";
String writer_selected = "";
String titlecontent_selected = "";
if (search.equals("title")) {
    title_selected = "selected";
} else if (search.equals("contents")) {
    contents_selected = "selected";
} else if (search.equals("writer")) {
    writer_selected = "selected";
} else if (search.equals("title-content")) {
    titlecontent_selected = "selected";
}

String week_selected = "";
String month_selected = "";
String year_selected = "";
String all_selected = "";
if (time.equals("week")) {
    week_selected = "selected";
} else if (time.equals("month")) {
    month_selected = "selected";
} else if (time.equals("year")) {
    year_selected = "selected";
} else if (time.equals("all")) {
    all_selected = "selected";
} else {
	all_selected = "selected";
}
%>

<script language="JavaScript">

function bugList() {

	now_url = changeUrlArgument(current_url, "per_page", f.per_page.value);
	now_url = changeUrlArgument(now_url, "bug_status", f.bug_status_select.value);

    search_string = f.search_string.value.trim();
 
    if (search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "search", f.target.value);
    	now_url = changeUrlArgument(now_url, "search_string", encodeURI(search_string));
    } else {
    	now_url = changeUrlArgument(now_url, "search", "");
    	now_url = changeUrlArgument(now_url, "search_string", "");
    }
    
    if (f.time_span.value == "all" || !search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "time", "");
    } else {
    	now_url = changeUrlArgument(now_url, "time", f.time_span.value);
    }

	location.href  = now_url;
	//f.action = "ArticleAction.do?mode=list_article&boardNo=" + boardNo + "&per_page=" + perPage;
	//f.submit();
}

function bugRegister(projectNo) {
	f.action = "BugAction.do?mode=add_bug_form&projectNo=" + projectNo;
	f.submit();
}

function bugView(projectNo, bugNo) {
	
	//now_url_argument = changeUrlArgument(current_url_argument, "mode", "view_bug");
	//now_url_argument = changeUrlArgument(now_url_argument, "projectNo", projectNo);
	//now_url_argument = changeUrlArgument(now_url_argument, "no", bugNo);
	//f.action = "BugAction.do?" + now_url_argument;
	f.action = "BugAction.do?mode=view_bug&projectNo=" + projectNo + "&no=" + bugNo + "&roleNo=" + <%=roleNo%>;
	f.submit();
}

function bugModify(projectNo, bugNo) {

	now_url = changeUrlArgument(current_url, "mode", "modify_bug_form");
	now_url = changeUrlArgument(now_url, "projectNo", projectNo);
	now_url = changeUrlArgument(now_url, "no", bugNo);
	
	location.href  = now_url;
}

function bugRemove(projectNo, bugNo) {
	if ( confirm("정말 삭제하시겠습니까?") ) {
		f.action = "BugAction.do?mode=delete_bug&projectNo=" + projectNo + "&no=" + bugNo;
		f.submit();
	}
}

function bugStatusMoveForm(projectNo, bugNo, toBeStatus, isForward) {
	
	date = new Date();
	url  = url_of_context + "/BugAction.do?mode=move_bug_status_form&projectNo=" + projectNo + "&no=" + bugNo + "&toBeStatus=" + toBeStatus + "&roleNo=" + <%=roleNo%> + "&isForward=" + isForward + "&serial=" + date+ "&isAjax=Y";

	ajax_call_post(url, 'showBugStatusMoveForm');
	
}

function bugStatusMove(projectNo, bugNo, toBeStatus, isForward) {
	
	//date = new Date();
	//url  = url_of_context + "/BugAction.do?mode=move_bug_for_inspecting&no=" + bugNo + "&serial=" + date+ "&isAjax=Y";

	//ajax_call_post(url, 'showBugStatusMoveForm');
	var moveForm = document.getElementById('moveForm');
	
	if (moveForm.comments.value.length == 0) {
		alert("코멘트를 입력하여 주십시요.");
		moveForm.comments.focus();
		return;	
	}
		
	if (isForward == 1 && toBeStatus == '20') {  // inspecting
		if ( !confirm("검토중 단계로 이전하여 검토하시겠습니까?") ) {
			return;
		}
	} else if (isForward == 1 && toBeStatus == '40') {  // accepted
		if ( !confirm("승인하시겠습니까? 승인하시면 할당단계로 이전됩니다.") ) {
			return;
		}
	} else if (isForward == 0 && toBeStatus == '40') {  // accepted
		if ( !confirm("재할당 요청하시겠습니까? 확인버튼을 클릭하시면 할당단계로 이전됩니다.") ) {
			return;
		}
	} else if (isForward == 1 && toBeStatus == '30') {  // rejected
		if ( !confirm("반려하시겠습니까? 반려하시면 요청자에게 반려되며 본 리포팅은 종료됩니다.") ) {
			return;
		}
	} else if (isForward == 1 && toBeStatus == '50') { // assigned

		/*
		var devArray = new Array();
		var foundChecked = false;
		for (var i=0; i < moveForm.checkDev.length; i++){
			if (moveForm.checkDev[i].checked == true) {
				devArray.push(moveForm.checkDev[i].value);
				foundChecked = true;
			}
			
		}

		if (moveForm.checkSpecifiedDev.checked == true) {
			for (var j = 0 ; j < moveForm.specifiedUserNos.length; j++) {
				devArray.push(moveForm.specifiedUserNos[j].value);
				foundChecked = true;
			}
		}
		
		if (!foundChecked) {
			alert('개발 담당그룹 또는 담당자를 지정하여 주십시요.');
			return;
		}
		
		moveForm.devList.value = devArray.join("@delimiter@");
		*/
		//alert(moveForm.devList.value);
		//return;
	} else if (isForward == 1 && toBeStatus == '60') { // progresessing
		if ( !confirm("개발중 단계로 가져오시겠습니까?") ) {
			return;
		}
	} else if (isForward == 1 && toBeStatus == '80') { // waitingAck
		if ( !confirm("평가완료하셨습니까? 확인대기 상태로 이동합니다.") ) {
			return;
		}
	} else if (isForward == 1 && toBeStatus == '90') { // completed
		if ( !confirm("확인하셨습니까? 요청사항 완료됩니다.") ) {
			return;
		}
	}

	if (isForward == 1 && toBeStatus != '20' && toBeStatus != '60' && toBeStatus != '70' && toBeStatus != '80' && toBeStatus != '90' ) {
		var devArray = new Array();
		var foundChecked = false;
		for (var i=0; i < moveForm.checkDev.length; i++){
			if (moveForm.checkDev[i].checked == true) {
				devArray.push(moveForm.checkDev[i].value);
				foundChecked = true;
			}
			
		}

		if (moveForm.checkSpecifiedDev.checked == true) {
			for (var j = 0 ; j < moveForm.specifiedUserNos.length; j++) {
				devArray.push(moveForm.specifiedUserNos[j].value);
				foundChecked = true;
			}
		}

		if (foundChecked) {
			moveForm.devList.value = devArray.join("@delimiter@");
		}
	}
	
	moveForm.action = "BugAction.do?mode=move_bug&isForward=" + isForward;
	moveForm.submit();
	
}

function showBugStatusMoveForm() {
    
	if (oXmlHttp.readyState == 4) {
        // only if "OK"
        if (oXmlHttp.status == 200) {
         
        	responseText = trim(oXmlHttp.responseText);
          
			document.getElementById('statusMoveForm_div').innerHTML = responseText;

        } else {
            alert("There was a problem retrieving the XML data:\n" + req.statusText);
        }
    }
}


var req;
var num_table_get;

function clear_listTable_bgcolor() {
    var x=document.getElementById('listTable').rows;
    var x_rows_num=x.length;

    var y_column_num=5;
    x_count = 1;
    while ( x_count < x_rows_num ) {
            y_count = 0;
            while (y_count < y_column_num) {
                    x[x_count].cells[y_count].style.backgroundColor = "#FFFFFF";
                    y_count = y_count + 1;
            }
    	x_count = x_count + 1;
    }
}

function get_contents(bugNo, response, num_table) {

	
    if (num_table != '' || num_table == 0) {
        num_table_get = num_table;
    }
    
	if (response != ''){
		// Response mode
		message   = document.getElementById('nameCheckFailed');
		if (response == '1'){
			message.className = 'error';
		}else{
			message.className = 'hidden';
		}
	}else{
		changeBgColorSelecting(num_table_get);
		date = new Date();
		url  = url_of_context + "/BugAction.do?mode=view_bug&no=" + bugNo + "&roleNo=" + <%=roleNo%> + "&serial=" + date+ "&isAjax=Y";

		ajax_call_post(url, 'showContents');
	}

}

function showContents() {
    
	if (oXmlHttp.readyState == 4) {
        // only if "OK"
        if (oXmlHttp.status == 200) {
         
        	responseText = trim(oXmlHttp.responseText);
          
			document.getElementById('bug_view_div').innerHTML = responseText;
			
			clear_listTable_bgcolor();
			
			changeBgColorSelected(num_table_get);

        } else {
            alert("There was a problem retrieving the XML data:\n" + req.statusText);
        }
    }
}

function changeBgColorSelecting(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;
 
    y[0].style.backgroundColor = "#999999";
    y[1].style.backgroundColor = "#999999";
    y[2].style.backgroundColor = "#999999";
    y[3].style.backgroundColor = "#999999";
    y[4].style.backgroundColor = "#999999";
    
}

function changeBgColorSelected(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;

    y[0].style.backgroundColor = "#CCCCCC";
    y[1].style.backgroundColor = "#CCCCCC";
    y[2].style.backgroundColor = "#CCCCCC";
    y[3].style.backgroundColor = "#CCCCCC";
    y[4].style.backgroundColor = "#CCCCCC";
    
}

function setSelectedUser(callerIdentifier, selectedUserArray) {

	//alert(selectedUserArray[0] + ":" +  selectedUserArray[1] + ":" + selectedUserArray[2] + ":" + selectedUserArray[3]);
	if (callerIdentifier == 1) {	
		var text = selectedUserArray[1] + '(' + selectedUserArray[2] + ')';
		var value = selectedUserArray[0];
		appendOptionLast('specifiedUserNos', text, value);
	}
	
}

function enterKeyPressed() {

	bugList();
}
</script>

<form name="f" method="post">
<%
	if (roleNo.equals("0")) {
%>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
			<td width="100%" align="right" height="22">
<%
		if (mode.equals("list_bug")) {
			out.print("상태");
		} else if (mode.equals("list_bug_treated_by_me")) {
			out.print("역할");
		}
%>
				<select id="bug_status_select" name="status_select" onchange="bugList()"></select>
			</td>
	  	</tr>
	</table>
<%
	}
%>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
			<td width="100%" align="right" height="22">페이지당 목록갯수
				<select id="per_page" name="per_page" onchange="bugList()"></select>
				&nbsp;&nbsp; 총 목록갯수 : <%=totalRows %> &nbsp;&nbsp;  페이지 수: <%=pageNum %>
			</td>
	  	</tr>
	</table>
  	<!-- list -->
  	<table id="listTable" name="listTable" border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB">
	  	<tr>
			<td width="50%" align="center" bgcolor="#E6ECDE" height="22">제목</td>
			<td width="23%" align="center" bgcolor="#E6ECDE">지정된담당자</td>
			<td width="10%" align="center" bgcolor="#E6ECDE">시행자</td>
			<td width="10%" align="center" bgcolor="#E6ECDE">시행일시</td>
			<td width="7%" align="center" bgcolor="#E6ECDE">상태</td>
	  	</tr>
<%

if (bugReportingList != null) {
	
	MessageResources messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
	TypeTool typeTool = new TypeTool(messageResources);
	
	Iterator bugIter = bugReportingList.getList().iterator();
	int numTable = 0;
	while ( bugIter.hasNext() ) {
		numTable ++;
		Bug bug = (Bug)bugIter.next();
		
		
%>		  	
	  	<tr onClick="get_contents('<%=bug.getNo()%>', '', <%=numTable%>)">
			<td align="center" bgcolor="#FFFFFF" height="20">
				<%= bug.getTitle() %>
			</td>
			<td align="center" bgcolor="#FFFFFF" height="20">
<% 				
				List assigneeList = bug.getBugAssigneeInfo();
				for (int i = 0 ; i < assigneeList.size() ; i++) {
					BugAssigneeInfo assigneeInfo = (BugAssigneeInfo)assigneeList.get(i);
					out.print(assigneeInfo.getAssigneeName());
					out.print(assigneeInfo.getAssigneeTypeName());
					if (i + 1 < assigneeList.size()) out.println("<br>");
				}
%>
			</td>
			<td align="center" bgcolor="#FFFFFF" height="20">
				<%= bug.getName() %>
			</td>
			<td align="center" bgcolor="#FFFFFF" height="20">
				<%= bug.getCreateTimeShort() %>
			</td>
			<td align="center" bgcolor="#FFFFFF" height="20">
				<%= typeTool.getMessageNameFromValue(BugStatus.class, bug.getStatus()) %>
			</td>
		</tr>
<%
	}
}
%>		  	
  	</table>
  	<!-- /list -->	 
	<table width="100%" cellspacing="0" bgcolor="#F4F4F4" border="0" cellpadding="1">
	  <tr>
	  	<td align="left" valign="middle" class="search_form">
		  	<page:paging>
		  		<page:pg><%=selectedPage %></page:pg>
		  		<page:pgLimit>10</page:pgLimit>
		  		<page:totalRows><%=totalRows %></page:totalRows>
		  		<page:rowsLimit><%=perPage %></page:rowsLimit>
		  		<page:urlString><%=currentURL %></page:urlString>
		  		<page:pageArgument>page</page:pageArgument>
		  	</page:paging>
		</td>
	
	    <td align="right" valign="middle" class="search_form">
	     <!-- target -->
	      <select name="target">
	      <option value="title" <%=title_selected%>>제목</option>
	      <option value="contents" <%=contents_selected%>>내용</option>
	      <option value="writer" <%=writer_selected%>>글쓴이</option>
	      <option value="title-content" <%=titlecontent_selected%>>제목,내용</option>
	      </select>
	
	  	<!-- time_span -->
	      <select name="time_span">
	      <option value="week" <%=week_selected%>>한주</option>
	      <option value="month" <%=month_selected%>>한달</option>
	      <option value="year" <%=year_selected%>>1년</option>
	      <option value="all" <%=all_selected%>>전체</option>
	      </select>
	
	  	<!-- search_string -->
	      <input type="text" name="search_string"
	       size="20" maxlength="60" value="<%=search_string%>">
	    </td>
	    <td align="left" valign="middle" onClick="bugList()">
	    	검색
	    </td>
	  </tr>
	</table>
	
<%
	if (roleNo.equals("0")) {
%>
	<br>
	<!-- button -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%">
		<tr>
			<td align="right">
				<input type="button" value="버그 등록" onClick="bugRegister('<%=projectNo_selected%>')" class="title_button" />
			</td>
		</tr>
	</table>	
<%
	}
%>	
</form>

<div id="bug_view_div" name="bug_view_div">
</div>

<script language="JavaScript">
	
	var select_id = 'per_page';
	var list_name = 'per_page';
	var url = 'OptionActionAjax.do';
	var add_total = false;
	var selected_value = '<%=perPage%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);

<%
	if (roleNo.equals("0") && mode.equals("list_bug")) {
%>
	var select_id = 'bug_status_select';
	var list_name = 'bug_status';
	var url = 'OptionActionAjax.do';
	var add_total = true;
	var selected_value = '<%=bugStatus%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
<%
	} else if (roleNo.equals("0") && mode.equals("list_bug_treated_by_me")) {
%>	
	var select_id = 'bug_status_select';
	var list_name = 'role_right_from_statics';
	var url = 'OptionActionAjax.do';
	var add_total = 'true_value_null';
	var selected_value = '<%=bugStatus%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
<%
	}
%>
</script>