<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.board.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="kr.co.leaderway.mywork.category.*" %>
<%@ page import="kr.co.leaderway.mywork.category.model.*" %>
<%@ page import="kr.co.leaderway.util.*" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>

<%

Board board = (Board) request.getAttribute("board");
MyWorkList articleList = (MyWorkList) request.getAttribute("articleList");


String currentURL = UrlTool.getCurrentURL(request);
int totalRows = articleList.getTotalRows();
int pageNum = articleList.getPageNum();


int selectedPage = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
int perPage = request.getParameter("per_page") != null ? Integer.parseInt(request.getParameter("per_page")) : 10;

if (pageNum < selectedPage) {
	selectedPage = pageNum;
}

String time = request.getParameter("time") !=null ? request.getParameter("time") : "";
String category = request.getParameter("category") != null ? request.getParameter("category") : "";
String search = request.getParameter("search") != null ? request.getParameter("search") : "";
String search_string = request.getParameter("search_string")  != null ? request.getParameter("search_string") : "";
search_string = new String(search_string.getBytes("8859_1"),"UTF-8");

String title_selected = "";
String contents_selected = "";
String writer_selected = "";
String titlecontent_selected = "";
if (search.equals("title")) {
    title_selected = "selected";
} else if (search.equals("contents")) {
    contents_selected = "selected";
} else if (search.equals("writer")) {
    writer_selected = "selected";
} else if (search.equals("title-content")) {
    titlecontent_selected = "selected";
}

String week_selected = "";
String month_selected = "";
String year_selected = "";
String all_selected = "";
if (time.equals("week")) {
    week_selected = "selected";
} else if (time.equals("month")) {
    month_selected = "selected";
} else if (time.equals("year")) {
    year_selected = "selected";
} else if (time.equals("all")) {
    all_selected = "selected";
} else {
	all_selected = "selected";
}
%>

<script language="JavaScript">

$(document).ready(function() {
	$('div[id^="article_header_"]').live("click", function () {
		var a = this.id;
		var b = a.substring(15, a.length);
		$('#article_' + b).animate({
			opacity: 'toggle',
			height: 'toggle'
		}, 'slow');
	});
});


function articleList() {

	now_url = changeUrlArgument(current_url, "per_page", f.per_page.value);

    search_string = f.search_string.value.trim();
 
    if (search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "search", f.target.value);
    	now_url = changeUrlArgument(now_url, "search_string", encodeURI(search_string));
    } else {
    	now_url = changeUrlArgument(now_url, "search", "");
    	now_url = changeUrlArgument(now_url, "search_string", "");
    }
    
    if (f.time_span.value == "all" || !search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "time", "");
    } else {
    	now_url = changeUrlArgument(now_url, "time", f.time_span.value);
    }
    
	location.href  = now_url;
	//f.action = "ArticleAction.do?mode=list_article&boardNo=" + boardNo + "&per_page=" + perPage;
	//f.submit();
}

function articleCreate(boardNo) {
	f.action = "ArticleAction.do?mode=add_article_form&boardNo=" + boardNo;
	f.submit();
}

function articleView(boardNo, articleNo, revision) {
	
	//now_url_argument = changeUrlArgument(current_url_argument, "mode", "view_article");
	//now_url_argument = changeUrlArgument(now_url_argument, "boardNo", boardNo);
	//now_url_argument = changeUrlArgument(now_url_argument, "no", articleNo);
	//f.action = "ArticleAction.do?" + now_url_argument;
	f.action = "ArticleAction.do?mode=view_article&boardNo=" + boardNo + "&no=" + articleNo + "&revision=" + revision;
	f.submit();
}

function articleModify(boardNo, articleNo, revision) {
	//f.action = "ArticleAction.do?mode=modify_article_form&boardNo=" + boardNo + "&no=" + articleNo;
	//f.submit();

	now_url = changeUrlArgument(current_url, "mode", "modify_article_form");
	now_url = changeUrlArgument(now_url, "boardNo", boardNo);
	now_url = changeUrlArgument(now_url, "no", articleNo);
	now_url = changeUrlArgument(now_url, "revision", revision);
	
	location.href  = now_url;
}

function articleRemove(boardNo, articleNo) {
	if ( confirm("정말 삭제하시겠습니까?") ) {
		f.action = "ArticleAction.do?mode=delete_article&boardNo=" + boardNo + "&no=" + articleNo;
		f.submit();
	}
}

function articleReply(boardNo, articleNo) {
	f.action = "ArticleAction.do?mode=reply_article_form&boardNo=" + boardNo + "&no=" + articleNo;
	f.submit();
}

function accessGroupAssign(boardNo, aricleNo, revision) {
	f.action = "ArticleAction.do?mode=assign_access_group_form&boardNo=" + boardNo + "&no=" + aricleNo + "&revision=" + revision;
	f.submit();
}

var req;
var num_table_get;

function clear_listTable_bgcolor() {
    var x=document.getElementById('listTable').rows;
    var x_rows_num=x.length;

    var y_column_num=4;
    x_count = 1;
    while ( x_count < x_rows_num ) {
            y_count = 0;
            while (y_count < y_column_num) {
                    x[x_count].cells[y_count].style.backgroundColor = "#FFFFFF";
                    y_count = y_count + 1;
            }
    	x_count = x_count + 1;
    }
}

function get_contents(articleNo, revision, response, num_table) {

	if (num_table != '' || num_table == 0) {
        num_table_get = num_table;
    }
    
	var url  = url_of_context + "/ArticleAction.do";
	
	$.ajax({
		url: url,
		data: { mode: 'view_article_popup',
				no: articleNo,
				revision: revision,
				isAjax: 'Y'
			  },
		dataType: 'html',
		cache: false, 
		success: function(htmlGet, textStatus) {
			if (textStatus == "success") {
				$('#article_view_div').html(htmlGet);
		
				clear_listTable_bgcolor();
				
				changeBgColorSelected(num_table_get);
			}
		},
		error: function(xhr, textStatus, errorThrown) {
			alert("There was a problem retrieving the XML data:\n" + errorThrown);
		}
	});
}

function showContents() {
    
	if (oXmlHttp.readyState == 4) {
        // only if "OK"
        if (oXmlHttp.status == 200) {
         
        	responseText = trim(oXmlHttp.responseText);
          
			document.getElementById('article_view_div').innerHTML = responseText;
			
			clear_listTable_bgcolor();
			
			changeBgColorSelected(num_table_get);

        } else {
            alert("There was a problem retrieving the XML data:\n" + req.statusText);
        }
    }
}

function changeBgColorSelecting(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;
 
    y[0].style.backgroundColor = "#999999";
    y[1].style.backgroundColor = "#999999";
    y[2].style.backgroundColor = "#999999";
    y[3].style.backgroundColor = "#999999";
    
}

function changeBgColorSelected(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;

    y[0].style.backgroundColor = "#CCCCCC";
    y[1].style.backgroundColor = "#CCCCCC";
    y[2].style.backgroundColor = "#CCCCCC";
    y[3].style.backgroundColor = "#CCCCCC";
    
}

function enterKeyPressed() {
	articleList();
}

function showRevision(articleRevision) {
	/*
	var $targetDiv = document.getElementById(articleRevision);
	$targetDiv.animate({
		opacity : 'toggle',
		height : 'toggle'
	}, 'slow');
	*/
	
	var targetDiv = document.getElementById(articleRevision);
	if (targetDiv.style.display == 'none') {
		document.getElementById(articleRevision).style.display = 'block';
	} else {
		document.getElementById(articleRevision).style.display = 'none';
	}
}

</script>

<form name="f" method="post">

    <table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
    		<td width="100%" align="right" height="22">페이지당 목록갯수
				<select id="per_page" name="per_page" onchange="articleList()"></select>
				&nbsp;&nbsp; 총 목록갯수 : <%=totalRows %> &nbsp;&nbsp;  페이지 수: <%=pageNum %>
			</td>
	  	</tr>
	</table>
  	<!-- list -->
  	<table id="listTable" name="listTable" border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB">
	  	<tr>
			<td width="30" align="center" bgcolor="#E6ECDE">번호</td>
			<td align="center" bgcolor="#E6ECDE">제목</td>
			<td width="100" align="center" bgcolor="#E6ECDE">작성자</td>
			<td width="100" align="center" bgcolor="#E6ECDE">작성일시</td>
	  	</tr>
<%
	Iterator articleIter = articleList.getList().iterator();
	
	String articleNum = "";
	String blanktitle = "";
	String retitle = "";
	int numTable = 0;
	while ( articleIter.hasNext() ) {
		numTable ++;
		articleNum = "";
		Article article = (Article)articleIter.next();
		if (article.getReplydepth() == 0) {
			articleNum = Integer.toString(article.getNum());
		}
		
		blanktitle = "";
		for (int j=1; j <= article.getReplydepth() ; j++) {
		    blanktitle = blanktitle + "&nbsp;&nbsp;";
		}

		retitle = "";
		if (article.getReplydepth() == 1) {
		    retitle = "RE: ";
		} else if (article.getReplydepth() == 0) {
		    retitle = "";
		} else {
		    retitle = retitle + "RE*" + article.getReplydepth() + ": ";
		}
%>		  	
	  	<tr>
			<td width="30" align="center" bgcolor="#FFFFFF" onClick="get_contents('<%=article.getNo()%>', <%=article.getRevision()%>, '', <%=numTable%>)">
				<%= articleNum %>
			</td>
			<td align="left" bgcolor="#FFFFFF" onClick="get_contents('<%=article.getNo()%>', <%=article.getRevision()%>, '', <%=numTable%>)">
				<%=blanktitle%><%=retitle%><%=article.getTitle()%>
			</td>
			<td width="100" align="center" bgcolor="#FFFFFF" onClick="get_contents('<%=article.getNo()%>', <%=article.getRevision()%>, '', <%=numTable%>)">
				<%= article.getName() %>
			</td>
			<td width="100" align="center" bgcolor="#FFFFFF" onClick="get_contents('<%=article.getNo()%>', <%=article.getRevision()%>, '', <%=numTable%>)">
				<%= article.getFillUpDateTime() %>
			</td>
	  	</tr>
<%
	}
%>		  	
  	</table>
  	<!-- /list -->	 
  	
  	<table width="100%" cellspacing="0" bgcolor="#F4F4F4" border="0" cellpadding="1">
	  <tr>
	  	<td align="left" valign="middle" class="search_form">
		  	<page:paging>
		  		<page:pg><%=selectedPage %></page:pg>
		  		<page:pgLimit>10</page:pgLimit>
		  		<page:totalRows><%=totalRows %></page:totalRows>
		  		<page:rowsLimit><%=perPage %></page:rowsLimit>
		  		<page:urlString><%=currentURL %></page:urlString>
		  		<page:pageArgument>page</page:pageArgument>
		  	</page:paging>
		</td>
	
	    <td align="right" valign="middle" class="search_form">
	     <!-- target -->
	      <select name="target">
	      <option value="title" <%=title_selected%>>제목</option>
	      <option value="contents" <%=contents_selected%>>내용</option>
	      <option value="writer" <%=writer_selected%>>글쓴이</option>
	      <option value="title-content" <%=titlecontent_selected%>>제목,내용</option>
	      </select>
	
	  	<!-- time_span -->
	      <select name="time_span">
	      <option value="week" <%=week_selected%>>한주</option>
	      <option value="month" <%=month_selected%>>한달</option>
	      <option value="year" <%=year_selected%>>1년</option>
	      <option value="all" <%=all_selected%>>전체</option>
	      </select>
	
	  	<!-- search_string -->
	      <input type="text" name="search_string"
	       size="20" maxlength="60" value="<%=search_string%>"> 
	    </td>
	    <td align="left" valign="middle" onClick="articleList()">
	    	검색
	    </td>
	  </tr>
	</table>	  
</form>

<div id="article_view_div" name="article_view_div">
</div>

<script language="JavaScript">
	
	var select_id = 'per_page';
	var list_name = 'per_page';
	var url = 'OptionActionAjax.do';
	var add_total = false;
	var selected_value = '<%=perPage%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
	
</script>