package kr.co.leaderway.mywork.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;

public class BindUtil {

	private Log log = LogFactory.getLog(this.getClass());
	private MessageResources messageResources;
	
	public BindUtil(MessageResources messageResources) {
		this.messageResources = messageResources;
	}
	
	public static void bind(HttpServletRequest request, Object object) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
	     
	    Field[] fields = object.getClass().getDeclaredFields();
	    Method m[] = object.getClass().getDeclaredMethods();
	    
	    for (int i=0; i<fields.length; i++) {     
	    
	    	String fieldName = fields[i].getName();	    	
	    	String value = request.getParameter(fieldName);

	    	if (value == null || value.equals("")) {
	    		
	    		if (request.getAttribute(fieldName) != null) {
	    		value = request.getAttribute(fieldName).toString();
	    		}
	    		
	    	}
	    	
	    	if (value != null) {
	    		
	    	 	String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
		    	
	    		for (int j=0; j<m.length; j++) {     
	    			
	    			if (m[j].getName().equals(methodName)) {
		    			  try {
							m[j].invoke(object, value);
						} catch (InvocationTargetException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
	    			}
	    		}
	    		
	    	}
	    	
	    	
	    } 
	    
	}
	
	
}
