package kr.co.leaderway.mywork.system.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.multiLanguage.MultiLanguageService;
import kr.co.leaderway.mywork.multiLanguage.model.MultiLanguage;
import kr.co.leaderway.mywork.system.SystemService;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SystemAction extends BaseAction{
	
	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, 
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response)
	        										throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("set_language")) {
			
			String languageCodeSelected = request.getParameter("languageCodeSelected");
			
			MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
 
			MultiLanguage multiLanguage = multiLanguageService.getMultiLanguageLang(languageCodeSelected);
			
			request.getSession().setAttribute("sessionLanguage", multiLanguage.getMultiLanguageLangDescription());
			request.getSession().setAttribute("sessionLanguageNo", multiLanguage.getMultiLanguageLangNo());
			
			String xmlString  = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";
				   xmlString += "<response id=\"set_language\">";
				   xmlString += "<result>" + multiLanguage.getMultiLanguageLangDescription() + "</result>";
				   xmlString += "</response>";
				   
			request.setAttribute("xmlString", xmlString);
			 
			return mapping.findForward("ajax_response");
		
		} else if (mode.equals("get_nlsDateFormat")) {
			
			SystemService systemService = (SystemService)ServiceCallUtil.call(SystemService.class, getServiceType("SystemService"));
			
			String nlsDateFormat = (String)systemService.getNlsDateFormat();
			
			request.setAttribute("systemMessage", nlsDateFormat);
			
			return mapping.findForward("system_view");
			
	    } else { 
	    	
	    }
		return null;
	}
	
}
