package kr.co.leaderway.mywork.schedule.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.schedule.ScheduleService;
import kr.co.leaderway.mywork.schedule.form.ScheduleForm;
import kr.co.leaderway.mywork.schedule.model.LastSolarLunarOfLunarMonth;
import kr.co.leaderway.mywork.schedule.model.LastSolarLunarOfLunarMonthListSet;
import kr.co.leaderway.mywork.schedule.model.Schedule;
import kr.co.leaderway.mywork.schedule.model.ScheduleSearchParameter;
import kr.co.leaderway.mywork.schedule.model.SolarLunar;
import kr.co.leaderway.mywork.schedule.model.SolarLunarListSet;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.util.DateTool;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class ScheduleAction extends BaseAction {

	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if (mode.equals("add_schedule")) {
		
			String insertedScheduleNo = add_schedule(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ScheduleAction") );
			redirect.addParameter("mode", "view_schedule");
			redirect.addParameter("no", insertedScheduleNo);
			return redirect;
			
		} else if (mode.equals("add_schedule_form")) {
			
			request.setAttribute("contentTitle", "일정 관리 - 일정 추가");
				
			return mapping.findForward("schedule_add_form");
			
		} else if (mode.equals("view_schedule")) {
			
			view_schedule(mapping, form, request, response);
			request.setAttribute("contentTitle", "일정 관리 - 일정 보기");
			
			return mapping.findForward("schedule_view");
		
		} else if (mode.equals("modify_schedule_form")) {
			 
			view_schedule(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "일정 관리 - 일정 수정");	
			return mapping.findForward("schedule_modify_form");
			
		} else if (mode.equals("modify_schedule")) {
			
			modify_schedule(mapping, form, request, response);
				
			ScheduleForm scheduleForm = (ScheduleForm) form;
			String no = scheduleForm.getNo();
			String beforeUrl = request.getParameter("before_url");
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ScheduleAction") );
			redirect.addParameter("mode", "view_schedule");
			redirect.addParameter("no", no);
			redirect.addParameter("before_url", beforeUrl);
			return redirect;
			
		} else if (mode.equals("delete_schedule")) {
			
			delete_schedule(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ScheduleAction") );
			redirect.addParameter("mode", "list_schedule");
			return redirect;
		
	    } else { // show_calendar
	    	
	    	show_calendar(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "일정 관리 - 리스트");

	    	String week_string = request.getParameter("week") == null ? "0" : (String)request.getParameter("week");
			int week = Integer.parseInt(week_string);
	    	String weekspan_string = request.getParameter("weekspan") == null ? "0" : (String)request.getParameter("weekspan");
			int weekspan = Integer.parseInt(weekspan_string);
			String monthspan_string = request.getParameter("monthspan") == null ? "0" : (String)request.getParameter("monthspan");
			int monthspan = Integer.parseInt(monthspan_string);
			String start_string = request.getParameter("start") == null ? "0" : (String)request.getParameter("start");
			long start = Long.parseLong(start_string);
			
			if (weekspan == 1 || week == 1) {
				return mapping.findForward("show_calendar");
			} else if (monthspan == 1 || start == 0) {
				return mapping.findForward("show_calendar_with_content");
			} else {
				return mapping.findForward("show_calendar");
			}
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void show_calendar(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String year_string = request.getParameter("year") == null ? "0" : (String)request.getParameter("year");
		int year = Integer.parseInt(year_string);
		String month_string = request.getParameter("month") == null ? "0" : (String)request.getParameter("month");
		int month = Integer.parseInt(month_string);
		String day_string = request.getParameter("day") == null ? "0" : (String)request.getParameter("day");
		int day = Integer.parseInt(day_string);
		String week_string = request.getParameter("week") == null ? "0" : (String)request.getParameter("week");
		int week = Integer.parseInt(week_string);
		String start_string = request.getParameter("start") == null ? "0" : (String)request.getParameter("start");
		long start = Long.parseLong(start_string);
		String end_string = request.getParameter("end") == null ? "0" : (String)request.getParameter("end");
		long end = Long.parseLong(end_string);
		String dayspan_string = request.getParameter("dayspan") == null ? "0" : (String)request.getParameter("dayspan");
		int dayspan = Integer.parseInt(dayspan_string);
		String weekspan_string = request.getParameter("weekspan") == null ? "0" : (String)request.getParameter("weekspan");
		int weekspan = Integer.parseInt(weekspan_string);
		String monthspan_string = request.getParameter("monthspan") == null ? "0" : (String)request.getParameter("monthspan");
		int monthspan = Integer.parseInt(monthspan_string);
		String category_string = request.getParameter("category") == null ? "" : (String)request.getParameter("category");
		String category_url = category_string;

		long start_mod = 0;
		int last_day = 0;
		if (dayspan == 1) {
			start_mod = start + (86400 * 15);
			year = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "yyyy"));
			month = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "MM"));
			day = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "dd"));
		} else if (dayspan == 2) {
			start_mod = start - (86400 * 15);
			year = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "yyyy"));
			month = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "MM"));
			day = Integer.parseInt(DateTool.TimeStampToDateString(start_mod, "dd"));
		} else if (weekspan != 1 && start != 0) {
			year = Integer.parseInt(DateTool.TimeStampToDateString(start, "yyyy"));
			month = Integer.parseInt(DateTool.TimeStampToDateString(start, "MM"));
			day = Integer.parseInt(DateTool.TimeStampToDateString(start, "dd"));
		} else if (weekspan == 1 && end != 0) {
			year = Integer.parseInt(DateTool.TimeStampToDateString(end, "yyyy"));
			month = Integer.parseInt(DateTool.TimeStampToDateString(end, "MM"));
			day = 1;
		} else if (start == 0 && end == 0 && year != 0 && month != 0) {
		  	day = 1;
		  	start = DateTool.dateStringToTimeStamp(year, month, day, 0, 0, 0);
		  	last_day = DateTool.lastDayOfMonth(year, month);
		  	end = DateTool.dateStringToTimeStamp(year, month, last_day, 23, 59, 59);
		  	monthspan = 1;
		} else {
			year = DateTool.yearOfToday();
			month = DateTool.monthOfToday();
			day = DateTool.dayOfToday();

			last_day = DateTool.lastDayOfMonth(year, month);
			start = DateTool.dateStringToTimeStamp(year, month, 1, 0, 0, 0);
		  	end = DateTool.dateStringToTimeStamp(year, month, last_day, 23, 59, 59);
		  	monthspan = 1;

		}
		
		if(year > 0 || month > 0 || day > 0) { // 상황에 따라 현재 날자값을 설정한다.

		    if(year > 9999) {
		    	year = 9999;
		    } else if(year < 1) {
		    	year = 1;
		    }

		    if(month > 12) {
		        year++;
		        month = 1;
		    } else if(month < 1) {
		        year--;
		        month = 12;
		    }

		    last_day = DateTool.lastDayOfMonth(year, month);

		    if(day > last_day) {
		        month++;
		        day = 1;
		        last_day = DateTool.lastDayOfMonth(year, month);
		    } else if(day < 1) {
		        month--;
		        last_day = DateTool.lastDayOfMonth(year, month);
		        day = last_day; // 현재 날짜를 마지막 일로 변경한다.
		    }

		} else { // 입력값이 없을 경우 현재일을 기준으로 출력한다.

			year = DateTool.yearOfToday();
			month = DateTool.monthOfToday();
			day = DateTool.dayOfToday();

			last_day = DateTool.lastDayOfMonth(year, month);

		}

		int re_month = month - 1;
		int before_month_last_day = DateTool.lastDayOfMonth(year, re_month);

		int start_weekdays = DateTool.startWeekDayOfMonth(year, month) - 1; 
		int show_day = before_month_last_day - (start_weekdays - 1);
	    long calendar_start_date = DateTool.dateStringToTimeStamp(year, re_month, show_day, 0, 0, 0);
	    int lastWeekDay = DateTool.lastWeekDayOfMonth(year, month);
		long calendar_end_date = DateTool.dateStringToTimeStamp(year, month, last_day, 23, 59, 59) + (7 - lastWeekDay) * 86400;
		String calendarFromDate = DateTool.TimeStampToDateString(calendar_start_date, "yyyyMMdd");
		String calendarToDate = DateTool.TimeStampToDateString(calendar_end_date, "yyyyMMdd");
		
		ScheduleService scheduleService = (ScheduleService)ServiceCallUtil.call(ScheduleService.class, getServiceType("ScheduleService"));
		List solarLunarList = scheduleService.getLunarDateBySolarDateRange(calendarFromDate, calendarToDate);
		
		String month_modified = "";
		if (month < 10) {
			month_modified = "0" + month;
		} else {
			month_modified = "" + month;
		}
 		
		String category = "aa";
		Iterator solarLunarListIterator = solarLunarList.iterator();
		
		String lunarYearMonthSelected = "";
		String firstLunarDateSelected = "";
		String lastLunarDateSelected = "";
		String solarDateOfFirstLunarDate = "";
		String solarDateOfLastLunarDate = "";
		
		List lastSolarLunarOfLunarMonthList = new ArrayList();
		
		while (solarLunarListIterator.hasNext()) {
			SolarLunar nowSolarLunar = (SolarLunar)solarLunarListIterator.next();
			String nowDate = nowSolarLunar.getSolarDate();
			
			String nowLunarDate = nowSolarLunar.getLunarDate();
			String nowLunarYearMonth = nowLunarDate.substring(0, 6);
			
			if (nowLunarYearMonth.equals(lunarYearMonthSelected)) {
				
			} else {
				firstLunarDateSelected = nowLunarDate.substring(0, 6) + "01";

				SolarLunar firstSolarLunar = (SolarLunar)scheduleService.getSolarDateByLunarDate(firstLunarDateSelected);
				solarDateOfFirstLunarDate = firstSolarLunar.getSolarDate();
				
				SolarLunar lastSolarLunar = (SolarLunar)scheduleService.getLastLunarDateOfMonth(nowLunarYearMonth);
				lastLunarDateSelected = lastSolarLunar.getLunarDate();
				solarDateOfLastLunarDate = lastSolarLunar.getSolarDate();
				
				LastSolarLunarOfLunarMonth lastSolarLunarOfLunarMonth = new LastSolarLunarOfLunarMonth();
				lastSolarLunarOfLunarMonth.setLunarYearMonth(nowLunarYearMonth);
				lastSolarLunarOfLunarMonth.setSolarLunar(lastSolarLunar);
				lastSolarLunarOfLunarMonthList.add(lastSolarLunarOfLunarMonth);
		
			}
			
			ScheduleSearchParameter scheduleSearchParameter = new ScheduleSearchParameter();
			scheduleSearchParameter.setTargetDate(nowDate);
			scheduleSearchParameter.setTargetDateLunar(nowSolarLunar.getLunarDate());
			scheduleSearchParameter.setSolarDateOfFirstLunarDate(solarDateOfFirstLunarDate);
			scheduleSearchParameter.setSolarDateOfLastLunarDate(solarDateOfLastLunarDate);
			scheduleSearchParameter.setOwner(nowUserNo);
			List nowScheduleList = scheduleService.getScheduleOfDay(scheduleSearchParameter);
			nowSolarLunar.setScheduleList(nowScheduleList);
		}
		
		SolarLunarListSet solarLunarListSet = new SolarLunarListSet();
		solarLunarListSet.setSolarLunarList(solarLunarList);
		request.setAttribute("solarLunarListSet", solarLunarListSet);
		
		LastSolarLunarOfLunarMonthListSet lastSolarLunarOfLunarMonthListSet = new LastSolarLunarOfLunarMonthListSet();
		lastSolarLunarOfLunarMonthListSet.setLastSolarLunarOfLunarMonthList(lastSolarLunarOfLunarMonthList);
		request.setAttribute("lastSolarLunarOfLunarMonthListSet", lastSolarLunarOfLunarMonthListSet);

	}

	
	private String add_schedule(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		// $intime = time();
		
		String event_type_string = request.getParameter("event_type") == null ? "0" : (String)request.getParameter("event_type");
		int event_type = Integer.parseInt(event_type_string);
		String repeat_type_string = request.getParameter("repeat_type") == null ? "0" : (String)request.getParameter("repeat_type");
		int repeat_type = Integer.parseInt(repeat_type_string);
		String status_string = request.getParameter("status") == null ? "0" : (String)request.getParameter("status");
		int status = Integer.parseInt(status_string);
		String importance_string = request.getParameter("importance") == null ? "0" : (String)request.getParameter("importance");
		int importance = Integer.parseInt(importance_string);
		
		String closing_end_check = request.getParameter("closing_end_check") == null ? "N" : (String)request.getParameter("closing_end_check");  //월말부터
		String lunar_check = request.getParameter("lunar_check") == null ? "N" : (String)request.getParameter("lunar_check"); 					// 음력
		
		String fromDate = "";
		String fromTime = "";
		String toDate = "";
		String toTime = "";
		long fromDateTime = 0;
		int fromDays = 0;
		int toDays = 0;
		String repeatFromDate = "";
		String repeatEndDate = "";
		int fromWeek = 0;
		int toWeek = 0;
		int isLunar = 0;
		
		if (event_type == 1) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = request.getParameter("from_time_hour") + request.getParameter("from_time_minute") + "00";
			toDate = fromDate;
			toTime = fromTime;
		} else if (event_type == 2) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = request.getParameter("from_time_hour") + request.getParameter("from_time_minute") + "00";
			toDate = request.getParameter("end_time_year") + request.getParameter("end_time_month") + request.getParameter("end_time_day");
			toTime = request.getParameter("end_time_hour") + request.getParameter("end_time_minute") + "00";
		} else if (event_type == 3) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = "00" + "00" + "00";
			toDate = fromDate;
			toTime = "24" + "00" + "00";
		} else if (event_type == 4) {
		    if (closing_end_check.equals("Y")) {
		    	toDate = "9999" + "12" + "31";
				toTime = "24" + "00" + "00";
		    } else {
		    	toDate = request.getParameter("closing_time_year") + request.getParameter("closing_time_month") + request.getParameter("closing_time_day");
		    	toTime = request.getParameter("closing_time_hour") + request.getParameter("closing_time_minute") + "00";
		    }
		    fromDateTime = DateTool.dateStringToTimeStamp(request.getParameter("closing_time_year"), request.getParameter("closing_time_month"), request.getParameter("closing_time_day"), request.getParameter("closing_hour"), request.getParameter("closing_minute"), "00") 
		    			 - (Integer.parseInt(request.getParameter("show_day")) * 3600 * 24 + Integer.parseInt(request.getParameter("show_hour")) * 3600 + Integer.parseInt(request.getParameter("show_minute")) + 60 );
		    fromDate = DateTool.TimeStampToDateString(fromDateTime, "yyyyMMdd");
		    fromTime = DateTool.TimeStampToDateString(fromDateTime, "hhmm") + "00";
		}
		
		if (repeat_type == 4 && event_type == 2) {
			fromDays = Integer.parseInt(request.getParameter("from_time_days"));
			toDays = Integer.parseInt(request.getParameter("end_time_days"));
		} else if (repeat_type == 4) {
			fromDays = Integer.parseInt(request.getParameter("from_time_days"));
			toDays = fromDays;
		} else {
			fromDays = 99;
			toDays = 99;
		}
		
		if (repeat_type == 1) {
			repeatFromDate = "00000000";
			repeatEndDate = "00000000";
			fromWeek = 9;
			toWeek = 9;
		} else if (repeat_type == 3) {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = Integer.parseInt(request.getParameter("from_time_week"));
			toWeek = Integer.parseInt(request.getParameter("end_time_week"));
		} else if (repeat_type == 4) {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = Integer.parseInt(request.getParameter("from_time_week"));
			toWeek = Integer.parseInt(request.getParameter("end_time_week"));
		} else {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = 9;
			toWeek = 9;
		}
		
		if (lunar_check.equals("Y")) {
		  	isLunar = 1;
		} else {
			isLunar = 0;
		}
		
		Date date = new Date();
        java.sql.Timestamp timeStampDate = new Timestamp(date.getTime());
		long inTime = timeStampDate.getTime()/1000;
		
		int alarm = 1;
		int groupno = 1;
		String category = "22";
		
		Schedule schedule = new Schedule();
		schedule.setAlarm(alarm);
		schedule.setCategory(category);
		schedule.setEventType(event_type);
		schedule.setFromDate(fromDate);
		schedule.setFromDays(fromDays);
		schedule.setFromTime(fromTime);
		schedule.setFromWeek(fromWeek);
		schedule.setImportance(importance);
		schedule.setInTime(inTime);
		schedule.setIsLunar(isLunar);
		schedule.setOwner(nowUserNo);
		schedule.setRepeatEndDate(repeatEndDate);
		schedule.setRepeatFromDate(repeatFromDate);
		schedule.setRepeatType(repeat_type);
		schedule.setStatus(status);
		schedule.setText(request.getParameter("text"));
		schedule.setTitle(request.getParameter("title"));
		schedule.setToDate(toDate);
		schedule.setToDays(toDays);
		schedule.setToTime(toTime);
		schedule.setToWeek(toWeek);
		
		ScheduleService scheduleService = (ScheduleService)ServiceCallUtil.call(ScheduleService.class, getServiceType("ScheduleService"));
		String insertedScheduleNo = scheduleService.addSchedule(schedule);
		 
		/*
		  $result = mysql_query("INSERT INTO schedule VALUES('',
		    '$fil[title]', '$fil[text]', $event_type, 
		    '$from_date', '$from_time', '$to_date', '$to_time',
		     $from_week, $to_week, $from_days, $to_days,
		     $repeat_type, '$repeat_from_date', '$repeat_end_date', 
		     $userno, $groupno, $status, $alarm, $intime, $is_lunar, '$category', $importance)", $connect);
		
		  $this_no = mysql_insert_id();
		*/
		
		return insertedScheduleNo;
	}
	
	private void view_schedule(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String scheduleNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		ScheduleService scheduleService = (ScheduleService)ServiceCallUtil.call(ScheduleService.class, getServiceType("ScheduleService"));
		Schedule schedule = scheduleService.getScheduleByNo(scheduleNo, nowUserNo);
		
		request.setAttribute("schedule", schedule);		
	
	}
	
	private void modify_schedule(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		// $intime = time();
		String mod_no = request.getParameter("mod_no") == null ? "0" : (String)request.getParameter("mod_no");

		String event_type_string = request.getParameter("event_type") == null ? "0" : (String)request.getParameter("event_type");
		int event_type = Integer.parseInt(event_type_string);
		String repeat_type_string = request.getParameter("repeat_type") == null ? "0" : (String)request.getParameter("repeat_type");
		int repeat_type = Integer.parseInt(repeat_type_string);
		String status_string = request.getParameter("status") == null ? "0" : (String)request.getParameter("status");
		int status = Integer.parseInt(status_string);
		String importance_string = request.getParameter("importance") == null ? "0" : (String)request.getParameter("importance");
		int importance = Integer.parseInt(importance_string);
		
		String closing_end_check = request.getParameter("closing_end_check") == null ? "N" : (String)request.getParameter("closing_end_check");  //월말부터
		String lunar_check = request.getParameter("lunar_check") == null ? "N" : (String)request.getParameter("lunar_check"); 					// 음력
		
		String fromDate = "";
		String fromTime = "";
		String toDate = "";
		String toTime = "";
		long fromDateTime = 0;
		int fromDays = 0;
		int toDays = 0;
		String repeatFromDate = "";
		String repeatEndDate = "";
		int fromWeek = 0;
		int toWeek = 0;
		int isLunar = 0;
		
		if (event_type == 1) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = request.getParameter("from_time_hour") + request.getParameter("from_time_minute") + "00";
			toDate = fromDate;
			toTime = fromTime;
		} else if (event_type == 2) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = request.getParameter("from_time_hour") + request.getParameter("from_time_minute") + "00";
			toDate = request.getParameter("end_time_year") + request.getParameter("end_time_month") + request.getParameter("end_time_day");
			toTime = request.getParameter("end_time_hour") + request.getParameter("end_time_minute") + "00";
		} else if (event_type == 3) {
			fromDate = request.getParameter("from_time_year") + request.getParameter("from_time_month") + request.getParameter("from_time_day");
			fromTime = "00" + "00" + "00";
			toDate = fromDate;
			toTime = "24" + "00" + "00";
		} else if (event_type == 4) {
		    if (closing_end_check.equals("Y")) {
		    	toDate = "9999" + "12" + "31";
				toTime = "24" + "00" + "00";
		    } else {
		    	toDate = request.getParameter("closing_time_year") + request.getParameter("closing_time_month") + request.getParameter("closing_time_day");
		    	toTime = request.getParameter("closing_time_hour") + request.getParameter("closing_time_minute") + "00";
		    }
		    fromDateTime = DateTool.dateStringToTimeStamp(request.getParameter("closing_time_year"), request.getParameter("closing_time_month"), request.getParameter("closing_time_day"), request.getParameter("closing_hour"), request.getParameter("closing_minute"), "00") 
		    			 - (Integer.parseInt(request.getParameter("show_day")) * 3600 * 24 + Integer.parseInt(request.getParameter("show_hour")) * 3600 + Integer.parseInt(request.getParameter("show_minute")) + 60 );
		    fromDate = DateTool.TimeStampToDateString(fromDateTime, "yyyyMMdd");
		    fromTime = DateTool.TimeStampToDateString(fromDateTime, "hhmm") + "00";
		}
		
		if (repeat_type == 4 && event_type == 2) {
			fromDays = Integer.parseInt(request.getParameter("from_time_days"));
			toDays = Integer.parseInt(request.getParameter("end_time_days"));
		} else if (repeat_type == 4) {
			fromDays = Integer.parseInt(request.getParameter("from_time_days"));
			toDays = fromDays;
		} else {
			fromDays = 99;
			toDays = 99;
		}
		
		if (repeat_type == 1) {
			repeatFromDate = "00000000";
			repeatEndDate = "00000000";
			fromWeek = 9;
			toWeek = 9;
		} else if (repeat_type == 3) {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = Integer.parseInt(request.getParameter("from_time_week"));
			toWeek = Integer.parseInt(request.getParameter("end_time_week"));
		} else if (repeat_type == 4) {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = Integer.parseInt(request.getParameter("from_time_week"));
			toWeek = Integer.parseInt(request.getParameter("end_time_week"));
		} else {
			repeatFromDate = request.getParameter("repeat_from_time_year") + request.getParameter("repeat_from_time_month") + request.getParameter("repeat_from_time_day");
			repeatEndDate = request.getParameter("repeat_end_time_year") + request.getParameter("repeat_end_time_month") + request.getParameter("repeat_end_time_day");
			fromWeek = 9;
			toWeek = 9;
		}
		
		if (lunar_check.equals("Y")) {
		  	isLunar = 1;
		} else {
			isLunar = 0;
		}
		
		Date date = new Date();
        java.sql.Timestamp timeStampDate = new Timestamp(date.getTime());
		long inTime = timeStampDate.getTime()/1000;
		
		int alarm = 1;
		int groupno = 1;
		String category = "22";
		
		Schedule schedule = new Schedule();
		schedule.setNo(mod_no);
		schedule.setAlarm(alarm);
		schedule.setCategory(category);
		schedule.setEventType(event_type);
		schedule.setFromDate(fromDate);
		schedule.setFromDays(fromDays);
		schedule.setFromTime(fromTime);
		schedule.setFromWeek(fromWeek);
		schedule.setImportance(importance);
		schedule.setInTime(inTime);
		schedule.setIsLunar(isLunar);
		schedule.setOwner(nowUserNo);
		schedule.setRepeatEndDate(repeatEndDate);
		schedule.setRepeatFromDate(repeatFromDate);
		schedule.setRepeatType(repeat_type);
		schedule.setStatus(status);
		schedule.setText(request.getParameter("text"));
		schedule.setTitle(request.getParameter("title"));
		schedule.setToDate(toDate);
		schedule.setToDays(toDays);
		schedule.setToTime(toTime);
		schedule.setToWeek(toWeek);
		
		ScheduleService scheduleService = (ScheduleService)ServiceCallUtil.call(ScheduleService.class, getServiceType("ScheduleService"));
		scheduleService.updateSchedule(schedule);
	
	}
	
	private void delete_schedule(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		ScheduleForm scheduleForm = (ScheduleForm) form;
		
		Schedule schedule = new Schedule();
		PropertyUtils.copyProperties(schedule, scheduleForm);
		schedule.setOwner(nowUserNo);
		
		ScheduleService scheduleService = (ScheduleService)ServiceCallUtil.call(ScheduleService.class, getServiceType("ScheduleService"));
		scheduleService.deleteSchedule(schedule);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
}
