package kr.co.leaderway.mywork.bug.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkException.MyWorkNotAuthorizedException;
import kr.co.leaderway.mywork.board.model.SchemeAndCategory;
import kr.co.leaderway.mywork.bug.BugService;
import kr.co.leaderway.mywork.bug.form.BugForm;
import kr.co.leaderway.mywork.bug.model.Bug;
import kr.co.leaderway.mywork.bug.model.BugAssigneeInfo;
import kr.co.leaderway.mywork.bug.model.BugSearchParameter;
import kr.co.leaderway.mywork.bug.model.BugStatusInfo;
import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.category.CategoryUtil;
import kr.co.leaderway.mywork.category.model.BugCategory;
import kr.co.leaderway.mywork.category.model.CategoryScheme;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.project.ProjectService;
import kr.co.leaderway.mywork.project.model.Project;
import kr.co.leaderway.mywork.project.model.ProjectRoleGroupSearchParameter;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.right.model.RoleRight;
import kr.co.leaderway.mywork.statics.AccessType;
import kr.co.leaderway.mywork.statics.BugStatus;
import kr.co.leaderway.mywork.statics.RoleType;
import kr.co.leaderway.mywork.statics.UserType;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.model.User;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.mywork.util.TypeTool;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.util.MessageResources;

public class BugAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_bug_reporting")) {
			
			add_bug_reporting(mapping, form, request, response);
			
			BugForm bugForm = (BugForm) form;
			String projectNo = bugForm.getProjectNo();
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BugAction") );
			redirect.addParameter("mode", "list_bug");
			redirect.addParameter("projectNo", projectNo);
			return redirect;

		} else if (mode.equals("add_bug_form")) {
			
			list_accessible_project(mapping, form, request, response);
			String projectNo_string = request.getParameter("projectNo");
			request.setAttribute("projectNo", projectNo_string);
			list_categories_of_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 추가");
			
			return mapping.findForward("bug_add_form");
			
		} else if (mode.equals("view_bug")) {
			
			view_bug(mapping, form, request, response);
			
			return mapping.findForward("bug_view");
			
		} else if (mode.equals("move_bug")) {
			
			move_bug(mapping, form, request, response);
			
			String projectNo = request.getParameter("projectNo") != null ? request.getParameter("projectNo") : "0";
			String roleNo_string = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
			int roleNo = Integer.parseInt(roleNo_string);
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BugAction") );
			redirect.addParameter("mode", "list_bug");
			redirect.addParameter("projectNo", projectNo);
			redirect.addParameter("roleNo", roleNo);
			return redirect;
			
		} else if (mode.equals("modify_bug_form")) {
			
			if (request.getParameter("redirected") != null || (String)request.getParameter("redirected") == "redirected") {
				list_accessible_project(mapping, form, request, response);
				String projectNo_string = request.getParameter("projectNo");
				request.setAttribute("projectNo", projectNo_string);
				list_categories_of_project(mapping, form, request, response);
				request.setAttribute("contentTitle", "버그 관리 - 수정");
				view_bug(mapping, form, request, response);
				
				return mapping.findForward("bug_modify_form");
				

			} else {
				
				ActionRedirect redirect = new ActionRedirect(mapping.findForward("BugAction"));
				redirect.addParameter("mode", "modify_bug_form");
				redirect.addParameter("projectNo", request.getParameter("projectNo"));
				redirect.addParameter("no", request.getParameter("no"));
				
				BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
				
				MyWorkList categoryList = bugService.getBugCategoryList(request.getParameter("no")); 
				
				Iterator categoryIter = categoryList.getList().iterator();
			
				while ( categoryIter.hasNext() ) {
					BugCategory category = (BugCategory)categoryIter.next();		
					redirect.addParameter("category_" + category.getSchemeNo(),category.getValue());
				}

				redirect.addParameter("redirected", "redirected");
				
				return redirect;
			}
			
		} else if (mode.equals("modify_bug")) {
			
			modify_bug(mapping, form, request, response);
				
			BugForm bugForm = (BugForm) form;
			String projectNo = bugForm.getProjectNo();
			String no = bugForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BugAction") );
			redirect.addParameter("mode", "list_bug");
			redirect.addParameter("projectNo", projectNo);
			return redirect;
			
		} else if (mode.equals("delete_bug")) {
			
			delete_bug(mapping, form, request, response);
				
			BugForm bugForm = (BugForm) form;
			String projectNo = bugForm.getProjectNo();
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BugAction") );
			redirect.addParameter("mode", "list_bug");
			redirect.addParameter("projectNo", projectNo);
			return redirect;
			
		} else if (mode.equals("manage_bug")) {
			
			manage_bug(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 메인");
			
			return mapping.findForward("bug_manage_view");
			
		} else if (mode.equals("assign_category_scheme_form")) {
			
			manage_bug(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 카테고리 Scheme 할당");
			
			return mapping.findForward("category_scheme_assign_form");
		
		} else if (mode.equals("move_bug_status_form")) {
			
			view_bug(mapping, form, request, response);
			
			String isForward = request.getParameter("isForward") != null ? request.getParameter("isForward") : "0";
			
			if (isForward.equals("1")) {
				return mapping.findForward("bug_status_move_form");
			} else {
				return mapping.findForward("bug_status_move_form_back");
			}
			
		} else if (mode.equals("list_bug")) {
	    	
			list_accessible_project(mapping, form, request, response);
			list_categories_of_project(mapping, form, request, response);
	    	list_bug_reporting(mapping, form, request, response);
	    	
	    	String roleNo_string = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
			int roleNo = Integer.parseInt(roleNo_string);
			
	    	if (roleNo == 2) {  // 검토
	    		request.setAttribute("contentTitle", "버그 관리 - 검토대상 버그 리포팅");
		    	
	    	} else if (roleNo == 3) {  // 검토중
				request.setAttribute("contentTitle", "버그 관리 - 검토중인 버그 리포팅");
		    	
			} else if (roleNo == 4) {  // 할당
				request.setAttribute("contentTitle", "버그 관리 - 할당대상 버그 리포팅");
		    	
			} else if (roleNo == 8) {  // 개발
				request.setAttribute("contentTitle", "버그 관리 - 할당된 버그 리포팅");
		    	
			} else if (roleNo == 9) {  // 개발중
				request.setAttribute("contentTitle", "버그 관리 - 진행중인 버그 리포팅");
		    	
			} else if (roleNo == 16) {  // 평가
				request.setAttribute("contentTitle", "버그 관리 - 평가대상 버그 리포팅");
		    	
			} else if (roleNo == 32) {  // 확인
				request.setAttribute("contentTitle", "버그 관리 - 확인대상 버그 리포팅");
		    	
			} else {
				request.setAttribute("contentTitle", "버그 관리 - 버그 리스트");
		    	
			}
	    	return mapping.findForward("bug_list");
	    	
		} else if (mode.equals("list_bug_treated_by_me")) {
	    	
			list_accessible_project(mapping, form, request, response);
			list_categories_of_project(mapping, form, request, response);
	    	list_bug_reporting_alter(mapping, form, request, response);
	    	
	    	String roleNo_string = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
			int roleNo = Integer.parseInt(roleNo_string);
			
	    	if (roleNo == 2) {  // 검토
	    		request.setAttribute("contentTitle", "버그 관리 - 검토대상 버그 리포팅");
		    	
	    	} else if (roleNo == 3) {  // 검토중
				request.setAttribute("contentTitle", "버그 관리 - 검토중인 버그 리포팅");
		    	
			} else if (roleNo == 4) {  // 할당
				request.setAttribute("contentTitle", "버그 관리 - 할당대상 버그 리포팅");
		    	
			} else if (roleNo == 8) {  // 개발
				request.setAttribute("contentTitle", "버그 관리 - 할당된 버그 리포팅");
		    	
			} else if (roleNo == 9) {  // 개발중
				request.setAttribute("contentTitle", "버그 관리 - 진행중인 버그 리포팅");
		    	
			} else if (roleNo == 16) {  // 평가
				request.setAttribute("contentTitle", "버그 관리 - 평가대상 버그 리포팅");
		    	
			} else if (roleNo == 32) {  // 확인
				request.setAttribute("contentTitle", "버그 관리 - 확인대상 버그 리포팅");
		    	
			} else {
				request.setAttribute("contentTitle", "버그 관리 - 버그 리스트");
		    	
			}
	    	return mapping.findForward("bug_list_alter");
	    	
	    } else {
	    	
	    	list_accessible_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 메인");
			
			return mapping.findForward("bug_project_list");
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_bug_reporting(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String projectNo = request.getParameter("projectNo");
		
		String roleNo_string = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
		int roleNo = Integer.parseInt(roleNo_string);
		
		Project project = new Project();
		project.setNo(projectNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.browsing), remoteUserIpAddressBin)) {   // 프로젝트에 브라우징 권한이 있어야 버그 리포팅 리스트 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to list bug report on this project");
		}
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		request.setAttribute("categorySchemeList", categorySchemeList);

		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		String bug_status_string = request.getParameter("bug_status") != null ? request.getParameter("bug_status") : "0";
		int bug_status = Integer.parseInt(bug_status_string);
		
		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		
		BugSearchParameter bugSearchParameter = new BugSearchParameter();
		bugSearchParameter.setProjectNo(projectNo);
		bugSearchParameter.setCurrentPage(page);
		bugSearchParameter.setRowsPerPage(per_page);
		bugSearchParameter.setTime(time);
		
		if (roleNo == 2) {  // 검토
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.reported));
		} else if (roleNo == 3) {  // 검토중
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.inspecting));
		} else if (roleNo == 4) {  // 할당
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.accepted));
		} else if (roleNo == 8) {  // 개발
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.assigned));
		} else if (roleNo == 9) {  // 개발중
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.progressing));
		} else if (roleNo == 16) {  // 평가
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.evaluating));
		} else if (roleNo == 32) {  // 확인
			bugSearchParameter.setStatus(Integer.parseInt(BugStatus.waitingAck));
		} else {
			bugSearchParameter.setStatus(bug_status);
		}
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		List SchemeAndCategoryList = new ArrayList();
		while ( categorySchemeIter.hasNext() ) {
			
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			
			SchemeAndCategory schemeAndCategory = new SchemeAndCategory();
			
			schemeAndCategory.setSchemeNo(categoryScheme.getNo());
	
			schemeAndCategory.setCategory(request.getParameter("category_" + categoryScheme.getNo()));
			
			SchemeAndCategoryList.add(schemeAndCategory);
		}
		
		if (search.equals("title")) {
			bugSearchParameter.setTitle(search_string);
		} else if (search.equals("contents")) {
			bugSearchParameter.setContents(search_string);
		} else if (search.equals("writer")) {
			bugSearchParameter.setName(search_string);
		} else if (search.equals("title-contents")) {
			bugSearchParameter.setAll(search_string);
		}
		
		bugSearchParameter.setSchemeAndCategories(SchemeAndCategoryList);
		
		MyWorkList bugReportingList = bugService.listBugReporting(bugSearchParameter);
		
		request.setAttribute("bugReportingList", bugReportingList);
		
		request.setAttribute("contentTitle", "버그 관리 - 리스트");
		
		List roleList = rightService.getRoleRightListOnObjectByUserNo("project", project, nowUserNo);
		
		List roleListNow = new ArrayList();
		Iterator roleIter = roleList.iterator();
		
		boolean role2Added = false;
		boolean role4Added = false;
		boolean role8Added = false;
		boolean role16Added = false;
		boolean role32Added = false;
		
		while ( roleIter.hasNext() ) {

			RoleRight roleRight = (RoleRight)roleIter.next();
			
			int nowRole = roleRight.getRoleRight();
			
			if ((nowRole & 2) > 0 && !role2Added) {  	//검토 
				
				Option optionNow = new Option();
				optionNow.setName("검토");
				optionNow.setValue("2");
				roleListNow.add(optionNow);
				
				Option optionNowFollower = new Option();
				optionNowFollower.setName("검토중");
				optionNowFollower.setValue("3");
				roleListNow.add(optionNowFollower);
				
				role2Added = true;
			}
			
			if ((nowRole & 4) > 0 && !role4Added) {		//할당
				Option optionNow = new Option();
				optionNow.setName("할당");
				optionNow.setValue("4");
				roleListNow.add(optionNow);
				role4Added = true;
			}
			
			if ((nowRole & 8) > 0 && !role8Added) {		//개발
				Option optionNow = new Option();
				optionNow.setName("개발");
				optionNow.setValue("8");
				roleListNow.add(optionNow);
				
				Option optionNowFollower = new Option();
				optionNowFollower.setName("개발중");
				optionNowFollower.setValue("9");
				roleListNow.add(optionNowFollower);
				
				role8Added = true;
			}
			
			if ((nowRole & 16) > 0 && !role16Added) {	//평가
				Option optionNow = new Option();
				optionNow.setName("평가");
				optionNow.setValue("16");
				roleListNow.add(optionNow);
				role16Added = true;
			}
			
			/*
			if ((nowRole & 32) > 0 && !role32Added) {	//확인
				Option optionNow = new Option();
				optionNow.setName("확인");
				optionNow.setValue("32");
				roleListNow.add(optionNow);
				role32Added = true;
			}
			*/
			
		}
		
		//확인
		Option optionNow = new Option();
		optionNow.setName("확인");
		optionNow.setValue("32");
		roleListNow.add(optionNow);
		role32Added = true;
		
		request.setAttribute("roleList", roleListNow);
 
	}

	@SuppressWarnings("unchecked")
	private void list_bug_reporting_alter(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String projectNo = request.getParameter("projectNo");
		
		String roleNo_string = request.getParameter("roleNo") != null ? request.getParameter("roleNo") : "0";
		int roleNo = Integer.parseInt(roleNo_string);
		
		Project project = new Project();
		project.setNo(projectNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.browsing), remoteUserIpAddressBin)) {   // 프로젝트에 브라우징 권한이 있어야 버그 리포팅 리스트 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to list bug report to this project");
		}
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		request.setAttribute("categorySchemeList", categorySchemeList);

		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		String bug_status_string = request.getParameter("bug_status") != null ? request.getParameter("bug_status") : "-1";
		int bug_status = Integer.parseInt(bug_status_string);
		
		String my_list = request.getParameter("my_list") != null ? request.getParameter("my_list") : "";
		
		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		
		BugSearchParameter bugSearchParameter = new BugSearchParameter();
		bugSearchParameter.setProjectNo(projectNo);
		bugSearchParameter.setCurrentPage(page);
		bugSearchParameter.setRowsPerPage(per_page);
		bugSearchParameter.setTime(time);
		bugSearchParameter.setUserNo(nowUserNo);
		bugSearchParameter.setStatus(bug_status);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		List SchemeAndCategoryList = new ArrayList();
		while ( categorySchemeIter.hasNext() ) {
			
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			
			SchemeAndCategory schemeAndCategory = new SchemeAndCategory();
			
			schemeAndCategory.setSchemeNo(categoryScheme.getNo());
	
			schemeAndCategory.setCategory(request.getParameter("category_" + categoryScheme.getNo()));
			
			SchemeAndCategoryList.add(schemeAndCategory);
		}
		
		if (search.equals("title")) {
			bugSearchParameter.setTitle(search_string);
		} else if (search.equals("contents")) {
			bugSearchParameter.setContents(search_string);
		} else if (search.equals("writer")) {
			bugSearchParameter.setName(search_string);
		} else if (search.equals("title-contents")) {
			bugSearchParameter.setAll(search_string);
		}
		
		bugSearchParameter.setSchemeAndCategories(SchemeAndCategoryList);
		
		MyWorkList bugReportingList = bugService.listBugReportingAlter(bugSearchParameter);
		
		request.setAttribute("bugReportingList", bugReportingList);
		
		request.setAttribute("contentTitle", "버그 관리 - 리스트");
		
		List roleList = rightService.getRoleRightListOnObjectByUserNo("project", project, nowUserNo);
		
		List roleListNow = new ArrayList();
		Iterator roleIter = roleList.iterator();
		
		boolean role2Added = false;
		boolean role4Added = false;
		boolean role8Added = false;
		boolean role16Added = false;
		boolean role32Added = false;
		
		while ( roleIter.hasNext() ) {

			RoleRight roleRight = (RoleRight)roleIter.next();
			
			int nowRole = roleRight.getRoleRight();
			
			if ((nowRole & 2) > 0 && !role2Added) {  	//검토 
				
				Option optionNow = new Option();
				optionNow.setName("검토");
				optionNow.setValue("2");
				roleListNow.add(optionNow);
				
				Option optionNowFollower = new Option();
				optionNowFollower.setName("검토중");
				optionNowFollower.setValue("3");
				roleListNow.add(optionNowFollower);
				
				role2Added = true;
			}
			
			if ((nowRole & 4) > 0 && !role4Added) {		//할당
				Option optionNow = new Option();
				optionNow.setName("할당");
				optionNow.setValue("4");
				roleListNow.add(optionNow);
				role4Added = true;
			}
			
			if ((nowRole & 8) > 0 && !role8Added) {		//개발
				Option optionNow = new Option();
				optionNow.setName("개발");
				optionNow.setValue("8");
				roleListNow.add(optionNow);
				
				Option optionNowFollower = new Option();
				optionNowFollower.setName("개발중");
				optionNowFollower.setValue("9");
				roleListNow.add(optionNowFollower);
				
				role8Added = true;
			}
			
			if ((nowRole & 16) > 0 && !role16Added) {	//평가
				Option optionNow = new Option();
				optionNow.setName("평가");
				optionNow.setValue("16");
				roleListNow.add(optionNow);
				role16Added = true;
			}
			
			/*
			if ((nowRole & 32) > 0 && !role32Added) {	//확인
				Option optionNow = new Option();
				optionNow.setName("확인");
				optionNow.setValue("32");
				roleListNow.add(optionNow);
				role32Added = true;
			}
			*/
			
		}
		
		//확인
		Option optionNow = new Option();
		optionNow.setName("확인");
		optionNow.setValue("32");
		roleListNow.add(optionNow);
		role32Added = true;
		
		request.setAttribute("roleList", roleListNow);
 
	}
	
	private void add_bug_reporting(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		BugForm bugForm = (BugForm) form;
		
		Bug bug = new Bug();
		PropertyUtils.copyProperties(bug, bugForm);

		HttpSession session = request.getSession();
		
		String projectNo = bug.getProjectNo();
		
		Project project = new Project();
		project.setNo(projectNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.write), remoteUserIpAddressBin)) {   // 프로젝트에 쓰기 권한이 있어야 버그 리포팅 추가 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to add bug report to this project");
		}
		
		List categoryList = new ArrayList();
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
	
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		while ( categorySchemeIter.hasNext() ) {
			
			BugCategory bugCategory = new BugCategory();
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			String schemeNo = categoryScheme.getNo();
			String categoryParameterName = "category_" + schemeNo;
			
			bugCategory.setSchemeNo(schemeNo);
			bugCategory.setValue(request.getParameter(categoryParameterName));
			
			categoryList.add(bugCategory);
		}
		
		User user = new User();
		user.setNo(nowUserNo);
		bug.setOwner(user);
		bug.setUserNo(nowUserNo);
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		bugService.addBugReporting(bug, categoryList);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_bug(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BugForm bugForm = (BugForm) form;
		
		String projectNo = bugForm.getProjectNo();
		
		Project project = new Project();
		project.setNo(projectNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.write), remoteUserIpAddressBin)) {   // 프로젝트에 쓰기 권한이 있어야 버그 리포팅 삭제 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to delete bug report to this project");
		}
		
		// TODO 소유자 이며 진행이 안되어 있는지 추가 확인
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		bugService.deleteBug(bugForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	private void view_bug(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String bugNo = request.getParameter("no");
		
		HttpSession session = request.getSession();

		User user = new User();
		user.setNo(nowUserNo);
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		
		BugSearchParameter bugSearchParameter = new BugSearchParameter();
		bugSearchParameter.setNo(bugNo);
		Bug bug = bugService.findBugReporting(bugSearchParameter);
		
		Project project = new Project();
		project.setNo(bug.getProjectNo());
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.read), remoteUserIpAddressBin)) {   // 프로젝트에 읽기 권한이 있어야 버그 리포팅 읽기 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to read bug report to this project");
		}
		
		MessageResources messageResources = getResources(request);
		TypeTool typeTool = new TypeTool(messageResources);
		bug.setStatusName(typeTool.getMessageNameFromValue(BugStatus.class, bug.getStatus().toString()));
		request.setAttribute("bug", bug);	
		
		MyWorkList categoryList = bugService.getBugCategoryList(bugNo); 

		Iterator categoryIter = categoryList.getList().iterator();
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		
		List categoryNameFilledList = new ArrayList();
		while ( categoryIter.hasNext() ) {
			
			BugCategory bugCategory = (BugCategory)categoryIter.next();

			CategoryUtil categoryUtil = new CategoryUtil();
			categoryUtil.init();
			Integer[] category_list = categoryUtil.list_category(bugCategory.getValue());
			
			bugCategory.setCategoryNoArray(category_list);
			BugCategory categoryNameFilled = categoryService.getCategoryNameFilled(bugCategory);
			categoryNameFilledList.add(categoryNameFilled);
		}
		
		request.setAttribute("categoryNameFilledList", categoryNameFilledList);
		
		List bugStatusInfoList = (List) bugService.findBugStatusList(bugSearchParameter);
		
		request.setAttribute("bugStatusInfoList", bugStatusInfoList);	
		
		String toBeStatus = request.getParameter("toBeStatus") != null ? request.getParameter("toBeStatus") : "";
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService"));
		
		String projectNo = request.getParameter("projectNo") == null ? "0" : (String)request.getParameter("projectNo");

		ProjectRoleGroupSearchParameter projectRoleGroupSearchParameter = new ProjectRoleGroupSearchParameter();
		projectRoleGroupSearchParameter.setProjectNo(projectNo);
		
		if (toBeStatus.equals(BugStatus.inspecting)) {
			projectRoleGroupSearchParameter.setAccessRight(Integer.parseInt(RoleType.inspector));   // 검토
		} else if (toBeStatus.equals(BugStatus.accepted)) {
			projectRoleGroupSearchParameter.setAccessRight(Integer.parseInt(RoleType.assigner));   // 할당
		} else if (toBeStatus.equals(BugStatus.assigned)) {
			projectRoleGroupSearchParameter.setAccessRight(Integer.parseInt(RoleType.developer));   // 개발
		} else if (toBeStatus.equals(BugStatus.progressing)) {
			projectRoleGroupSearchParameter.setAccessRight(Integer.parseInt(RoleType.evaluator));   // 개발중
		} else if (toBeStatus.equals(BugStatus.evaluating)) {
			projectRoleGroupSearchParameter.setAccessRight(Integer.parseInt(RoleType.evaluator));   // 평가
		}
		
		List projectRoleGroupList = projectService.findProjectRoleGroupList(projectRoleGroupSearchParameter);
		request.setAttribute("projectRoleGroupList", projectRoleGroupList);
		
	}

	private void modify_bug(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {

		BugForm bugForm = (BugForm) form;
		
		Bug bug = new Bug();
		PropertyUtils.copyProperties(bug, bugForm);
		
		HttpSession session = request.getSession();
		
		String projectNo = bug.getProjectNo();
		
		Project project = new Project();
		project.setNo(projectNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		if (!rightService.haveRight("project", project, nowUserNo, Integer.parseInt(AccessType.write), remoteUserIpAddressBin)) {   // 프로젝트에 쓰기 권한이 있어야 버그 수정 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to add bug report to this project");
		}
		
		List<BugCategory> categoryList = new ArrayList<BugCategory>();
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		
		Iterator<CategoryScheme> categorySchemeIter = categorySchemeList.getList().iterator();
		
		while ( categorySchemeIter.hasNext() ) {
		
			BugCategory bugCategory = new BugCategory();
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			String schemeNo = categoryScheme.getNo();
			String categoryParameterName = "category_" + schemeNo;
			
			bugCategory.setSchemeNo(schemeNo);
			bugCategory.setValue(request.getParameter(categoryParameterName));
			
			categoryList.add(bugCategory);
		}
		
		User user = new User();
		user.setNo(nowUserNo);
		bug.setOwner(user);
		bug.setUserNo(nowUserNo);
		
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		
		BugSearchParameter bugSearchParameter = new BugSearchParameter();
		bugSearchParameter.setNo(bug.getNo());
		Bug bugBefore = bugService.findBugReporting(bugSearchParameter);
		String userNo = bugBefore.getUserNo();
		
		if (!userNo.equals(nowUserNo)) {
			throw new MyWorkNotAuthorizedException("user is not owner of this status.");
		}
		
		bugService.modifyBugReporting(bug, categoryList);
		
		request.setAttribute("alertMessage", "변경되었습니다.");
	
	}
	
	private void manage_bug(ActionMapping mapping,
							ActionForm form,
							HttpServletRequest request,
							HttpServletResponse response) throws Exception {

		String projectNo = request.getParameter("no");
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		
		request.setAttribute("categorySchemeList", categorySchemeList);
	}
	
	private void list_accessible_project(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		HttpSession session = request.getSession();

		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		List projectList = projectService.getAccessibleProjectListByUserNo(userInfo.getUser().getNo()); 
		
		request.setAttribute("projectList", projectList);
	
	}
	
	private void list_categories_of_project(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		String projectNo = request.getParameter("projectNo");
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
	
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);

		request.setAttribute("categorySchemeList", categorySchemeList);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		int leftCategoryIdx = 0;
		int rightCategoryIdx = 0;
		int topCategoryIdx = 0;
		
		while ( categorySchemeIter.hasNext() ) {
			
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			
			MyWorkList categoryList = categoryService.findCategoryInfoList(categoryScheme.getNo());
			
			if (categoryScheme.getShowLocation() == 1) {
				request.setAttribute("leftCategoryList" + leftCategoryIdx, categoryList);
				leftCategoryIdx ++;
			} else if (categoryScheme.getShowLocation() == 2) {
				request.setAttribute("topCategoryList" + topCategoryIdx, categoryList);
				topCategoryIdx ++;
			} else if (categoryScheme.getShowLocation() == 3) {
				request.setAttribute("rightCategoryList" + rightCategoryIdx, categoryList);
				rightCategoryIdx ++;
			} else {
				
			}
		}
	}
	
	private void move_bug(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		BugForm bugForm = (BugForm) form;
		
		Bug bug = new Bug();
		PropertyUtils.copyProperties(bug, bugForm);
		
		BugStatusInfo bugStatusInfo = new BugStatusInfo();
		bugStatusInfo.setBugNo(bug.getNo() + "");
		bugStatusInfo.setComments(bug.getComments());
		
		Project project = new Project();
		project.setNo(bug.getProjectNo());
		
		String toBeStatus = request.getParameter("toBeStatus") != null ? request.getParameter("toBeStatus") : "";
		String isForward = request.getParameter("isForward") != null ? request.getParameter("isForward") : "1";
		log.info("isForward:" + isForward);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		BugService bugService = (BugService)ServiceCallUtil.call(BugService.class, getServiceType("BugService"));
		
		String bugStatusNo = request.getParameter("bugStatusNo") != null ? request.getParameter("bugStatusNo") : "0";
		if (bugStatusNo.equals("0")) {
			throw new Exception("bugStatusNo is invalid");
		}
		
		int assignedCount = rightService.getAssignedCountWithInBugStatusOnProject(bugStatusNo, nowUserNo);
		if (assignedCount == 0) {
			throw new MyWorkNotAuthorizedException("this work is specifically assigned and you are not assigned to do this work for this bug report on this project");
		}
		
		if (isForward.equals("1") && toBeStatus.equals(BugStatus.inspecting)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.inspector), remoteUserIpAddressBin)) {   // 프로젝트에 검토 권한이 있어야 버그 리포팅 검토 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to inspect bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.inspecting);
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.inspecting)) {
			bugStatusInfo.setStatus(BugStatus.inspecting);	
		
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.accepted)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.inspector), remoteUserIpAddressBin)) {   // 프로젝트에 검토 권한이 있어야 버그 리포팅 검토 및 승인 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to accept bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.accepted);
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.accepted)) {
			bugStatusInfo.setStatus(BugStatus.accepted);
			
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.rejected)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.inspector), remoteUserIpAddressBin)) {   // 프로젝트에 검토 권한이 있어야 버그 리포팅 검토 및 반려 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to reject bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.rejected);
		
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.rejected)) {
			bugStatusInfo.setStatus(BugStatus.rejected);
			
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.assigned)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.assigner), remoteUserIpAddressBin)) {   // 프로젝트에 개발자 할당 권한이 있어야 버그 리포팅 개발 할당 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to assign bug report to developer on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.assigned);
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.assigned)) {
			bugStatusInfo.setStatus(BugStatus.assigned);
		
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.progressing)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.developer), remoteUserIpAddressBin)) {   // 프로젝트에 개발 권한이 있어야 버그 리포팅 반영 개발 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to develop programs from this bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.progressing);
		
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.progressing)) {
			bugStatusInfo.setStatus(BugStatus.progressing);
		
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.evaluating)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.evaluator), remoteUserIpAddressBin)) {   // 프로젝트에 평가 권한이 있어야 버그 리포팅 반영 프로그램 평가 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to evaluate programs from this bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.evaluating);
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.evaluating)) {
			bugStatusInfo.setStatus(BugStatus.evaluating);
		
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.waitingAck)) {
			
			if (!rightService.haveRole("project", project, nowUserNo, Integer.parseInt(RoleType.evaluator), remoteUserIpAddressBin)) {   // 프로젝트에 평가 권한이 있어야 버그 리포팅 반영 프로그램 평가 및 평가 완료 가능
				throw new MyWorkNotAuthorizedException("user doesn't have right to evaluate programs from this bug report on this project");
			}
			
			bugStatusInfo.setStatus(BugStatus.waitingAck);
			
		} else if (isForward.equals("0") && toBeStatus.equals(BugStatus.waitingAck)) {
			bugStatusInfo.setStatus(BugStatus.waitingAck);
			
		} else if (isForward.equals("1") && toBeStatus.equals(BugStatus.completed)) {
			
			//Todo 버그 소유자 인지 확인
			
			bugStatusInfo.setStatus(BugStatus.completed);
			
		}
		
		if (isForward.equals("1") && !toBeStatus.equals(BugStatus.inspecting) && !toBeStatus.equals(BugStatus.progressing)) {
			
			String devListJoined = request.getParameter("devList") != null ? request.getParameter("devList") : "";
			
			if (devListJoined.length() > 0) {
				String devs[] = devListJoined.split("@delimiter@");
				
				for (int i = 0 ; i < devs.length ; i++) {
					BugAssigneeInfo bugAssigneeInfo = new BugAssigneeInfo();
					bugAssigneeInfo.setAssignee(devs[i]);
					
					if (devs[i].substring(0, 4).equals("USER")) {
						bugAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.USER));
					} else if (devs[i].substring(0, 4).equals("USGR")) {
						bugAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.USERGROUP));
					} else if (devs[i].substring(0, 4).equals("ACGR")) {
						bugAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.ACCESSGROUP));
					} else {
						throw new Exception("assignee no invalid");
					}
		
					bugStatusInfo.addBugAssigneeInfo(bugAssigneeInfo);
		
				}
			}

		} else if (isForward.equals("1")) {
			BugAssigneeInfo bugAssigneeInfo = new BugAssigneeInfo();
			bugAssigneeInfo.setAssignee(nowUserNo);
			bugAssigneeInfo.setAssigneeType(Integer.parseInt(UserType.USER));

			bugStatusInfo.addBugAssigneeInfo(bugAssigneeInfo);
		} else if (isForward.equals("0")) {
			String beforeBugStatusNo = bugService.findLastBugStatusNoBeforeWithSameStatus(bugStatusNo, bugStatusInfo.getStatus());
			List beforeBugAssigneeList = bugService.findBugAssigneeList(beforeBugStatusNo);
			for (int i = 0 ; i < beforeBugAssigneeList.size() ; i++ ) {
				log.info("beforeBugAssigneeList:" + beforeBugAssigneeList.get(i).toString());
			}
			
			bugStatusInfo.setBugAssigneeInfoList(beforeBugAssigneeList);
		}
		
		bugStatusInfo.setUserNo(nowUserNo);
		
		
		bugService.moveBugStatus(bugStatusInfo);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	}
}
