package kr.co.leaderway.CustomTag.Paging;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class PageTag extends BodyTagSupport {
	public int doAfterBody() throws JspTagException	{
		int page = 0;
		PagingTag parent = (PagingTag) findAncestorWithClass( this, PagingTag.class );
		
		if ( parent == null )	{
			throw new JspTagException( "부모 태그(PagingTag.class)가 없습니다." );
		}
		
		page = Integer.parseInt( getBodyContent().getString().trim() );
		parent.setPage( page );
		
		return SKIP_BODY;
	}
}
