<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.user.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="kr.co.leaderway.util.*" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>
<%

MyWorkList userList = (MyWorkList) request.getAttribute("userList");

String currentURL = UrlTool.getCurrentURL(request);
int totalRows = userList.getTotalRows();
int pageNum = userList.getPageNum();

int selectedPage = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
int perPage = request.getParameter("per_page") != null ? Integer.parseInt(request.getParameter("per_page")) : 10;

if (pageNum < selectedPage) {
	selectedPage = pageNum;
}

String userId_selected = request.getParameter("userId") !=null ? request.getParameter("userId") : "";
String userName_selected = request.getParameter("name") != null ? request.getParameter("name") : "";
String userEmail_selected = request.getParameter("email") != null ? request.getParameter("email") : "";
userName_selected = new String(userName_selected.getBytes("8859_1"),"UTF-8");

String callerIdentifier = request.getParameter("callerIdentifier") != null ? request.getParameter("callerIdentifier") : "1";
String isMultiSelect = request.getParameter("isMultiSelect") != null ? request.getParameter("isMultiSelect") : "0";
%>

<script language="JavaScript">
function userList() {
	now_url = changeUrlArgument(current_url, "per_page", f.per_page.value);
    now_url = changeUrlArgument(now_url, "userId", f.userId.value);
	now_url = changeUrlArgument(now_url, "name", f.name.value);
	now_url = changeUrlArgument(now_url, "email", f.email.value);

	location.href  = now_url;
}

function returnSelectedUser() {
	for (var i = 0 ; i < selectedUserArrays.length; i++) {
		opener.setSelectedUser(<%=callerIdentifier%>, selectedUserArrays[i] );
	}

	if ('<%=isMultiSelect%>' == '1') {
		selectedUserArrays = [];
		clear_listTable_bgcolor();
		// close 안함
	} else {
		window.close();
	}
}

var selectedUserArrays = new Array();

function toggleSelect(numTable, userNo, userId, userName, userEmail) {

	userArray = [ userNo, userId, userName, userEmail];
	
	if (<%=isMultiSelect%> == 1) {
		var indexInArray = findMeIn(selectedUserArrays, userNo);
	
		if (indexInArray == 0) {
			selectedUserArrays.push(userArray);
			changeBgColorSelected(numTable);
		} else {
	
			selectedUserArrays.splice(indexInArray - 1, 1);
			changeBgColorClearSelected(numTable);
		}
	} else {
		clear_listTable_bgcolor();
		selectedUserArrays.splice(0, selectedUserArrays.length, userArray);
		changeBgColorSelected(numTable);
	}
	
}

function findMeIn(arrayObject, chekValue) {
	for (var i = 0 ;  i < arrayObject.length ; i++) {
		if (arrayObject[i][0] == chekValue) {
			return i + 1;
		}
	}
	return 0;
}

function clear_listTable_bgcolor() {
    var x=document.getElementById('listTable').rows;
    var x_rows_num=x.length;

    var y_column_num=3;
    x_count = 1;
    while ( x_count < x_rows_num ) {
            y_count = 0;
            while (y_count < y_column_num) {
                    x[x_count].cells[y_count].style.backgroundColor = "#FFFFFF";
                    y_count = y_count + 1;
            }
    	x_count = x_count + 1;
    }
}

function changeBgColorClearSelected(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;
 
    y[0].style.backgroundColor = "#FFFFFF";
    y[1].style.backgroundColor = "#FFFFFF";
    y[2].style.backgroundColor = "#FFFFFF";
   
    
}

function changeBgColorSelected(content_serial) {

    var x=document.getElementById('listTable').rows;
    var y=x[content_serial].cells;

    y[0].style.backgroundColor = "#CCCCCC";
    y[1].style.backgroundColor = "#CCCCCC";
    y[2].style.backgroundColor = "#CCCCCC";
   
    
}
</script>

<form name="f" method="post">
	  
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
    		<td width="100%" align="right" height="22">페이지당 목록갯수
				<select id="per_page" name="per_page" onchange="userList()"></select>
				&nbsp;&nbsp; 총 목록갯수 : <%=totalRows %> &nbsp;&nbsp;  페이지 수: <%=pageNum %>
			</td>
	  	</tr>
	</table>
  	<!-- list -->
  	<table id="listTable" name="listTable" border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB">
	  	<tr>
			<td width=190 align="center" bgcolor="#E6ECDE" height="22">사용자 아이디</td>
			<td width=200 align="center" bgcolor="#E6ECDE">이름</td>
			<td width=200 align="center" bgcolor="#E6ECDE">이메일</td>
	  	</tr>
<%
	Iterator userIter = userList.getList().iterator();
	int numTable = 0;
	while ( userIter.hasNext() ) { 
		numTable ++;
		User user = (User)userIter.next(); 
%>		  	
	  	<tr onClick="toggleSelect(<%=numTable%>, '<%= user.getNo() %>', '<%= user.getUserId() %>' , '<%= user.getName() %>', '<%= user.getEmail() %>')">
			<td width="20%" align="center" bgcolor="#FFFFFF" height="20">
				<%= user.getUserId() %>
			</td>
			<td  bgcolor="#FFFFFF" style="padding-left:10">
				<%= user.getName() %>
			</td>
			<td width="200" align="center" bgcolor="#FFFFFF">
				<%= user.getEmail() %>
			</td>
	  	</tr>
<%
	}
%>		  	
  	</table>
  	<!-- /list -->	 

	<table width="100%" cellspacing="0" bgcolor="#F4F4F4" border="0" cellpadding="1">
	  <tr>
	  	<td align="left" valign="middle" class="search_form">
		  	<page:paging>
		  		<page:pg><%=selectedPage %></page:pg>
		  		<page:pgLimit>10</page:pgLimit>
		  		<page:totalRows><%=totalRows %></page:totalRows>
		  		<page:rowsLimit><%=perPage %></page:rowsLimit>
		  		<page:urlString><%=currentURL %></page:urlString>
		  		<page:pageArgument>page</page:pageArgument>
		  	</page:paging>
		</td>
	
	    <td align="right" valign="middle" class="search_form">
	    	ID
	      <input type="text" name="userId" size="20" maxlength="60" value="<%=userId_selected%>" class="input_box">
	      	이름
	      <input type="text" name="name" size="20" maxlength="60" value="<%=userName_selected%>" class="input_box">
	      	Email
	      <input type="text" name="email" size="20" maxlength="60" value="<%=userEmail_selected%>" class="input_box">
	    </td>
	    <td align="left" valign="middle" onClick="userList()">
	    	검색
	    </td>
	  </tr>
	</table>
	
	<br>
	<!-- button -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%">
		<tr>
<%
if (isMultiSelect.equals("1")) {
%>
			<td align="right">
				<input type="button" value="추가" onClick="returnSelectedUser()" class="title_button" />
			</td>
			<td align="right">
				<input type="button" value="닫기" onClick="window.close()" class="title_button" />
			</td>
<%
} else {
%>
			<td align="right">
				<input type="button" value="선택" onClick="returnSelectedUser()" class="title_button" />
			</td>
<%		
}
%>
		</tr>
	</table>
</form>

<script language="JavaScript">
	
	var select_id = 'per_page';
	var list_name = 'per_page';
	var url = 'OptionActionAjax.do';
	var add_total = false;
	var selected_value = '<%=perPage%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
	
</script>