<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.user.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="kr.co.leaderway.util.*" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>
<%
MyWorkList userGroupList = (MyWorkList) request.getAttribute("userGroupList");

String currentURL = UrlTool.getCurrentURL(request);
int totalRows = userGroupList.getTotalRows();
int pageNum = userGroupList.getPageNum();


int selectedPage = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
int perPage = request.getParameter("per_page") != null ? Integer.parseInt(request.getParameter("per_page")) : 10;

if (pageNum < selectedPage) {
	selectedPage = pageNum;
}

%>

<script language="JavaScript">
function userGroupList() {
	now_url = changeUrlArgument(current_url, "per_page", f.per_page.value);

	location.href  = now_url;
}

function userGroupCreate() {
	f.action = "UserGroupAction.do?mode=add_user_group_form";
	f.submit();
}
</script>

<form name="f" method="post">
	  
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
    		<td width="100%" align="right" height="22">페이지당 목록갯수
				<select id="per_page" name="per_page" onchange="userGroupList()"></select>
				&nbsp;&nbsp; 총 목록갯수 : <%=totalRows %> &nbsp;&nbsp;  페이지 수: <%=pageNum %>
			</td>
	  	</tr>
	</table>
  	<!-- list -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB">
	  	<tr>
			<td width=190 align="center" bgcolor="#E6ECDE" height="22">그룹명</td>
			<td align="center" bgcolor="#E6ECDE" height="22">설명</td>
	  	</tr>
<%
if (userGroupList != null) {
	
	Iterator userGroupIter = userGroupList.getList().iterator();
	
	while ( userGroupIter.hasNext() ) {
		UserGroup userGroup = (UserGroup)userGroupIter.next();
		String depthString = "";
		for (int i = 0 ; i < userGroup.getLevel() - 1 ; i++ ) {
			depthString += "&nbsp;&nbsp;";
		}
%>		  	
	  	<tr>
			<td  bgcolor="#FFFFFF" style="padding-left:10">
				<a href="UserGroupAction.do?mode=view_user_group&no=<%= userGroup.getNo() %>" class="user">
					<%=depthString + userGroup.getUserGroupName() %>
				</a>
			</td>
			<td  bgcolor="#FFFFFF" style="padding-left:10">
				<a href="UserGroupAction.do?mode=view_user_group&no=<%= userGroup.getNo() %>" class="user">
					<%= userGroup.getDescription() %>
				</a>
			</td>
	  	</tr>
<%
	}
}
%>		  	
  	</table>
  	<!-- /list -->	 

	<table width="100%" cellspacing="0" bgcolor="#F4F4F4" border="0" cellpadding="1">
	  <tr>
	  	<td align="left" valign="middle" class="search_form">
		  	<page:paging>
		  		<page:pg><%=selectedPage %></page:pg>
		  		<page:pgLimit>10</page:pgLimit>
		  		<page:totalRows><%=totalRows %></page:totalRows>
		  		<page:rowsLimit><%=perPage %></page:rowsLimit>
		  		<page:urlString><%=currentURL %></page:urlString>
		  		<page:pageArgument>page</page:pageArgument>
		  	</page:paging>
		</td>
	  </tr>
	</table>
	
	<br>
	<!-- button -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%">
		<tr>
			<td align="right">
				<input type="button" value="사용자 그룹 추가" onClick="userGroupCreate()" class="title_button" />
			</td>
		</tr>
	</table>		
</form>

<script language="JavaScript">
	
	var select_id = 'per_page';
	var list_name = 'per_page';
	var url = 'OptionActionAjax.do';
	var add_total = false;
	var selected_value = '<%=perPage%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
	
</script>