<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="kr.co.leaderway.mywork.network.model.*" %>
<%@ page import="kr.co.leaderway.mywork.common.model.*" %>
<%@ page import="org.apache.commons.logging.Log" %>
<%@ page import="org.apache.commons.logging.LogFactory" %>
<%@ page import="kr.co.leaderway.util.*" %>

<%@ taglib uri="/WEB-INF/tlds/Paging.tld" prefix="page" %>

<%

MyWorkList networkList = (MyWorkList) request.getAttribute("networkList");

String currentURL = UrlTool.getCurrentURL(request);
int totalRows = networkList.getTotalRows();
int pageNum = networkList.getPageNum();

int selectedPage = request.getParameter("page") != null ? Integer.parseInt(request.getParameter("page")) : 1;
int perPage = request.getParameter("per_page") != null ? Integer.parseInt(request.getParameter("per_page")) : 10;

if (pageNum < selectedPage) {
	selectedPage = pageNum;
}

String time = request.getParameter("time") !=null ? request.getParameter("time") : "";
String category = request.getParameter("category") != null ? request.getParameter("category") : "";
String search = request.getParameter("search") != null ? request.getParameter("search") : "";
String search_string = request.getParameter("search_string")  != null ? request.getParameter("search_string") : "";
search_string = new String(search_string.getBytes("8859_1"),"UTF-8");

String title_selected = "";
String contents_selected = "";
String writer_selected = "";
String titlecontent_selected = "";
if (search.equals("title")) {
    title_selected = "selected";
} else if (search.equals("contents")) {
    contents_selected = "selected";
} else if (search.equals("writer")) {
    writer_selected = "selected";
} else if (search.equals("title-content")) {
    titlecontent_selected = "selected";
}

String week_selected = "";
String month_selected = "";
String year_selected = "";
String all_selected = "";
if (time.equals("week")) {
    week_selected = "selected";
} else if (time.equals("month")) {
    month_selected = "selected";
} else if (time.equals("year")) {
    year_selected = "selected";
} else if (time.equals("all")) {
    all_selected = "selected";
} else {
	all_selected = "selected";
}
%>

<script language="JavaScript">

function networkList() {

	now_url = changeUrlArgument(current_url, "per_page", f.per_page.value);

    search_string = f.search_string.value.trim();
 
    if (search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "search", f.target.value);
    	now_url = changeUrlArgument(now_url, "search_string", encodeURI(search_string));
    } else {
    	now_url = changeUrlArgument(now_url, "search", "");
    	now_url = changeUrlArgument(now_url, "search_string", "");
    }
    
    if (f.time_span.value == "all" || !search_string.length > 0) {
    	now_url = changeUrlArgument(now_url, "time", "");
    } else {
    	now_url = changeUrlArgument(now_url, "time", f.time_span.value);
    }
    
	location.href  = now_url;

}

function networkAdd() {
	f.action = "NetworkAction.do?mode=add_network_form";
	f.submit();
}

function networkView(no) {
	
	f.action = "NetworkAction.do?mode=view_network&no=" + no;
	f.submit();
}

function networkModify(no) {

	now_url = changeUrlArgument(current_url, "mode", "modify_network_form");
	now_url = changeUrlArgument(now_url, "no", no);
	
	location.href  = now_url;
}

function networkRemove(no) {
	if ( confirm("정말 삭제하시겠습니까?") ) {
		f.action = "NetworkAction.do?mode=delete_network&no=" + no;
		f.submit();
	}
}
</script>

<form name="f" method="post">
		  
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
    	<tr>
			<td width="100%" align="right" height="22">페이지당 목록갯수
				<select id="per_page" name="per_page" onchange="networkList()"></select>
				&nbsp;&nbsp; 총 목록갯수 : <%=totalRows %> &nbsp;&nbsp;  페이지 수: <%=pageNum %>
			</td>
	  	</tr>
	</table>
  	<!-- list -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%" bgcolor="#BBBBBB" class="list_table">
	  	<tr>
			<td width=300 align="center" bgcolor="#E6ECDE" height="22">네크워크 명</td>
			<td width=500 align="center" bgcolor="#E6ECDE">설명</td>
	  	</tr>
		  	
<%
	Iterator networkIter = networkList.getList().iterator();
			
	while ( networkIter.hasNext() ) {
		Network network = (Network)networkIter.next();
%>		
			
	  	<tr>
	  		
			<td align="center" bgcolor="#FFFFFF" height="20" onClick="networkView('<%= network.getNo() %>')">
				<%= network.getNetworkName() %>
			</td>
			<td  bgcolor="#FFFFFF" style="padding-left:10" onClick="networkView('<%= network.getNo() %>')">
				<%= network.getDescription() %>
			</td>
			
	  	</tr>
		
<%
	}
%>		  	
			
  	</table>
  	<!-- /list -->	 
	<table width="100%" cellspacing="0" bgcolor="#F4F4F4" border="0" cellpadding="1">
	  <tr>
	  	<td align="left" valign="middle" class="search_form">
		  	<page:paging>
		  		<page:pg><%=selectedPage %></page:pg>
		  		<page:pgLimit>10</page:pgLimit>
		  		<page:totalRows><%=totalRows %></page:totalRows>
		  		<page:rowsLimit><%=perPage %></page:rowsLimit>
		  		<page:urlString><%=currentURL %></page:urlString>
		  		<page:pageArgument>page</page:pageArgument>
		  	</page:paging>
		</td>
	
	    <td align="right" valign="middle" class="search_form">
	     <!-- target -->
	      <select name="target">
	      <option value="title" <%=title_selected%>>제목</option>
	      <option value="contents" <%=contents_selected%>>내용</option>
	      <option value="writer" <%=writer_selected%>>글쓴이</option>
	      <option value="title-content" <%=titlecontent_selected%>>제목,내용</option>
	      </select>
	
	  	<!-- time_span -->
	      <select name="time_span">
	      <option value="week" <%=week_selected%>>한주</option>
	      <option value="month" <%=month_selected%>>한달</option>
	      <option value="year" <%=year_selected%>>1년</option>
	      <option value="all" <%=all_selected%>>전체</option>
	      </select>
	
	  	<!-- search_string -->
	      <input type="text" name="search_string"
	       size="20" maxlength="60" value="<%=search_string%>">
	    </td>
	    <td align="left" valign="middle" onClick="bugList()">
	    	검색
	    </td>
	  </tr>
	</table>
	
	<br>
	<!-- button -->
  	<table border="0" cellpadding="0" cellspacing="1" width="100%">
		<tr align="right">
			<td align="right">
				<input type="button" value="네크워크 추가" onClick="networkAdd()" class="title_button" />
			</td>
		</tr>
	</table>		
</form>

<script language="JavaScript">
	
	var select_id = 'per_page';
	var list_name = 'per_page';
	var url = 'OptionActionAjax.do';
	var add_total = false;
	var selected_value = '<%=perPage%>';
	
	get_select_list(select_id, list_name, url, add_total, selected_value);
	
</script>