package kr.co.leaderway.mywork.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.struts.util.MessageResources;

import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.statics.NameAndValue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeTool {

	private Log log = LogFactory.getLog(this.getClass());
	private MessageResources messageResources;
	
	public TypeTool(MessageResources messageResources) {
		this.messageResources = messageResources;
	}
	
	public List<NameAndValue> getList(Class typeClass) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
	     
	    Field typeField = typeClass.getDeclaredField("types");
	      
		String[][] types =  (String[][])typeField.get(typeClass);
		
		List<NameAndValue> typeList = new ArrayList<NameAndValue>();
		
		for (int i = 0 ; i < types.length ; i++) {
			NameAndValue nameAndValue = new NameAndValue();
			nameAndValue.setName(types[i][0]);
			nameAndValue.setValue(types[i][1]);
			typeList.add(nameAndValue);
		}
		
		return typeList; 
	}
	
	public List<NameAndValue> getMessageNameList(Class typeClass) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
		
		String nowClassShortName = typeClass.getSimpleName();
	     
	    Field typeField = typeClass.getDeclaredField("types");
	      
		String[][] types =  (String[][])typeField.get(typeClass);
		
		List<NameAndValue> typeList = new ArrayList<NameAndValue>();
		
		Locale locale = Locale.getDefault();
		
		for (int i = 0 ; i < types.length ; i++) {
			NameAndValue nameAndValue = new NameAndValue();
			String keyString = nowClassShortName + "." + (String)types[i][0];
			String typeName = messageResources.getMessage(locale, keyString);

			nameAndValue.setName(typeName);
			nameAndValue.setValue(types[i][1]);
			typeList.add(nameAndValue);
		}
		
		return typeList; 
	}
	
	public List<Option> getMessageNameListForOption(Class typeClass) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
		
		String nowClassShortName = typeClass.getSimpleName();
	     
	    Field typeField = typeClass.getDeclaredField("types");
	      
		String[][] types =  (String[][])typeField.get(typeClass);
		
		List<Option> typeList = new ArrayList<Option>();
		
		Locale locale = Locale.getDefault();
		
		for (int i = 0 ; i < types.length ; i++) {
			Option option = new Option();
			String keyString = nowClassShortName + "." + (String)types[i][0];
			String typeName = messageResources.getMessage(locale, keyString);

			option.setName(typeName);
			option.setValue(types[i][1]);
			typeList.add(option);
		}
		
		return typeList; 
	}

	public String getMessageNameFromTypeName(Class typeClass, String typeName) {
		
		String nowClassShortName = typeClass.getSimpleName();
		
		Locale locale = Locale.getDefault();
		
		String keyString = nowClassShortName + "." + typeName;
		String messageName = messageResources.getMessage(locale, keyString);

		return messageName;
	}
	
	public String getMessageNameFromValue(Class typeClass, String value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
		
		String nowClassShortName = typeClass.getSimpleName();
	     
	    Field typeField = typeClass.getDeclaredField("types");
	      
		String[][] types =  (String[][])typeField.get(typeClass);
		
		List<NameAndValue> typeList = new ArrayList<NameAndValue>();
		
		Locale locale = Locale.getDefault();
		
		for (int i = 0 ; i < types.length ; i++) {
			if (types[i][1].equals(value)) {
				String keyString = nowClassShortName + "." + (String)types[i][0];
				String messageName = messageResources.getMessage(locale, keyString);
				
				return messageName;
			}
		}
		
		return "";
	}
}
