package kr.co.leaderway.mywork.test.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.category.form.CategoryInfoForm;
import kr.co.leaderway.mywork.category.model.CategoryInfo;
import kr.co.leaderway.mywork.category.model.CategoryScheme;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.statics.NameAndValue;
import kr.co.leaderway.mywork.statics.SystemType;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.mywork.util.TypeTool;
import kr.co.leaderway.util.StringTool;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.util.MessageResources;

public class TestAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String mode = request.getParameter("mode") != null ? request	.getParameter("mode") : "";

		if (mode.equals("show_tree")) {

			HttpSession session = request.getSession();
			UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
			
			String sessionUserId = "";
			if (userInfo == null) {
				log.info("not logged in");
				sessionUserId = "notlogin";
			} else {
				sessionUserId = userInfo.getUser().getUserId();
			}
			
			request.setAttribute("userId", sessionUserId);
			
			//String schemeNo_string = request.getParameter("schemeNo");
			//int schemeNo = Integer.parseInt(schemeNo_string);
			String schemeNo = "CSNO200903180000000004";
			log.info("schemeNo:" + schemeNo);

			CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
			CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
			
			request.setAttribute("categoryScheme", categoryScheme);
			
			MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
			
			MessageResources messageResources = getResources(request);


			TypeTool typeTool = new TypeTool(messageResources);
			
			List systemTypeList = typeTool.getMessageNameList(SystemType.class);
			
			for (int i = 0; i < systemTypeList.size(); i++) {
				
				NameAndValue nameAndValue = (NameAndValue)systemTypeList.get(i);
				log.info("nameAndValue:" + nameAndValue.getName() + ":" + nameAndValue.getValue());
			}
			
			request.setAttribute("systemTypeList", systemTypeList);
			request.setAttribute("categoryInfoList", categoryInfoList);
			
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 정보보기");	
			return mapping.findForward("test_tree_show");
			
		} else if (mode.equals("show_cookie")) {

			show_cookie(mapping, form, request, response);
			String schemeNo = "CSNO200903180000000004";
			log.info("schemeNo:" + schemeNo);

			CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
			CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
			
			request.setAttribute("categoryScheme", categoryScheme);
			
			MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
			
			request.setAttribute("categoryInfoList", categoryInfoList);
			
			return mapping.findForward("test_tree_show");
			
		} else if (mode.equals("add_cookie")) {

			add_cookie(mapping, form, request, response);
			String schemeNo = "CSNO200903180000000004";
			log.info("schemeNo:" + schemeNo);

			CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
			CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
			
			request.setAttribute("categoryScheme", categoryScheme);
			
			MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
			
			request.setAttribute("categoryInfoList", categoryInfoList);
			
			return mapping.findForward("test_tree_show");
		
		} else if (mode.equals("add_cookie_item")) {
			
			String cookieName = "listCookie";
			String cookieValue = new Date().toString();
			add_item_to_cookie(request, response, cookieName, cookieValue);
			String schemeNo = "CSNO200903180000000004";
			log.info("schemeNo:" + schemeNo);

			CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
			CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
			
			request.setAttribute("categoryScheme", categoryScheme);
			
			MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
			
			request.setAttribute("categoryInfoList", categoryInfoList);
			
			return mapping.findForward("test_tree_show");
			
		} else if (mode.equals("delete_cookie_item")) {
			
			String cookieName = "listCookie";
			
			Cookie dd = get_cookie(request, response, cookieName);
			String ff= (String)dd.getValue();
		
			String[] ee = ff.split("@delimiter@");
			String cookieValue = ee[2];
		
			remove_item_from_cookie(request, response, cookieName, cookieValue);
		
			String schemeNo = "CSNO200903180000000004";

			CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
			CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
			
			request.setAttribute("categoryScheme", categoryScheme);
			
			MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
			
			request.setAttribute("categoryInfoList", categoryInfoList);
			
			return mapping.findForward("test_tree_show");
			
			
		} else if (mode.equals("modify_category_form")) {
			
			view_category_scheme(mapping, form, request, response);
			
			return mapping.findForward("category_modify_form");
			
		} else if (mode.equals("modify_category_info_form")) {
			
			view_category_scheme(mapping, form, request, response);
			
			return mapping.findForward("category_info_modify_form");
			
			
		} else if (mode.equals("modify_category_info")) {

			modify_category(mapping, form, request, response);

			CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
			String categorySchemeNo = categoryInfoForm.getCategorySchemeNo();
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("schemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("delete_category_info")) {
			
			delete_category(mapping, form, request, response);
			
			String categorySchemeNo_string = request.getParameter("categorySchemeNo") != null ? request	.getParameter("categorySchemeNo") : "";
			int categorySchemeNo = Integer.parseInt(categorySchemeNo_string);
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("schemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("lower_category_info")) {
			
			lower_category(mapping, form, request, response);
			
			String categorySchemeNo_string = request.getParameter("categorySchemeNo") != null ? request	.getParameter("categorySchemeNo") : "";
			int categorySchemeNo = Integer.parseInt(categorySchemeNo_string);
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("schemeNo", categorySchemeNo);
			return redirect;
			
		} else { // list_category_scheme

			//list_category_scheme(mapping, form, request, response);

			return mapping.findForward("category_scheme_list");

		}
	}

	private void show_cookie(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		Cookie[] cookies_read = request.getCookies();

		if(cookies_read != null){
			 log.info("cookies_total_length:" + cookies_read.length);
			 for(int i=0; i<cookies_read.length; i++){
				 
					 log.info("name:" + cookies_read[i].getName() + "--" + cookies_read[i].getValue());
					 
				
			}
		}

	}
	
	private Cookie get_cookie(HttpServletRequest request, HttpServletResponse response, String cookieName)
			throws Exception {

		Cookie[] cookies_read = request.getCookies();

		if(cookies_read != null){
			 log.info("cookies_total_length:" + cookies_read.length);
			 for(int i=0; i<cookies_read.length; i++){
				 if (cookies_read[i].getName().length() == cookieName.length()) {
				 if (cookies_read[i].getName().substring(0,cookieName.length()).equals(cookieName)) {
					 //count++;
					 return cookies_read[i];
					 
				 }
				 }
			}
		}
		return null;
	}
	
	private void add_item_to_cookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue)
			throws Exception {

		Cookie cookie = get_cookie(request, response, cookieName) != null ? get_cookie(request, response, cookieName) : new Cookie(cookieName, "");
		
		String currentCookieValue = cookie.getValue();
		
		String[] currentCookieValueArray = null;
		int qq = 0;
		if (currentCookieValue.equals("")) {
			currentCookieValueArray = null;
		
		} else {
			currentCookieValueArray = currentCookieValue.split("@delimiter@");
			qq = currentCookieValueArray.length;
		}
		
		int max_num = 10;
		int start_num = qq - max_num >= 0 ? qq - max_num + 1: 0 ;
	
		int dd = qq - start_num + 1;
		
		String[] ss = new String[dd];
		
		for (int i = 0; i < qq - start_num; i++) {
			ss[i] = currentCookieValueArray[i + start_num];
		}
		
		ss[dd - 1] = cookieValue;
	
		String aa = StringTool.mergeTokens(ss,"@delimiter@");
		
		cookie.setValue(aa);
		
		cookie.setMaxAge(360000000); 
		log.info("zmax:" + cookie.getMaxAge());
		cookie.setPath("/");
		response.addCookie(cookie);
		

	}
	
	private void remove_item_from_cookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue)
		throws Exception {
	
	
		Cookie cookie = get_cookie(request, response, cookieName) != null ? get_cookie(request, response, cookieName) : new Cookie(cookieName, "");
		
		String currentCookieValue = cookie.getValue();
		
		String[] currentCookieValueArray = null;
		if (currentCookieValue.equals("")) {
			currentCookieValueArray = new String[0];
		} else {
			
			currentCookieValueArray = currentCookieValue.split("@delimiter@");
		}
	
		int qq = currentCookieValueArray.length;
	
		
		List bb = new ArrayList();
		
		for (int i = 0 ; i < qq; i++) {
			
			if (currentCookieValueArray[i].equals(cookieValue)) {	
				
			} else {
				bb.add(currentCookieValueArray[i]);
			}
		}
	
		
		String[] ss = (String[])bb.toArray(new String[0]);
	 
		for (int i = 0; i < ss.length ; i++) {
			log.info("ss[" + i + "]:" + ss[i]);
		}
		String aa = StringTool.mergeTokens(ss,"@delimiter@");
		log.info("ssssssc");
		cookie.setValue(aa);
		cookie.setMaxAge(60*60*24*1); 
		cookie.setPath("/MyWork");
		response.addCookie(cookie);
	
	
	}
	
	private void add_cookie(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		
		Cookie[] cookies_read = request.getCookies();

		int count = 0;
		if(cookies_read != null){
			  
			 for(int i=0; i<cookies_read.length; i++){
				 if (cookies_read[i].getName().length() > 6) {
				 if (cookies_read[i].getName().substring(0,7).equals("asasas_")) {
					 count++;
				 }
				 }
			 
			}
		}
		int add_idx = 0;
		if (count >= 10) {
			add_idx = 10;
			shiftCookie(request, response);
		} else {
			add_idx = count + 1;
		}
		
		String ss = new Date().toString();
		
		Cookie cookie = new Cookie("asasas_" + add_idx, ss);
		cookie.setMaxAge(60*60*24*1); 
		cookie.setPath("/");
		response.addCookie(cookie);

	}
	
	private void shiftCookie(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		Cookie cookie1 = get_cookie(request, response, "asasas_1");
		cookie1.setValue(getCookieValue(request, response, "asasas_2"));
		cookie1.setMaxAge(60*60*24*1); 
		cookie1.setPath("/");
		response.addCookie(cookie1);
		
		Cookie cookie2 = get_cookie(request, response, "asasas_2");
		cookie2.setValue(getCookieValue(request, response, "asasas_3"));
		cookie2.setMaxAge(60*60*24*1); 
		cookie2.setPath("/");
		response.addCookie(cookie2);
		
		Cookie cookie3 = get_cookie(request, response, "asasas_3");
		cookie3.setValue(getCookieValue(request, response, "asasas_4"));
		cookie3.setMaxAge(60*60*24*1); 
		cookie3.setPath("/");
		response.addCookie(cookie3);
		
		Cookie cookie4 = get_cookie(request, response, "asasas_4");
		cookie4.setValue(getCookieValue(request, response, "asasas_5"));
		cookie4.setMaxAge(60*60*24*1); 
		cookie4.setPath("/");
		response.addCookie(cookie4);
		
		Cookie cookie5 = get_cookie(request, response, "asasas_5");
		cookie5.setValue(getCookieValue(request, response, "asasas_6"));
		cookie5.setMaxAge(60*60*24*1); 
		cookie5.setPath("/");
		response.addCookie(cookie5);
		
		Cookie cookie6 = get_cookie(request, response, "asasas_6");
		cookie6.setValue(getCookieValue(request, response, "asasas_7"));
		cookie6.setMaxAge(60*60*24*1); 
		cookie6.setPath("/");
		response.addCookie(cookie6);
		
		Cookie cookie7 = get_cookie(request, response, "asasas_7");
		cookie7.setValue(getCookieValue(request, response, "asasas_8"));
		cookie7.setMaxAge(60*60*24*1); 
		cookie7.setPath("/");
		response.addCookie(cookie7);
		
		Cookie cookie8 = get_cookie(request, response, "asasas_8");
		cookie8.setValue(getCookieValue(request, response, "asasas_9"));
		cookie8.setMaxAge(60*60*24*1); 
		cookie8.setPath("/");
		response.addCookie(cookie8);
		
		Cookie cookie9 = get_cookie(request, response, "asasas_9");
		cookie9.setValue(getCookieValue(request, response, "asasas_10"));
		cookie9.setMaxAge(60*60*24*1); 
		cookie9.setPath("/");
		response.addCookie(cookie9);
	
		
	}
	
	private String getCookieValue(HttpServletRequest request, HttpServletResponse response, String cookieName) {
		Cookie[] cookies_read = request.getCookies();

		int count = 0;
		String returnValue = "";
		if(cookies_read != null){
			
			 for(int i=0; i<cookies_read.length; i++){
				
				int s = cookieName.length();
				if (cookies_read[i].getName().length() == s) { 
					if (cookies_read[i].getName().substring(0,s).equals(cookieName)) {
						
						log.info("cookie_name:" + cookies_read[i].getName());
						log.info("cookie_value:" + cookies_read[i].getValue());
						returnValue = cookies_read[i].getValue();
					
					}
				}
			 
			}
		}
		return returnValue;
	}
	
	private void modify_category(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
		
		CategoryInfo categoryInfo = new CategoryInfo();
		PropertyUtils.copyProperties(categoryInfo, categoryInfoForm);
	
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.modifyCategoryInfo(categoryInfo);

		request.setAttribute("alertMessage", "수정되었습니다.");

	}
	
	private void add_sub_category(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String parentCategoryInfoNo_string = request.getParameter("parentCategoryInfoNo") != null ? request	.getParameter("parentCategoryInfoNo") : "";
		int parentCategoryInfoNo = Integer.parseInt(parentCategoryInfoNo_string);
		
		CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
		
		CategoryInfo categoryInfo = new CategoryInfo();
		PropertyUtils.copyProperties(categoryInfo, categoryInfoForm);
	
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.addSubCategoryInfo(categoryInfo, parentCategoryInfoNo);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}
	
	private void delete_category(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String categoryInfoNo_string = request.getParameter("categoryInfoNo") != null ? request	.getParameter("categoryInfoNo") : "";
		String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
		int categoryInfoNo = Integer.parseInt(categoryInfoNo_string);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.deleteCategoryInfo(categoryInfoNo, categorySchemeNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void view_category_scheme(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String schemeNo = request.getParameter("schemeNo");
		log.info("schemeNo:" + schemeNo);

		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService")); 
		CategoryScheme categoryScheme = categoryService.findCategoryScheme(schemeNo);
		
		request.setAttribute("categoryScheme", categoryScheme);
		
		MyWorkList categoryInfoList = categoryService.findCategoryInfoList(schemeNo);
		
		request.setAttribute("categoryInfoList", categoryInfoList);

	}
	
	private void lower_category(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request	.getParameter("categorySchemeNo") : "";
		
		String categoryInfoNo_string = request.getParameter("categoryInfoNo") != null ? request	.getParameter("categoryInfoNo") : "";
		int categoryInfoNo = Integer.parseInt(categoryInfoNo_string);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.lowerCategoryInfo(categorySchemeNo, categoryInfoNo);
		
		request.setAttribute("alertMessage", "변경되었습니다.");
	
	}
}
