package kr.co.leaderway.mywork.common;

import java.util.Locale;
import java.util.NoSuchElementException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkexception.action.MyWorkExceptionHandler;
import kr.co.leaderway.mywork.statics.ServiceType;
import kr.co.leaderway.mywork.system.MyWorkConfig;
import kr.co.leaderway.mywork.user.model.UserInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class MyWorkAbstractController extends AbstractController {

    protected final Log log = LogFactory.getLog(getClass());

    private String nowActionName = "";
	private String nowMethodName = "";
	protected String remoteUserIpAddress = "";
	protected String remoteUserIpAddressBin = "";
	protected String nowUserNo = "";
	protected String userLocale = "";
	ModelAndView mav = null;
	
    private MessageSource messageSource;

	public MessageSource getMessageSource() {
		return messageSource;
	}

	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	protected abstract ModelAndView doExecute(HttpServletRequest request,
			  HttpServletResponse response) throws Exception;
	
	protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) throws Exception {
	
		String action_now = request.getServletPath(); 
		String modified_action_string1 = action_now.replace("/", "");
		nowActionName = modified_action_string1.replace(".spring", "");
		nowMethodName = request.getParameter("mode");
		
		HttpSession session = request.getSession();

		Locale locale = (Locale)request.getSession().getAttribute(Globals.LOCALE_KEY);
		
		userLocale = (String) session.getAttribute("sessionLanguage");
		
		if (userLocale == null) {
			userLocale = "korean";
			session.setAttribute("sessionLanguage", "korean");
			session.setAttribute("sessionLanguageNo", "MLLG201005150703010001");
		}
		
		if (userLocale != null) {
			if (userLocale.equals("korean")) {
				
				locale = new Locale( "ko", "KR" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);

			} else if (userLocale.equals("english")) {
				
				locale = new Locale( "en", "US" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);

			} else if (userLocale.equals("japanese")) {
				
				locale = new Locale( "ja", "JP" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
			
			} else if (userLocale.equals("chinese")) {
				
				locale = new Locale( "ja", "CN" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
				
			} else if (userLocale.equals("spanish")) {
				
				locale = new Locale( "ja", "JP" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
				
			} else if (userLocale.equals("french")) {
				
				locale = new Locale( "fr", "CA" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
			}
		}
		
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		String sessionUserId = "";
		String sessionUserNo = "";
		
		if (userInfo == null) {
			sessionUserId = "notlogin";
			sessionUserNo = "USERNOTLOGINNOTLOGIN01"; // notlogin user userNo
		} else {
			sessionUserId = userInfo.getUser().getUserId();
			sessionUserNo = userInfo.getUser().getNo();
		}
		
		nowUserNo = sessionUserNo;
		System.out.println("nowUserNo:" + nowUserNo);
		
		try {
			
			mav = doExecute(request, response);
			
		} catch (Exception now_exception) {
		
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			mav = MyWorkexceptionHandler.handle(now_exception, request, response);
			
		} finally {
			
		}
		
		return mav;
		
	}

	protected int getServiceType() {

		try {
			log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + nowUserNo + " ... ");
			return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + nowUserNo + "." + "serviceType");

		} catch (NoSuchElementException e) {
			try {
				log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + " ... ");
				return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + "serviceType");

			} catch (NoSuchElementException eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			} catch (Exception eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			}
		} catch (Exception e) {
			log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
			return ServiceType.ServiceDefault;
			
		}
		
	}
	
	protected int getServiceType(String serviceName) {
		
		try {
			log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "." + nowUserNo + " ... ");
			return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "." + nowUserNo + ".serviceType");

		} catch (NoSuchElementException e) {
			try {
				log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + " ... ");
				return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + ".serviceType");

			} catch (NoSuchElementException eSecond) {
				try {
					log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + serviceName + " ... ");
					return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + serviceName + ".serviceType");
				
				} catch (NoSuchElementException eThird) {
					try {
						log.debug("serviceType for " + "serviceTypesConfig." + serviceName + "." + nowUserNo + " ... ");
						return MyWorkConfig.getInt("serviceTypesConfig." + serviceName + "." + nowUserNo + ".serviceType");
					
					} catch (NoSuchElementException eForth) {
						try {
							log.debug("serviceType for " + "serviceTypesConfig." + serviceName + " ... ");
							return MyWorkConfig.getInt("serviceTypesConfig." + serviceName + ".serviceType");
						} catch (NoSuchElementException eFifth) {
							try {
								return getServiceType();
							} catch (NoSuchElementException eSeventh) {
							
								log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
								return ServiceType.ServiceDefault;
							}
						}
					}
				}
				
			} catch (Exception eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			}
		} catch (Exception e) {
			log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
			return ServiceType.ServiceDefault;
			
		}
		
	}
}
