package kr.co.leaderway.mywork.board.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.board.BoardService;
import kr.co.leaderway.mywork.board.form.BoardForm;
import kr.co.leaderway.mywork.board.model.Board;
import kr.co.leaderway.mywork.board.model.BoardSchemeInfo;
import kr.co.leaderway.mywork.board.model.BoardSearchParameter;
import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class BoardAction extends BaseAction {
	
private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_board")) {
			
			add_board(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "list_board");
			return redirect;
			
		} else if (mode.equals("add_board_form")) {
			
			request.setAttribute("contentTitle", "게시판 관리 - 게시판 추가");
			return mapping.findForward("board_add");
			
		} else if (mode.equals("view_board")) {
			
			view_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 게시판 정보보기");
			
			return mapping.findForward("board_view");
			
		} else if (mode.equals("modify_board_form")) {
			
			view_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 수정");
			
			return mapping.findForward("board_modify_form");
			
		} else if (mode.equals("assign_category_scheme_form")) {
			
			view_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 카테고리 Scheme 할당");
			
			return mapping.findForward("category_scheme_assign_form");
			
		} else if (mode.equals("add_category_scheme")) {
			
			add_category_scheme(mapping, form, request, response);
			
			BoardForm boardForm = (BoardForm) form;
			String boardNo = boardForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "view_board");
			redirect.addParameter("no", boardNo);
			return redirect;
			
		} else if (mode.equals("delete_category_scheme")) {
			
			delete_category_scheme(mapping, form, request, response);
			
			BoardForm boardForm = (BoardForm) form;
			String boardNo = boardForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "view_board");
			redirect.addParameter("no", boardNo);
			return redirect;
		
		} else if (mode.equals("assign_access_group_form")) {
			
			view_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 게시판 접근 그룹 할당");
			
			return mapping.findForward("board_access_group_assign_form");
		
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
			
			BoardForm boardForm = (BoardForm) form;
			String no = boardForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
			
			delete_access_group(mapping, form, request, response);
			
			BoardForm boardForm = (BoardForm) form;
			String no = boardForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("modify_board")) {
			
			modify_board(mapping, form, request, response);
				
			BoardForm boardForm = (BoardForm) form;
			String boardNo = boardForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "view_board");
			redirect.addParameter("no", boardNo);
			return redirect;
			
		} else if (mode.equals("delete_board")) {
			
			delete_board(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BoardAction") );
			redirect.addParameter("mode", "list_board");
			return redirect;
			
		} else { // list_board
		    	
			list_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 리스트");
			
		    return mapping.findForward("board_list");
		    	
		}
	}

	@SuppressWarnings("unchecked")
	private void list_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		BoardSearchParameter boardSearchParameter = new BoardSearchParameter();
		boardSearchParameter.setCurrentPage(page);
		boardSearchParameter.setRowsPerPage(per_page);
		
		MyWorkList boardList = boardService.findBoardList(boardSearchParameter); 
		
		request.setAttribute("boardList", boardList);
		
	}
	
	private void add_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BoardForm boardForm = (BoardForm) form;
		
		Board board = new Board();
		PropertyUtils.copyProperties(board, boardForm);
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		
		boardService.addBoard(board);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
	}
	
	private void view_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String boardNo = request.getParameter("no");
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		Board board =  boardService.findBoard(boardNo);
		
		request.setAttribute("board", board);
		
		List boardAccessGroupList = boardService.findBoardAccessGroupList(boardNo);
		
		request.setAttribute("boardAccessGroupList", boardAccessGroupList);
		
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService")); 
		MyWorkList categorySchemeList = categoryService.listCategorySchemeByBoardNo(boardNo);
		
		request.setAttribute("categorySchemeList", categorySchemeList);

	}
	
	private void modify_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BoardForm boardForm = (BoardForm) form;
		
		Board board = new Board();
		PropertyUtils.copyProperties(board, boardForm);
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.updateBoard(board);
	
	}
	
	private void delete_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BoardForm boardForm = (BoardForm) form;
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.deleteBoard(boardForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
	}
	
	private void add_category_scheme(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String schemeNo = request.getParameter("schemeNo");
		String isMultiSelect_string = request.getParameter("isMultiSelect");
		int isMultiSelect = Integer.parseInt(isMultiSelect_string);
		String showLocation_string = request.getParameter("showLocation");
		int showLocation = Integer.parseInt(showLocation_string);
		
		BoardForm boardForm = (BoardForm) form;
		String boardNo = boardForm.getNo();
		
		BoardSchemeInfo boardSchemeInfo = new BoardSchemeInfo();
		boardSchemeInfo.setBoardNo(boardNo);
		boardSchemeInfo.setSchemeNo(schemeNo);
		boardSchemeInfo.setShowLocation(showLocation);
		boardSchemeInfo.setMultiSelect(isMultiSelect);
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.addCategoryScheme(boardSchemeInfo);
	
	}
	
	private void delete_category_scheme(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String schemeNo = request.getParameter("schemeNo");
		
		BoardForm boardForm = (BoardForm) form;
		String boardNo = boardForm.getNo();
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.deleteCategoryScheme(boardNo, schemeNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
	}
	
	private void add_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_access_right_string = request.getParameter("access_right");
		int selected_access_right = Integer.parseInt(selected_access_right_string);
		
		BoardForm boardForm = (BoardForm) form;
		
		Board board = new Board();
		PropertyUtils.copyProperties(board, boardForm);
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.addAccessGroup(board, selected_groupno, selected_groupTypeNo, selected_access_right);
	
	}
	
	private void delete_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService")); 
		boardService.deleteAccessGroup(selected_groupno);
	
	}
	
}
