package kr.co.leaderway.CustomTag.Paging;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class RowsLimitTag extends BodyTagSupport {
	public int doAfterBody() throws JspTagException {
		int rowsLimit = 10;		// default = 10;
		PagingTag parent = (PagingTag) findAncestorWithClass( this, PagingTag.class );
		
		if ( parent == null )	{
			throw new JspTagException( "부모 태그(PagingTag.class)가 없습니다." );
		}
		
		rowsLimit = Integer.parseInt( getBodyContent().getString().trim() );
		if ( rowsLimit == 0 )	{
			rowsLimit = 10;
		}
		parent.setRowsLimit( rowsLimit );
		
		return SKIP_BODY;
	}

}
