package kr.co.leaderway.CustomTag.Paging;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class PageLimitTag extends BodyTagSupport {
	public int doAfterBody() throws JspTagException {
		int pageLimit = 10;	// default = 10;
		PagingTag parent = (PagingTag) findAncestorWithClass( this, PagingTag.class );
		
		if ( parent == null )	{
			throw new JspTagException( "부모 태그(PagingTag.class)가 없습니다." );
		}
		
		pageLimit = Integer.parseInt( getBodyContent().getString().trim() );
		if ( pageLimit == 0 )	{
			pageLimit = 10;
		}
		parent.setPageLimit( pageLimit );
		
		return SKIP_BODY;
	}

}
