package kr.co.leaderway.mywork.system.action;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkAction.model.MyWorkAction;
import kr.co.leaderway.mywork.MyWorkException.LengthDoNotMatchException;
import kr.co.leaderway.mywork.MyWorkException.MyWorkNetworkNotAuthorizedException;
import kr.co.leaderway.mywork.MyWorkException.MyWorkNotAuthorizedException;
import kr.co.leaderway.mywork.MyWorkexception.action.MyWorkExceptionHandler;
import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.menu.model.Menu;
import kr.co.leaderway.mywork.menu.model.MenuGroup;
import kr.co.leaderway.mywork.menu.model.MenuSearchParameter;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.statics.ServiceType;
import kr.co.leaderway.mywork.system.MyWorkConfig;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.util.BitTool;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class BaseAction extends Action {
	
	private Log log = LogFactory.getLog(this.getClass());
	
	private String nowActionName = "";
	private String nowMethodName = "";
	protected String remoteUserIpAddress = "";
	protected String remoteUserIpAddressBin = "";
	protected String nowUserNo = "";
	protected String userLocale = "";
	
	protected abstract ActionForward doExecute(ActionMapping mapping,
												 						  ActionForm form,
												 						  HttpServletRequest request,
												 						  HttpServletResponse response) throws Exception;
	
	@SuppressWarnings("unchecked")
	public ActionForward execute(ActionMapping mapping,
												 ActionForm form,
												 HttpServletRequest request,
												 HttpServletResponse response) throws Exception {

		String action_now = request.getServletPath(); 
		String modified_action_string1 = action_now.replace("/", "");
		nowActionName = modified_action_string1.replace(".do", "");
		nowMethodName = request.getParameter("mode");
		
		remoteUserIpAddress = request.getRemoteAddr();
		
		if (remoteUserIpAddress.equals("0:0:0:0:0:0:0:1")) {  //ipv6 loopback address
			remoteUserIpAddress = "127.0.0.1";
		}
		
		StringTokenizer st1 = new StringTokenizer(remoteUserIpAddress,".");
		
		remoteUserIpAddressBin = "";
        while(st1.hasMoreTokens()) {
        	remoteUserIpAddressBin += StringUtils.leftPad("" + Integer.toBinaryString(Integer.parseInt(st1.nextToken())), 8, "0");
        }
        
		ActionForward actionForward = null;
		
		HttpSession session = request.getSession();

		Locale locale = (Locale)request.getSession().getAttribute(Globals.LOCALE_KEY);
		
		userLocale = (String) session.getAttribute("sessionLanguage");
		
		if (userLocale == null) {
			userLocale = "korean";
			session.setAttribute("sessionLanguage", "korean");
			session.setAttribute("sessionLanguageNo", "MLLG201005150703010001");
		}
		
		if (userLocale != null) {
			if (userLocale.equals("korean")) {
				
				locale = new Locale( "ko", "KR" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);

			} else if (userLocale.equals("english")) {
				
				locale = new Locale( "en", "US" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);

			} else if (userLocale.equals("japanese")) {
				
				locale = new Locale( "ja", "JP" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
			
			} else if (userLocale.equals("chinese")) {
				
				locale = new Locale( "ja", "CN" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
				
			} else if (userLocale.equals("spanish")) {
				
				locale = new Locale( "ja", "JP" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
				
			} else if (userLocale.equals("french")) {
				
				locale = new Locale( "fr", "CA" ); 
				session.setAttribute(org.apache.struts.Globals.LOCALE_KEY,locale);
			}
		}
		
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		String sessionUserId = "";
		String sessionUserNo = "";
		
		if (userInfo == null) {
			sessionUserId = "notlogin";
			sessionUserNo = "USERNOTLOGINNOTLOGIN01"; // notlogin user userNo
		} else {
			sessionUserId = userInfo.getUser().getUserId();
			sessionUserNo = userInfo.getUser().getNo();
		}
		
		nowUserNo = sessionUserNo;
		
		String selectedMenuNo_string = request.getParameter("selected_menu_no") != null ? (String) request.getParameter("selected_menu_no") : "0";
		int selectedMenuNo = Integer.parseInt(selectedMenuNo_string);
		
		if (userInfo == null && selectedMenuNo == 0) {
			
		} else if (userInfo != null && selectedMenuNo == 0) {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		} else if (userInfo == null && selectedMenuNo != 0) {
			// do nothing
		} else if (selectedMenuNo != 0){
			userInfo.getCurrentMenu().setNo(selectedMenuNo);
		} else {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		}
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		List selectedMenuList = menuService.getSelectedMenuList(selectedMenuNo);
		
		int selected_top_menu_no = 0;
		
		if (selectedMenuList.size() > 0) {
		
			Iterator iterator = selectedMenuList.iterator();
			while ( iterator.hasNext() ) {
				Menu menu = (Menu)iterator.next();
			}
			
			if (userInfo != null) {
				userInfo.setSelectedMenuList(selectedMenuList);
			}
		
			request.setAttribute("selectedMenuList", selectedMenuList);	

			Menu selected_top_menu = (Menu) selectedMenuList.get(selectedMenuList.size() - 1);
			selected_top_menu_no = selected_top_menu.getNo();
		}
		
		MenuSearchParameter menuSearchParameter = new MenuSearchParameter();
		menuSearchParameter.setGroupId(1);
		menuSearchParameter.setUserNo(sessionUserNo);
		
		List topMenuList = menuService.getAccessibleMenuList(menuSearchParameter);
		request.setAttribute("topMenuList", topMenuList);
		
		List childMenuGroupList = menuService.getChildMenuGroupList(selected_top_menu_no);
		Iterator menuGroupIter = childMenuGroupList.iterator();
		
		int childMenuGroupNo = 0;
		
		while ( menuGroupIter.hasNext() ) {
			MenuGroup menuGroup = (MenuGroup)menuGroupIter.next();
			childMenuGroupNo = menuGroup.getNo();
			break;  // only get first child (temporary code)
		}
		
		if (childMenuGroupNo != 0) {
			menuSearchParameter.setGroupId(childMenuGroupNo);
			List leftMenuList = menuService.getAccessibleMenuList(menuSearchParameter);
			
			request.setAttribute("leftMenuList", leftMenuList);	
		}
		
		
		String authCheckResult = checkAccessRight(nowActionName, nowMethodName, sessionUserNo);
		
		if (authCheckResult.equals("not authorized")) {
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			actionForward = MyWorkexceptionHandler.handle(new MyWorkNotAuthorizedException(), mapping, form, request, response);
			
			return actionForward;
		} else if (authCheckResult.equals("not authorized network access")) {
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			actionForward = MyWorkexceptionHandler.handle(new MyWorkNetworkNotAuthorizedException(), mapping, form, request, response);
			
			return actionForward;
		}
		
		try {
			
			actionForward = doExecute(mapping, form, request, response);
			
		} catch (Exception now_exception) {
		
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			actionForward = MyWorkexceptionHandler.handle(now_exception, mapping, form, request, response);
			
		} finally {
			
		}
		
		return actionForward;
	}

	@SuppressWarnings("unchecked")
	private String checkAccessRight(String actionName, String methodName, String userNo) throws Exception {

		MyWorkAction myWorkAction = new MyWorkAction();
		myWorkAction.setMethodGroupName(actionName);
		myWorkAction.setMethodName(methodName);
		myWorkAction.setUserNo(userNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		
		List actionList = rightService.getAccessRightOnMethodByUserNo(myWorkAction);
		
		int authorizedCount = 0;
		int notAuthorizedByNetworkCount = 0;
		Iterator actionItor = actionList.iterator();
		while (actionItor.hasNext()) {
			MyWorkAction myWorkActionGet = (MyWorkAction)actionItor.next();
			
			if (myWorkActionGet.getAccessGroupType() == 2 && myWorkActionGet.getAssignedIp() != null) {
				
				try {
					String authorizedNetwork = BitTool.bitAnd(myWorkActionGet.getAssignedIp(), myWorkActionGet.getAssignedNetmask());
					
					String remoteIpAddressBinMasked = BitTool.bitAnd(remoteUserIpAddressBin, myWorkActionGet.getAssignedNetmask());
					
					if (authorizedNetwork.equals(remoteIpAddressBinMasked)) {
						authorizedCount++;
					} else {
						notAuthorizedByNetworkCount++;
					}
				} catch (LengthDoNotMatchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			} else {
				authorizedCount++;
			}
		}
		int resultNum = actionList.size();
		
		String result = null;
		
		if (authorizedCount > 0) {
			log.debug("======================================");
			log.debug("authorized");
			log.debug("======================================");
			result = "authorized";
		} else if (resultNum > 0) {
			log.debug("======================================");
			log.debug("not authorized network access");
			log.debug("======================================");
			result = "not authorized network access";
		} else {
			log.debug("======================================");
			log.debug("not authorized");
			log.debug("======================================");
			result = "not authorized";
		}
		
		return result;
	}
	
	protected int getServiceType() {

		try {
			log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + nowUserNo + " ... ");
			return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + nowUserNo + "." + "serviceType");

		} catch (NoSuchElementException e) {
			try {
				log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + " ... ");
				return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + "serviceType");

			} catch (NoSuchElementException eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			} catch (Exception eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			}
		} catch (Exception e) {
			log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "... resorting to ServiceType.ServiceDefault." );
			return ServiceType.ServiceDefault;
			
		}
		
	}
	
	protected int getServiceType(String serviceName) {

		try {
			log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "." + nowUserNo + " ... ");
			return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "." + nowUserNo + ".serviceType");

		} catch (NoSuchElementException e) {
			try {
				log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + " ... ");
				return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + ".serviceType");

			} catch (NoSuchElementException eSecond) {
				try {
					log.debug("serviceType for " + "serviceTypesConfig." + nowActionName + "." + serviceName + " ... ");
					return MyWorkConfig.getInt("serviceTypesConfig." + nowActionName + "." + serviceName + ".serviceType");
				
				} catch (NoSuchElementException eThird) {
					try {
						log.debug("serviceType for " + "serviceTypesConfig." + serviceName + "." + nowUserNo + " ... ");
						return MyWorkConfig.getInt("serviceTypesConfig." + serviceName + "." + nowUserNo + ".serviceType");
					
					} catch (NoSuchElementException eForth) {
						try {
							log.debug("serviceType for " + "serviceTypesConfig." + serviceName + " ... ");
							return MyWorkConfig.getInt("serviceTypesConfig." + serviceName + ".serviceType");
						} catch (NoSuchElementException eFifth) {
							try {
								return getServiceType();
							} catch (NoSuchElementException eSeventh) {
							
								log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
								return ServiceType.ServiceDefault;
							}
						}
					}
				}
				
			} catch (Exception eSecond) {
				log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
				return ServiceType.ServiceDefault;
				
			}
		} catch (Exception e) {
			log.info("serviceType for " + "serviceTypesConfig." + nowActionName + "." + nowMethodName + "." + serviceName + "... resorting to ServiceType.ServiceDefault." );
			return ServiceType.ServiceDefault;
			
		}
		
	}
	
}
