package kr.co.leaderway.mywork.right.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.right.form.AccessGroupForm;
import kr.co.leaderway.mywork.right.model.AccessGroup;
import kr.co.leaderway.mywork.right.model.AccessGroupNetworkInfo;
import kr.co.leaderway.mywork.right.model.AccessGroupSearchParameter;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class RightManageAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("list_menu_access_info")) {
			
			list_menu_access_info(mapping, form, request, response);
			
			return mapping.findForward("menu_access_info_list");
			
	    } else if  (mode.equals("add_access_group_form")) {
	    	request.setAttribute("contentTitle", "access 그룹 관리 - 그룹 추가");
			return mapping.findForward("access_group_add_form");
		
	    } else if  (mode.equals("add_access_group")) {
			
	    	add_access_group(mapping, form, request, response);
	    	
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "list_access_group");
			return redirect;
			
	    } else if  (mode.equals("modify_access_group_form")) {
				
	    	view_access_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "access 그룹 관리 - access 그룹 수정");	
	    	return mapping.findForward("access_group_modify_form");
				
	    } else if  (mode.equals("assign_access_group_form")) {
			
	    	view_access_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "access 그룹 관리 - 유저 그룹 할당");	
	    	return mapping.findForward("access_group_assign_form");
	    	
	    } else if  (mode.equals("assign_access_group_network_form")) {
			
	    	view_access_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "access 그룹 관리 - 유저 그룹 할당");	
	    	return mapping.findForward("access_group_network_assign_form");
	    	
	    } else if  (mode.equals("add_user_group")) {
			
	    	add_user_group(mapping, form, request, response);
	    	
	    	AccessGroupForm accessGroupForm = (AccessGroupForm) form;
			String access_group_no = accessGroupForm.getNo();
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", access_group_no);
			return redirect;
	    	
	    } else if  (mode.equals("delete_user_group")) {
			
	    	delete_user_group(mapping, form, request, response);
	    	
	    	AccessGroupForm accessGroupForm = (AccessGroupForm) form;
			String access_group_no = accessGroupForm.getNo();
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", access_group_no);
			return redirect;
			
	    } else if  (mode.equals("view_access_group")) {
			
	    	view_access_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "access 그룹 관리 - 그룹 보기");	
	    	return mapping.findForward("access_group_view");
		
	    } else if  (mode.equals("modify_access_group")) {
			
	    	modify_access_group(mapping, form, request, response);
		    	
	    	AccessGroupForm accessGroupForm = (AccessGroupForm) form;
			String access_group_no = accessGroupForm.getNo();
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "view_access_group");
			redirect.addParameter("no", access_group_no);
			return redirect;
	    	
	    } else if  (mode.equals("delete_access_group")) {
			
	    	delete_access_group(mapping, form, request, response);
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "list_access_group");
			return redirect;
			
	    } else if  (mode.equals("add_network")) {
			
	    	add_network(mapping, form, request, response);
			
	    	AccessGroupForm accessGroupForm = (AccessGroupForm) form;
			String access_group_no = accessGroupForm.getNo();
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "assign_access_group_network_form");
			redirect.addParameter("no", access_group_no);
			return redirect;
		
	    } else if  (mode.equals("delete_network")) {
			
	    	delete_network(mapping, form, request, response);
			
	    	AccessGroupForm accessGroupForm = (AccessGroupForm) form;
			String access_group_no = accessGroupForm.getNo();
			
	    	ActionRedirect redirect = new ActionRedirect( mapping.findForward("RightManageAction") );
			redirect.addParameter("mode", "assign_access_group_network_form");
			redirect.addParameter("no", access_group_no);
			return redirect;
			
	    } else { // list_access_group
	    	
	    	list_access_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "Access 그룹 관리 - 리스트");
	    	return mapping.findForward("access_group_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_menu_access_info(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String groupId_string = request.getParameter("groupId") != null ? (String) request.getParameter("groupId") : "";
		
		if (groupId_string.equals("") ) {
			groupId_string = "0";
		}

		int groupId = Integer.parseInt(groupId_string);

		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		List menuList = menuService.getMenuListByGroupId(groupId);
		
		HttpSession session = request.getSession();
		String sessionUserId = (String) session.getAttribute("userId");
		
		request.setAttribute("sessionUserId", sessionUserId);
		request.setAttribute("menuList", menuList);

	}
	
	@SuppressWarnings("unchecked")
	private void list_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		AccessGroupSearchParameter accessGroupSearchParameter = new AccessGroupSearchParameter();
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		accessGroupSearchParameter.setCurrentPage(page);
		accessGroupSearchParameter.setRowsPerPage(per_page);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		MyWorkList accessGroupList = rightService.findAccessGroupList(accessGroupSearchParameter);
		
		request.setAttribute("accessGroupList", accessGroupList);
	
	}

	@SuppressWarnings("unchecked")
	private void view_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String access_group_no = request.getParameter("no");
		
		log.info("access_group_no:" + access_group_no);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		AccessGroup accessGroup = rightService.findAccessGroup(access_group_no);
		
		request.setAttribute("accessGroup", accessGroup);		
		
		List userGroupList = rightService.findUserGroupList(access_group_no);
		
		request.setAttribute("userGroupList", userGroupList);	
		
		List assignedNetworkList = rightService.getNetworkListByAccessGroupNo(access_group_no);
		request.setAttribute("assignedNetworkList", assignedNetworkList);	
	
	}
	
	private void add_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		AccessGroupForm accessGroupForm = (AccessGroupForm) form;
		
		AccessGroup accessGroup = new AccessGroup();
		PropertyUtils.copyProperties(accessGroup, accessGroupForm);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.addAccessGroup(accessGroup);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
	}
	
	private void modify_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		AccessGroupForm accessGroupForm = (AccessGroupForm) form;
		
		AccessGroup accessGroup = new AccessGroup();
		PropertyUtils.copyProperties(accessGroup, accessGroupForm);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.updateAccessGroup(accessGroup);
		
		request.setAttribute("alertMessage", "수정되었습니다.");
	
	}
	
	private void delete_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		AccessGroupForm accessGroupForm = (AccessGroupForm) form;
		
		AccessGroup accessGroup = new AccessGroup();
		PropertyUtils.copyProperties(accessGroup, accessGroupForm);

		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.deleteAccessGroup(accessGroup.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void add_user_group(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		
		AccessGroupForm accessGroupForm = (AccessGroupForm) form;
		
		AccessGroup accessGroup = new AccessGroup();
		PropertyUtils.copyProperties(accessGroup, accessGroupForm);

		accessGroup.setAccessGroupNo(accessGroup.getNo());
		accessGroup.setAssignedUserGroupNo(selected_groupno);
		accessGroup.setAccessGroupType(selected_groupTypeNo);
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.addUserGroup(accessGroup);
	
	}
	
	private void delete_user_group(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String selected_groupno = request.getParameter("selected_groupno");
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.deleteUserGroup(selected_groupno);
	
	}
	
	private void add_network(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		AccessGroupForm accessGroupForm = (AccessGroupForm) form;
		
		AccessGroup accessGroup = new AccessGroup();
		PropertyUtils.copyProperties(accessGroup, accessGroupForm);
		
		String networkNo = request.getParameter("networkNo") != null ? (String) request.getParameter("networkNo") : "";
		AccessGroupNetworkInfo accessGroupNetworkInfo = new AccessGroupNetworkInfo();
		accessGroupNetworkInfo.setAccessGroupNo(accessGroup.getNo());
		accessGroupNetworkInfo.setAssignedNetworkNo(networkNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.addAccessGroupNetworkInfo(accessGroupNetworkInfo);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
	}
	
	private void delete_network(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String networkInfoNo = request.getParameter("selected_network_Info_no") != null ? (String) request.getParameter("selected_network_Info_no") : "";
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, getServiceType("RightService"));
		rightService.deleteAccessGroupNetworkInfo(networkInfoNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
}
