package kr.co.leaderway.mywork.project.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.project.ProjectService;
import kr.co.leaderway.mywork.project.form.ProjectForm;
import kr.co.leaderway.mywork.project.model.Project;
import kr.co.leaderway.mywork.project.model.ProjectSchemeInfo;
import kr.co.leaderway.mywork.project.model.ProjectSearchParameter;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class ProjectAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if (mode.equals("add_project_form")) {
			
			request.setAttribute("contentTitle", "버그 관리 - 프로젝트 추가");
			
			return mapping.findForward("project_add");
		
		} else if (mode.equals("add_project")) {
			
			add_project(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "list_project");
			return redirect;
		
		} else if (mode.equals("view_project")) {
			
			view_project(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "버그 관리 - 프로젝트 보기");
			
			return mapping.findForward("project_view");
			
		} else if (mode.equals("delete_project")) {
			
			delete_project(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "list_project");
			return redirect;
			
		} else if (mode.equals("modify_project_form")) {
			
			view_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 프로젝트 수정");
			
			return mapping.findForward("project_modify_form");
			
		} else if (mode.equals("modify_project")) {
			
			modify_project(mapping, form, request, response);
				
			ProjectForm projectForm = (ProjectForm) form;
			String projectNo = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "view_project");
			redirect.addParameter("no", projectNo);
			return redirect;
			
		} else if (mode.equals("manage_bug")) {
			
			manage_bug(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 메인");
			
			return mapping.findForward("bug_manage_view");
			
		} else if (mode.equals("assign_category_scheme_form")) {
			
			view_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 카테고리 Scheme 할당");
			
			return mapping.findForward("category_scheme_assign_form");
			
		} else if (mode.equals("add_category_scheme")) {
			
			add_category_scheme(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String projectNo = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "view_project");
			redirect.addParameter("no", projectNo);
			return redirect;
			
		} else if (mode.equals("delete_category_scheme")) {
			
			delete_category_scheme(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String projectNo = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "view_project");
			redirect.addParameter("no", projectNo);
			return redirect;
			
		} else if (mode.equals("assign_access_group_form")) {
			
			view_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 프로젝트 접근 그룹 할당");
			
			return mapping.findForward("project_access_group_assign_form");
		
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String no = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
			
			delete_access_group(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String no = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("assign_role_group_form")) {
			
			view_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 프로젝트 role 할당");
			
			return mapping.findForward("project_role_group_assign_form");
			
		} else if (mode.equals("add_role_group")) {
			
			add_role_group(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String no = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "assign_role_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_role_group")) {
			
			delete_role_group(mapping, form, request, response);
			
			ProjectForm projectForm = (ProjectForm) form;
			String no = projectForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ProjectAction") );
			redirect.addParameter("mode", "assign_role_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
	    } else { // list_project
	    	
	    	list_project(mapping, form, request, response);
			request.setAttribute("contentTitle", "버그 관리 - 메인");
			
			return mapping.findForward("project_list");
	    	
	    }
		
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_project(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		ProjectSearchParameter projectSearchParameter = new ProjectSearchParameter();
		projectSearchParameter.setCurrentPage(page);
		projectSearchParameter.setRowsPerPage(per_page);
		
		MyWorkList projectList = projectService.findProjectList(projectSearchParameter); 
		
		request.setAttribute("projectList", projectList);
		
	}
	
	private void add_project(ActionMapping mapping,
				ActionForm form,
				HttpServletRequest request,
				HttpServletResponse response) throws Exception {
	
		ProjectForm projectForm = (ProjectForm) form;
		
		Project project = new Project();
		PropertyUtils.copyProperties(project, projectForm);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.addProject(project);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
	}
	
	private void view_project(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String projectNo = request.getParameter("no");
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		Project project =  projectService.findProject(projectNo);
		
		request.setAttribute("project", project);
		
		List projectAccessGroupList = projectService.findProjectAccessGroupList(projectNo);
		request.setAttribute("projectAccessGroupList", projectAccessGroupList);
		
		List projectRoleGroupList = projectService.findProjectRoleGroupList(projectNo);
		request.setAttribute("projectRoleGroupList", projectRoleGroupList);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		
		request.setAttribute("categorySchemeList", categorySchemeList);
	
	}
	
	private void delete_project(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String projectNo = request.getParameter("no");
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.deleteProject(projectNo);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.deleteBugCategorySchemeByProjectNo(projectNo);
	
	}
	
	private void modify_project(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		ProjectForm projectForm = (ProjectForm) form;
		Project project = new Project();
		PropertyUtils.copyProperties(project, projectForm);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.updateProject(project);
		
	}
	
	private void manage_bug(ActionMapping mapping,
							ActionForm form,
							HttpServletRequest request,
							HttpServletResponse response) throws Exception {

		String projectNo = request.getParameter("no");
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		MyWorkList categorySchemeList = categoryService.listBugCategorySchemeByProjectNo(projectNo);
		
		request.setAttribute("categorySchemeList", categorySchemeList);
	}
	
	private void add_category_scheme(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String schemeNo = request.getParameter("schemeNo");
		String isMultiSelect_string = request.getParameter("isMultiSelect");
		int isMultiSelect = Integer.parseInt(isMultiSelect_string);
		String showLocation_string = request.getParameter("showLocation");
		int showLocation = Integer.parseInt(showLocation_string);
		
		ProjectForm projectForm = (ProjectForm) form;
		String projectNo = projectForm.getNo();
		
		ProjectSchemeInfo projectSchemeInfo = new ProjectSchemeInfo();
		projectSchemeInfo.setProjectNo(projectNo);
		projectSchemeInfo.setSchemeNo(schemeNo);
		projectSchemeInfo.setShowLocation(showLocation);
		projectSchemeInfo.setMultiSelect(isMultiSelect);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.addCategoryScheme(projectSchemeInfo);
		
	}
		
	private void delete_category_scheme(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String schemeNo = request.getParameter("schemeNo");
		
		ProjectForm projectForm = (ProjectForm) form;
		String projectNo = projectForm.getNo();
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.deleteCategoryScheme(projectNo, schemeNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
	}
	
	private void add_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_access_right_string = request.getParameter("access_right");
		int selected_access_right = Integer.parseInt(selected_access_right_string);
		
		ProjectForm projectForm = (ProjectForm) form;
		
		Project project = new Project();
		PropertyUtils.copyProperties(project, projectForm);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.addAccessGroup(project, selected_groupno, selected_groupTypeNo, selected_access_right);
		
	}
	
	private void delete_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.deleteAccessGroup(selected_groupno);
	
	}
	
	private void add_role_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_role_right_string = request.getParameter("role_right");
		int selected_role_right = Integer.parseInt(selected_role_right_string);
		
		ProjectForm projectForm = (ProjectForm) form;
		
		Project project = new Project();
		PropertyUtils.copyProperties(project, projectForm);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.addRoleGroup(project, selected_groupno, selected_groupTypeNo, selected_role_right);
	
	}
	
	private void delete_role_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno_string = request.getParameter("selected_groupno");
		int selected_groupno = Integer.parseInt(selected_groupno_string);
		
		ProjectService projectService = (ProjectService)ServiceCallUtil.call(ProjectService.class, getServiceType("ProjectService")); 
		projectService.deleteRoleGroup(selected_groupno);
	
	}
}
