package kr.co.leaderway.mywork.businessProcess.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.businessProcess.BusinessProcessService;
import kr.co.leaderway.mywork.businessProcess.form.BusinessProcessForm;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcess;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcessRoleGroupSearchParameter;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcessSearchParameter;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcessStep;
import kr.co.leaderway.mywork.businessProcess.model.BusinessProcessStepNext;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.network.NetworkService;
import kr.co.leaderway.mywork.network.form.NetworkForm;
import kr.co.leaderway.mywork.network.model.Network;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class BusinessProcessAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_process")) {
			
			add_process(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "list_process");
			return redirect;

		} else if (mode.equals("add_process_form")) {
			
			request.setAttribute("contentTitle", "업무 관리 - 추가");
			return mapping.findForward("process_add_form");
			
		} else if (mode.equals("view_process")) {
			
			view_process(mapping, form, request, response);
			request.setAttribute("contentTitle", "업무 관리 - 업무 정보보기");
			
			return mapping.findForward("process_view");
			
		} else if (mode.equals("modify_process_form")) {
			 
			view_process(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 수정");	
			return mapping.findForward("process_modify_form");
			
		} else if (mode.equals("modify_process")) {
			
			modify_process(mapping, form, request, response);
				
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "view_process");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_process")) {
			
			delete_process(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "list_process");
			return redirect;
		    	
		} else if (mode.equals("assign_process_step_form")) {
			 
			view_process(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 단계 할당");	
			return mapping.findForward("process_step_assign_form");
			
		} else if (mode.equals("add_process_step")) {
			
			add_step(mapping, form, request, response);
			
			String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_process_step_form");
			redirect.addParameter("no", processNo);
			return redirect;
				
		} else if (mode.equals("delete_process_step")) {
			
			delete_step(mapping, form, request, response);
			
			String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_process_step_form");
			redirect.addParameter("no", processNo);
			return redirect;
			
		} else if (mode.equals("lower_process_step")) {
			
			lower_process_step(mapping, form, request, response);
			
			String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_process_step_form");
			redirect.addParameter("no", processNo);
			return redirect;
			
		} else if (mode.equals("assign_process_step_avail_form")) {
			 
			view_process(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 다음 단계 지정");	
			return mapping.findForward("process_step_avail_assign_form");
			
		} else if (mode.equals("add_process_step_avail")) {
			
			add_step_avail(mapping, form, request, response);
			
			String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_process_step_avail_form");
			redirect.addParameter("no", processNo);
			return redirect;
				
		} else if (mode.equals("delete_process_step_avail")) {
			
			delete_step_avail(mapping, form, request, response);
			
			String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_process_step_avail_form");
			redirect.addParameter("no", processNo);
			return redirect;
			
		} else if (mode.equals("assign_access_group_form")) {
			
			view_process(mapping, form, request, response);
			request.setAttribute("contentTitle", "업무 관리 - 프로젝트 접근 그룹 할당");
			
			return mapping.findForward("process_access_group_assign_form");
		
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
			
			delete_access_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("assign_role_group_form")) {
			
			view_process(mapping, form, request, response);
			request.setAttribute("contentTitle", "업무 관리 - 프로세스 role 할당");
			
			return mapping.findForward("process_role_group_assign_form");
			
		} else if (mode.equals("add_role_group")) {
			
			add_role_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_role_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_role_group")) {
			
			delete_role_group(mapping, form, request, response);
			
			BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
			String no = businessProcessForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_role_group_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("assign_ext_attr_form")) {
			
			view_process(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "업무 관리 - 프로세스 확장 속성 할당");
			
			return mapping.findForward("process_ext_attr_assign_form");
			
		} else if (mode.equals("assign_ext_attr")) {
			
			assign_ext_attr(mapping, form, request, response);
			
			String processNo = request.getParameter("process_no") == null ? "" : request.getParameter("process_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_ext_attr_form");
			redirect.addParameter("no", processNo);
			return redirect;
		
		} else if (mode.equals("deAssign_ext_attr")) {
			
			deAssign_ext_attr(mapping, form, request, response);
			
			String processNo = request.getParameter("process_no") == null ? "" : request.getParameter("process_no"); 
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_ext_attr_form");
			redirect.addParameter("no", processNo);
			return redirect;
			
		} else if (mode.equals("deAssign_step_ext_attr")) {
			
			deAssign_step_ext_attr(mapping, form, request, response);
			
			String processNo = request.getParameter("process_no") == null ? "" : request.getParameter("process_no"); 
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("BusinessProcessAction") );
			redirect.addParameter("mode", "assign_ext_attr_form");
			redirect.addParameter("no", processNo);
			return redirect;
			
	    } else { // list_process
	    	
	    	list_process(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "업무 관리 - 리스트");

	    	return mapping.findForward("process_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_process(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		BusinessProcessSearchParameter businessProcessSearchParameter = new BusinessProcessSearchParameter();
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		MyWorkList processList = businessProcessService.getProcessList(businessProcessSearchParameter);
		
		request.setAttribute("processList", processList);

	}

	private void add_process(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
		
		BusinessProcess businessProcess = new BusinessProcess();
		PropertyUtils.copyProperties(businessProcess, businessProcessForm);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.addProcess(businessProcess);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_process(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.deleteNetwork(networkForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_process(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String processNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		BusinessProcess businessProcess = businessProcessService.getProcessByNo(processNo);
		
		request.setAttribute("businessProcess", businessProcess);		
		
		BusinessProcessSearchParameter businessProcessSearchParameter = new BusinessProcessSearchParameter();
		businessProcessSearchParameter.setNo(processNo);
		businessProcessSearchParameter.setLanguageNo((String)request.getSession().getAttribute("sessionLanguageNo"));
		List processStepList = businessProcessService.getProcessStepListByProcessNo(businessProcessSearchParameter);
		
		request.setAttribute("processStepList", processStepList);	
		
		List processAccessGroupList = businessProcessService.findBusinessProcessAccessGroupList(processNo);
		request.setAttribute("processAccessGroupList", processAccessGroupList);
		
		BusinessProcessRoleGroupSearchParameter businessProcessRoleGroupSearchParameter = new BusinessProcessRoleGroupSearchParameter();
		businessProcessRoleGroupSearchParameter.setProcessNo(processNo);
		
		List businessProcessRoleGroupList = businessProcessService.findBusinessProcessRoleGroupList(businessProcessRoleGroupSearchParameter);
		request.setAttribute("businessProcessRoleGroupList", businessProcessRoleGroupList);
		
		List businessProcessExtAttrList = businessProcessService.getAssignedBusinessProcessExtAttrListByProcessNo(processNo);
		request.setAttribute("businessProcessExtAttrList", businessProcessExtAttrList);

	}

	private void modify_process(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		Network network = new Network();
		PropertyUtils.copyProperties(network, networkForm);
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.updateNetwork(network);

	}
	
	private void add_step(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		
		
		String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
		String stepName = request.getParameter("stepName") == null ? "" : request.getParameter("stepName"); 
		String stepLane = request.getParameter("stepLane") == null ? "" : request.getParameter("stepLane"); 
		String stepSeq = request.getParameter("stepSeq") == null ? "" : request.getParameter("stepSeq"); 
		String description = request.getParameter("description") == null ? "" : request.getParameter("description"); 
		
		BusinessProcessStep businessProcessStep = new BusinessProcessStep();
		businessProcessStep.setProcessNo(processNo);
		businessProcessStep.setStepName(stepName);
		businessProcessStep.setStepLane(stepLane);
		businessProcessStep.setStepSeq(stepSeq);
		businessProcessStep.setDescription(description);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		String addedProcessStepNo = businessProcessService.addProcessStep(businessProcessStep);
	
	}
	
	private void delete_step(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String processStepNo = request.getParameter("selected_process_step_no") == null ? "" : request.getParameter("selected_process_step_no"); 
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.deleteProcessStep(processStepNo);
	
	}
	
	private void lower_process_step(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
		
		String processStepNo = request.getParameter("selected_process_step_no") != null ? (String) request.getParameter("selected_process_step_no") : "";
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.lowerProcessStep(processNo, processStepNo);
		
		request.setAttribute("alertMessage", "변경되었습니다.");
	
	}
	
	private void add_step_avail(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
		String processStepNo = request.getParameter("selected_process_step_no") == null ? "" : request.getParameter("selected_process_step_no"); 
		String nextProcessStepNo = request.getParameter("next_process_step_no") == null ? "" : request.getParameter("next_process_step_no"); 
		
		BusinessProcessStepNext businessProcessStepNext = new BusinessProcessStepNext();
		businessProcessStepNext.setFromProcessStepNo(processStepNo);
		businessProcessStepNext.setToProcessStepNo(nextProcessStepNo);
		businessProcessStepNext.setDescription("");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		String addedProcessStepNo = businessProcessService.addProcessStepAvail(businessProcessStepNext);
	
	}
	
	private void delete_step_avail(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String processNo = request.getParameter("selected_process_no") == null ? "" : request.getParameter("selected_process_no"); 
		String nextProcessStepNo = request.getParameter("next_process_step_no") == null ? "" : request.getParameter("next_process_step_no"); 
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.deleteProcessStepAvail(nextProcessStepNo);
	
	}
	
	private void add_access_group(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_access_right_string = request.getParameter("access_right");
		int selected_access_right = Integer.parseInt(selected_access_right_string);
		
		BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
		
		BusinessProcess businessProcess = new BusinessProcess();
		PropertyUtils.copyProperties(businessProcess, businessProcessForm);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.addAccessGroup(businessProcess, selected_groupno, selected_groupTypeNo, selected_access_right);
	
	}
	
	private void delete_access_group(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.deleteAccessGroup(selected_groupno);
	
	}
	
	private void add_role_group(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_role_right = request.getParameter("role_right");
		
		BusinessProcessForm businessProcessForm = (BusinessProcessForm) form;
		
		BusinessProcess businessProcess = new BusinessProcess();
		PropertyUtils.copyProperties(businessProcess, businessProcessForm);
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.addRoleGroup(businessProcess, selected_groupno, selected_groupTypeNo, selected_role_right);
	
	}
	
	private void delete_role_group(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService")); 
		businessProcessService.deleteRoleGroup(selected_groupno);
	
	}
	
	private void assign_ext_attr(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		String referenceNo = request.getParameter("no") == null ? "" : request.getParameter("no"); 
		String attrNo = request.getParameter("selected_attr_no") == null ? "" : request.getParameter("selected_attr_no");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.assignProcessExtAttr(referenceNo, attrNo);
		
	}
	
	private void deAssign_ext_attr(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String referenceNo = request.getParameter("no") == null ? "" : request.getParameter("no"); 
		String attrNo = request.getParameter("selected_attr_no") == null ? "" : request.getParameter("selected_attr_no");
		
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.deAssignProcessExtAttr(referenceNo, attrNo);
	
	}
	
	private void deAssign_step_ext_attr(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
						
		String attrNo = request.getParameter("no") == null ? "" : request.getParameter("no"); 
	
		BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
		businessProcessService.deAssignProcessStepExtAttr(attrNo);
	
	}
	
}