package kr.co.leaderway.mywork.MyWorkexception.action;

import java.io.IOException;

import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;

public class MyWorkExceptionServlet implements Servlet {
	
	private Log log = LogFactory.getLog(this.getClass());
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {
		try {
			
			log.info("Handling exception in ErrorHandlerServlet");
		
			Throwable exception = null;
		
			// Check if struts has placed an exception object in request
			Object obj = request.getAttribute(Globals.EXCEPTION_KEY);
		
			if (obj == null) {
				// Since no struts exception is found,
				// check if a JSP exception is available in request.
				obj = request.getAttribute("javax.servlet.jsp.jspException");
			}
		
			if ((obj != null) && (obj instanceof Throwable)) {
				exception = (Throwable) obj;
			}
		
			if (log.isDebugEnabled()) {
				log.info("Request URI: " + request.getAttribute("javax.servlet.forward.request_uri"));
			}
		
			// request uri containing the original URL value will be available
			// only on servers implementing servlet 2.4 spec
			String requestURI = (String) request.getAttribute("javax.servlet.forward.request_uri");
		
			log.error("Exception while handling request: " + requestURI, exception);
			
			String errorPageURL = request.getParameter("errorPageURL");
			response.sendRedirect(errorPageURL);
		} catch (Exception e) {
			// Throwing exceptions from this method can result in request
			// going in to an infinite loop forwarding to the error servlet recursively.
			e.printStackTrace();
		}
	}

	@Override
	public void destroy() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public ServletConfig getServletConfig() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getServletInfo() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void init(ServletConfig arg0) throws ServletException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void service(ServletRequest arg0, ServletResponse arg1)
			throws ServletException, IOException {
		// TODO Auto-generated method stub
		
	}

}

