
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "_library.h"


/**
	Էµ STAMP  YYYYMMDD  ¥ Ѵ.
@input
	stamp	-- UNIX TIME STAMP
@return
	YYYYMMDD
@note
	̹  ù  20030301  ̰  
	   ϱ ؼ
	_cal_ymd( _cal_start_stamp_of_day("20030301") - 1 );   ϸȴ.
@ex
	_cal_ymd( _cal_start_stamp_of_day( argv[1] ) - 1 );
*/
int _cal_ymd( int stamp )
{

	struct tm *_tm;
	time_t _tmp = (time_t) stamp;
	_tm			= localtime( &_tmp );

	char buf[12];
	sprintf( buf, "%d%02d%02d", _tm->tm_year + 1900, _tm->tm_mon + 1, _tm->tm_mday );

	return atoi( buf );
}


// same as _get_start_stamp_of_day
int _cal_start_stamp_of_day ( char *date )
{
	return _get_start_stamp_of_day( date );
}
/**
	"YYYYMMDD"  ڿ 
		 ϴ 0 0 stamp  Ѵ.
@param	char *_file_in
	"" ¸  ڿ
@return int
	 ¥ ϴ ó 0 ʸ 
@note
	, 20030431   2003 04 31  ʰ ǾѴ.
	   Լ Ϲ޴ ٰ 60 * 60 * 24  ϸȴ.
*/
int _get_start_stamp_of_day ( char *_file_in )
{

	char _tmp_16[16];
	int _tmpi;
	struct tm tp;
	time_t _stamp;

	strncpy ( _tmp_16, _file_in, 4 );
	_tmp_16[4]=0;
	_tmpi = atoi( _tmp_16 );
	tp.tm_year		= _tmpi - 1900;

	strncpy ( _tmp_16, _file_in + 4, 2);
	_tmp_16[2]=0;
	_tmpi = atoi( _tmp_16 );
	tp.tm_mon		= _tmpi - 1;
	
	strncpy ( _tmp_16, _file_in + 6, 2);
	_tmp_16[2]=0;
	_tmpi = atoi( _tmp_16 );
	tp.tm_mday		= _tmpi;
	
	tp.tm_sec		= 0;
	tp.tm_min		= 0;
	tp.tm_hour		= 0;
	
	
	tp.tm_wday		= 0;
	tp.tm_yday		= 0;
	tp.tm_isdst		= 0;


	_stamp = mktime( &tp );

	if ( _stamp == (time_t) -1 ) {
		//_warning(">> error mktime( %s )\n", _file_in);
	}

	return _stamp;
}


/**
	_get_days_of_month() Լ ý  ؼ ۼ ʾҴ.
	  ߻ ɼ Ƿ, üũ    .
*/
bool _IsLeapYear(int year) {
	return( ((year%4 ==0)&&(year %100!=0)) || (year%400==0)  ) ;
}

int _get_days_of_month( int month, int year ) {
	switch( month ) {
	case 2:
		if (_IsLeapYear(year)) return(29);
		return (28);
	case 4: case 6: case 9: case 11:
		return (30);
	default : 
		return (31);
	}
}
