#include <sys/stat.h>
#include <stdlib.h>
#include "_file.h"

/**


	 μ ÿ  () ϵ Exclusive  Ǵ.



@param	FILE *fp

	ǰ     

@return

	 0,

	ƴϸ  ڵ



@important

	 ü  Ǵ.

	 ũƮ  Ŵ  ƴϴ.

	  fork()  ؼ ڽ μ  ,  ȣ Ѵ.

@warning

	flock()  NFS    ۿ   Ѵ.

	  fcntl() Լ ؾѴ.



@note

	, flock() Լ  fcntl() Լ   Ѵٸ,

	PHP  Exclusive    ִ.

	׷ flock()  fcntl()   ٸ.

	flock()  BSD Ÿ    ü   ִ.

	,  κ    .

@note

	  ݵ  ؾѴ. ׷ ٸ μ  ϴ.

	Ư,  ݿ     Ŀ  Ͽ   I/O 

	źϰ ȴ.

*/

int _flockopen(FILE *fp) {

#ifdef _WIN32

  return 0;

#else

#ifdef HAVE_FLOCK

  return flock(fileno(fp), LOCK_EX);

#else

  return 0;

#endif

#endif

}





/**

	Ͽ  ִ ǰ  Ѵ.



@param	same as _flockopen()

@return	same as _flockopen()

*/

int _flockclose(FILE *fp) {

#ifdef _WIN32

  return 0;

#else

#ifdef HAVE_FLOCK

  return flock(fileno(fp), LOCK_UN);

#else

  return 0;

#endif

#endif

}











/**

	ǰ ݿ    ϴ Լ̴.

@param	same as fopen()

@return	same as fopen()

@note

	ݵ _fclose() Լ ݾƾѴ.

@example

	FILE *fr = _fopen( _path, "r");

	if ( fr == NULL ) { printf("cannot open the file: %s", _path); exit(1); }



*/

FILE *_fopen(const char *path, const char *mode) {

  FILE *stream;

  

  if((stream = fopen(path, mode)) == NULL) return NULL;

  _flockopen(stream);

  return stream;

}

/**

	_fopen() Լ ؼ   ǰ  ϰ ݴ´.

@param	same as fclose()

@return	same as fclose()

*/

int _fclose(FILE *stream)

{

  _flockclose(stream);

  return fclose(stream);

}







/**

	  θ üũѴ.

@param	char *format, ...

	 

	Է ڿ    μ ޾Ƶ  ִ.

	

@return

	 ϸ 1,

	ƴϸ 0

@note

	 Ұ ϵ  ٰ Ǵϰ 0 Ѵ.

@example

	_checkfile(filename);

*/

int _checkfile(char *format, ...)

{

	FILE *fp;

	char filename[1024];

	int status;

	va_list arglist;



	va_start(arglist, format);

	status = vsprintf(filename, format, arglist);

	

	if(strlen(filename) + 1 > sizeof(filename) || status == EOF)

		printf("ERROR _checkfile()\nFile name is too long or invalid.");



	va_end(arglist);



	fp = _fopen(filename, "rb");

	if(fp == NULL) return 0;

	_fclose(fp);

	

	return 1;

}









/**



  stream  term   ִ ڰ   ڸ о

  static  _chunk_512    _chunk_512  ͸ Ѵ.



@param FILE *stream

	Է Ʈ

@param char term

	  stream   ,   ߴ   Ѵ.

	⺻  '\n' ̴.

@param bool LF

	  true ̸,  ڿ б⸦ ߴѴ.

	term='\n'   LF  񱳵 ʴ´.

@return static char* _chunk

	stream   ͸  ִ ƽ     ϵȴ.

	, EOF   NULL  ϵȴ.

@note

	stream ͸ о term  ƴ üũ ؾϹǷ,

	͸ а   stream ġ term   ġ ȴ.

@note

	static  ϹǷ 忡  ϴ.

@note

	ִ 512 Ʈ ŭ ڸ о   ִ.

	512 Ʈ ,   ʹ ϸ,  Ʈ ʹ

	 chunk  ̵ Ѵ.

@example

	char *_path = "qpicker.conf";

	FILE *fr = _fopen( _path, "r");

	if ( fr == NULL ) { printf("cannot open the file: %s", _path); exit(1); }



	char *ptr;

	while ( ptr = _get_chunk_512( fr, ':' ) ) {

		printf(">%s<\n", ptr);

	}

	_fclose(fr);



*/

char *_get_chunk_512( FILE *stream, char term, bool LF)

{

	static char _chunk[512];



	int ch, i;

	ch = fgetc( stream );

	if ( feof( stream ) ) return NULL;



	for( i = 0 ; (i < 512) && ( feof( stream ) == 0 ) ;  i++ ) {

		

		//  

		if ( ch == term ) break;

		if ( LF && ch == '\n') break;



		_chunk[i] = (char)ch;

		ch = fgetc( stream );

	}

	_chunk[i] = '\0';



	return _chunk;

}





/**



  Էµ    о ޸𸮿 Ҵ  Ѵ.

  ϵ ʹ    ־Ѵ.

  

@param	const char *path

	 

@param	int *size

	  Ʈ ũ

	⺻  NULL ̸, NULL  ԷµǸ   ʴ´.



@return char *

	,    մ Ҵ ޸ .

	н, NULL



	

@note ڵ 

	http://qdecoder.org

@important

	ϵǴ ʹ free() ǾѴ.

*/

char *_read_file( const char *path, int *size )

{

	FILE *fp;

	struct stat fstat;

	char *sp, *tmp;

	int c, i;



	if(size != NULL) *size = 0;

	if(stat( path, &fstat ) < 0) return NULL;

	if((fp = _fopen( path, "rb")) == NULL) return NULL;

	sp = (char *)malloc(fstat.st_size + 1);

	for(tmp = sp, i = 0; (c = fgetc(fp)) != EOF; tmp++, i++)

		*tmp = (char)c;

	*tmp = '\0';

	

	if(fstat.st_size != i)

		return NULL;



	_fclose(fp);

	if(size != NULL) *size = i;

	

	return sp;

}



int _attach_file( const char *path, const char *message, bool LF )

{

	FILE *fp;

	if((fp = _fopen( path, "a+")) == NULL) return 1;

	fputs( message, fp);

	if ( LF ) fputs ("\n", fp);

	_fclose(fp);

	return 0;

}

