/**

	MySQLib.h
@author	mark, mark@gohosting.co.kr
@edition
  The c++ class library for mySQL
  Last Edition:	2001/12/24, 2002/08/25, 2003/04/22
@note
	  On Windows system, libmySQL.lib, libmySQL.dll needed
*/

#ifndef	__MYSQLIB_H_
#define __MYSQLIB_H_


#ifdef	_WIN32
	#include <windows.h>
#endif

#include <mysql.h>



#define MYSQL_CONNECTION		5
#define ALREADY_CONNECTED		10
#define ALREADY_CLOSED			12

#define MYSQL_INIT				100
#define MYSQL_REAL_CONNECT		120
#define	MYSQL_QUERY				150
	
#define MYSQL_OK				0
#define MYSQL_FAILED			-1
#define MYSQL_BOF				-2
#define MYSQL_EOF				-3

class MySQLib {
public :
	MySQLib();
	~MySQLib();
	MYSQL *Clone();
	bool Attach(MYSQL *pConn);
	bool Connect(const char *host, const char *user_name, const char*password, const char *dbname, unsigned int port=0);
	bool IsConnected();
	bool Close();
	
	bool MySQLib::Query( char *format, ... );
	bool MySQLib::LongQuery( const char *query );
	bool Query(const char *query, unsigned long len);
	bool Execute(const char *query);
	char *Result( char *format, ... );
	unsigned long GetInsertId();
	unsigned long GetAffectedRows();
	char *GetErrorMessage();
	int NextRow();
	char *Field(int n);
	char *f( int n );
	char *Escape(const char *query);
	void DebugPrint(bool flag);
private:
	MYSQL		*m_pConn;
	MYSQL_RES	*m_pResult;
	MYSQL_ROW	m_Row;

	char	m_cHost[128];
	char	m_cUserName[64];
	char	m_cPassword[64];
	char	m_cDBName[64];
	unsigned int m_nPort;

	char	m_cErrMsg[1024];

	bool	m_bConnected;
	bool	m_bCloned;
	bool	m_bQueried;
	int		m_nQueryRes;
	int		m_nNumFields;

	bool	m_bDebug;

	void Error(int nErrType);
	void FreeResult();
	void dbg(char *format, ...);
	
};

#endif
