var XPInstallConfirm = 
{ 
  _param: null
};


XPInstallConfirm.init = function ()
{
  var bundle = document.getElementById("xpinstallConfirmStrings");
  
  this._param = window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
  if (!this._param)
    close();
  
  this._param.SetInt(0, 1); // The default return value is "Cancel"
  
  var itemList = document.getElementById("itemList");
  
  var numItemsToInstall = this._param.GetInt(1);
  for (var i = 0; i < numItemsToInstall; ++i) {
    var installItem = document.createElement("installitem");
    itemList.appendChild(installItem);

    installItem.name = this._param.GetString(i);
    installItem.url = this._param.GetString(++i);
    var icon = this._param.GetString(++i);
    if (icon != "")
      installItem.icon = icon;
    var cert = this._param.GetString(++i);
    installItem.cert = cert || bundle.getString("Unsigned");
    installItem.signed = cert ? "true" : "false";
  }
  
  var introString = bundle.getString("itemWarningIntroSingle");
  if (numItemsToInstall > 4)
    introString = bundle.getFormattedString("itemWarningIntroMultiple", [numItemsToInstall / 4]);
  document.getElementById("itemWarningIntro").setAttribute("value", introString);  
  
  var okButton = document.documentElement.getButton("accept");
  okButton.label = bundle.getString("installButtonLabel");
  okButton.focus();
}   
    
XPInstallConfirm.onOK = function ()
{
  this._param.SetInt(0, 0);
  return true;
}

XPInstallConfirm.onCancel = function ()
{
  this._param.SetInt(0, 1);
  return true;
}


