<?

include_once $global["root"] . "/lib/Domain.php";
include_once $global["root"] . "/lib/User.php";
include_once $global["root"] . "/lib/Directories.php";
include_once $global["root"] . "/include/print_byte.php";
include_once $global["root"] . "/lib/Extend_message.php";

class Domains {

	var $info;

	var $Template;

	var $SQL_GET_USER_ALIAS_IN_DOMAIN =
		"select SQL_CACHE no, name, valid, user_no from user_alias_priv
			where domain = '%s'";
	var $SQL_GET_USER_IN_DOMAIN =
		"select SQL_CACHE no, name, id, valid from user_priv where domain = '%s'";

	var $SQL_GET_USER_INFO = "select SQL_CACHE * from user_priv where no = '%s'";
	var $SQL_GET_DOMAIN_FILTER = "select SQL_CACHE * from mail_filter_%s";

	var $total_user_number = "0";
	var $SQL_GET_BLOCK = "select SQL_CACHE no, address from mail_block_%s";

	function Domains () {

		// get domain info
		$DM = new Domain;
		$this->info = $DM->get_info();

		$this->Template = new Template;

	}

	// return user list.
	function return_user_alias_list () {
		global $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_ALIAS_IN_DOMAIN,
			$_SESSION["config_domain"]), true);

		$User = new User;
		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($a);

			$o = $DB->fetch();
			$a["username"]= $o["name"];
			$a["no"]= $o["no"];

			$User->get_info_by_no($o["user_no"]);
			$a["real_name"]= $User->info["name"];
			$a["user_no"]= $User->info["no"];

			if ($o["valid"] == "1") {
				$a["is_valid"] = "selected";
			} else {
				$a["not_valid"] = "selected";
			}

			$main["content"] .=
				$this->Template->generate("/template/domain/user_alias_list_one", $a);
		}

		$this->total_user_number += $DB->num_rows;

		$retval =
			$this->Template->generate("/template/domain/user_alias_list", $main);

		return $retval;
	}

	function return_user_list () {
		global $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_IN_DOMAIN,
			$_SESSION["config_domain"]), true);

		for ($i = 0; $i < $DB->num_rows; $i++) {
			unset($a);

			$o = $DB->fetch();
			$a["username"]= $o["name"];
			$a["user_no"]= $o["no"];
			$a["user_id"]= $o["id"];

			if ($o["valid"] == "1") {
				$a["is_valid"] = "selected";
			} else {
				$a["not_valid"] = "selected";
			}

			$main["content"] .=
				$this->Template->generate("/template/domain/user_list_one", $a);
		}

		$this->total_user_number += $DB->num_rows;

		$main["user_limit"] = sprintf($string["admin24"],
			$this->info["user_limit"]);

		// user alias list.
		$main["alias_user_list"] = $this->return_user_alias_list();

		if ($this->info["user_limit"] > $this->total_user_number) {
			$main["create_user_form"] =
				$this->Template->generate(
					"/template/domain/user_list_create_user_form");
		}

		$retval =
			$this->Template->generate("/template/domain/user_list", $main);

		return $retval;
	}

	function return_user_info ($user_no) {
		global $global, $string;

		$DB = new MySQLdb;

		$DB->query(sprintf($this->SQL_GET_USER_INFO, $user_no), true);

		$o = $DB->fetch();

		$main["user_address"] = sprintf("%s@%s", $o["name"], $o["domain"]);
		$main["username"] = $o["name"];
		$main["user_id"] = $o["id"];
		$main["user_no"] = $o["no"];
		$main["domain_quota"] = print_byte(intval($this->info["quota"]));

		$main["password"] = $o["password_plain"];

		$main["quota"] = intval($o["quota"] / 1000000);

		$main["message_size_limit"] =
			intval($o["message_size_limit"] / 1000000);
		$main["document_size_limit"] =
			intval($o["document_size_limit"] / 1000000);

		$main["domain_message_size_limit"] =
			print_byte(intval($o["message_size_limit"]));
		$main["domain_document_size_limit"] =
			print_byte(intval($o["document_size_limit"]));

		// block address
		$main["block_address"] = $o["block_address"];
		$main["msg_block_address"] = sprintf($string["admin44"],
			$_SESSION["config_block_address"]);

		// filter
		$main["filter"] = $o["filter"];
		$main["msg_filter"] =
			sprintf($string["admin44"], $_SESSION["config_filter"]);

		$retval =
			$this->Template->generate("/template/domain/user_info", $main);

		return $retval;
	}

	function return_filter () {
		global $global;

		$Control = new Control_Message;

		if ($_GET["code_no"] == "new") {
			$retval = $Control->add_filter();
		} else if ($_GET["code_no"]) {
			$retval = $Control->filter_item_one($_GET["code_no"]);
		} else if (! $_GET["code_no"]) {
			$retval = $Control->filter();
		}

		return $retval;
	}

	function return_block_address () {
		global $string;

		$DB = new MySQLdb;

		$DB->fetch_query(
			sprintf($this->SQL_GET_BLOCK, $_SESSION["config_id"]), true);

		for ($i = 0; $i < $_SESSION["config_block_address"]; $i++) {
			$o = $DB->fetch();

			if (! $o["no"]) break;

			$a[] =
				sprintf("<option value=\"%s\">%s", $o["no"], $o["address"]);
		}

		if (count($a) < 1) {
			$b["blocked_address"] =
				sprintf("<option disabled>%s", $string["message68"]);
		} else {
			$b["blocked_address"] = implode("\n",$a);
		}

		$b["blocked_addess_num"] = count($a) + 2;

		$retval =
			$this->Template->generate(
				"/template/domain/block_address", $b);

		return $retval;

	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
