<?

class _Session {

	var $server_unique_id;
	var $ses_table = "sessions";
	var $ses_expire_time = 60; // minites

	var $prevent_multiple_connect = false;

	// sql
	var $SQL_SELECT_DATA = "SELECT * FROM %s WHERE id = '%s'";
	var $SQL_DELETE_DATA = "DELETE FROM %s WHERE id = '%s'";
	var $SQL_DELETE_DATA_GC = "DELETE FROM %s  WHERE time < %s";

	var $SQL_INSERT_DATA =
		"INSERT INTO %s (id, time, time_start, value, server_id)
		VALUES ('%s', '%s', '%s', '%s', '%s')";
	var $SQL_UPDATE_DATA =
		"update %s set time = '%s', value = '%s' where id = '%s'";

	function _Session () {
		$this->__gen_id();
	}

	function __gen_id () {

		// make machines unique id.
		if (! $this->server_unique_id) {
			$this->server_unique_id =
				sha1(sprintf("%s:%s", $_SERVER["SERVER_ADDR"], $_SERVER["SERVER_PORT"]));
		}

	}

	// Create a connection to a database
	function db_connect() {
		global $db;

		$DB = new MySQLdb;
		$DB->connect($db);

		if ($DB->retval) { // mysql connect.
			$DB->set_db($db["database"]);

		} else {
			$Auth = new Authentication;
			$Auth->logout();
		}
	}

	// Open session, if you have your own db connection code, put it in here!
	function _open($path, $name) {
		return("true");
	}

	// Close session
	function _close() {
		$this->_gc(0); // This is used for a manual call of the session gc function

		return("true");
	}

	function set_id ($id) {
	}

	// Read session data from database
	function _read($id) {

		$DB = new MySQLdb;

		$DB->query(
			sprintf($this->SQL_SELECT_DATA, $this->ses_table, $id), true);

		if (! $DB->retval) return("false");

		if ($DB->num_rows < 1) {
			return("");
		} else {
			$o = $DB->fetch();
			$data = $o["value"];

			return($data);
		}
	}

	// Write new data to database
	function _write($id, $data) {

		$DB = new MySQLdb(true);

		$DB->execute_query(sprintf($this->SQL_UPDATE_DATA,
			$this->ses_table,
			time(), escape_string($data), $id));

		$retval = $DB->retval;
		$DB->close();

		if ($DB->retval_affected) {
			return("true");
		} else {

			$DB = new MySQLdb(true);

			$DB->execute_query(
				sprintf($this->SQL_INSERT_DATA,
					$this->ses_table,
					$id, time(), time(),
					escape_string($data),
					$this->server_unique_id
				)
			);

			$retval = $DB->retval;
			$DB->close();

			if (! $retval) {
				return ("false");
			} else {
				return("true");
			}
		}
	}

	// Destroy session record in database
	function _destroy($id) {

		$DB = new MySQLdb(true);

		$DB->execute_query(
			sprintf($this->SQL_DELETE_DATA, $this->ses_table, $id));

		$retval = $DB->retval;

		$DB->close();

		if (! $retval) {
			return("false");
		} else {
			return("true");
		}
	}

	// Garbage collection, deletes old sessions
	function _gc($life) {

		$ses_life = mktime() - ($this->ses_expire_time * 60);
		//$ses_life = strtotime("-5 minutes");

		$DB = new MySQLdb(true);

		$DB->execute_query(sprintf($this->SQL_DELETE_DATA_GC, $this->ses_table, $ses_life));

		$retval = $DB->retval;
		$DB->close();

		if (! $retval) {
			return("false");
		} else {
			return("true");
		}
	}
}

/*

Description
-----------
Reference to "http://www.zend.com/codex.php?id=1126&single=1"

*/

?>
