import sha, os, sys, time
import config, message, sql, myMySQLdb, Privilege

class Domain :

	domain_list = []

	rcpthosts_list = {}
	locals_list = {}
	virtualdomains_list = {}
	assign_list = {}

	QMAIL_DEFAULT = "| %s $EXT@$HOST"

	QMAILD_UID = None
	QMAIL_GID = None

	#ASSIGN_ONE = "+%s-:%s:%s:%s:%s/%s:-::"
	ASSIGN_ONE = "+%s-:%s:%s:%s:%s:-::"

	action = {}
	action["add"] = "remove"
	action["remove"] = "add"

 	def __init__ (self) :
 		""" """
		pass

	def set_db (self, db) :
		self.DB = db

	#-------------------------------------------------- check file permission.
	def __check_file_permission (self, f) :

		MSG = \
"""Can not make "%s".
Please check it's permissions.

"""

		if os.path.exists(f) :
			try :
				f = open(f, "a")
			except IOError :
				sys.stderr.write(MSG % f)
				sys.exit(1)
			else :
				f.close()
				retval = True
		else :
			try :
				f = open(f, "w")
			except IOError :
				sys.stderr.write(MSG % f)
				sys.exit(1)
			else :
				f.close()
				retval = True

		return retval

	#-------------------------------------------------- make a domain list.
	def __get_domain_list (self) :
		try :
			f = open(config.qmail["file"]["virtualdomains"], "r")
		except :
			self.domain_list = []
		else :
			a = f.readlines()

			for i in a :
				b = i.split(":")
				self.domain_list.append(b[0].strip())

	def __check_domain_in_list (self, action, domain) :

		if action == "add" and domain in self.domain_list :
			retval = False
		else :
			retval = True

		if action == "remove" and domain in self.domain_list :
			retval = True
		else :
			retval = False

		return retval

	#--------------------------------------------------
	def __remove_domain_directory(self, domain) :
		""" """
		try :
			os.rmdir("%s/%s" % (config.qmail["directory"]["domains"], domain))
		except :
			retval = False
		else :
			retval = True

		return retval

	def __make_domain_directory(self, domain) :
		""" """

		try :
			os.mkdir("%s/%s" % (config.qmail["directory"]["domains"], domain))
		except :
			retval = False
		else :
			retval = True

		return retval

	def __domain_directory (self, action, domain) :

		if action == "add" :
			if self.__make_domain_directory(domain) :
				retval = self.__qmail_default("add", domain)

			else :
				retval = False
		elif action == "remove" :
			if self.__qmail_default("remove", domain) :
				retval = self.__remove_domain_directory(domain)
			else :
				retval = False
		else :
			retval = False

		return retval

	#--------------------------------------------------
	def __get_virtualdomains (self) :

		self.__check_file_permission(config.qmail["file"]["virtualdomains"])

		# make a virtualdomains list.
		try :
			f = open(config.qmail["file"]["virtualdomains"], "r")
		except :
			self.virtualdomains_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a :
				self.virtualdomains_list.update({i.strip().split(":")[0] : True})

	def __virtualdomains (self, action, domain) :
		"""
		retval
			-2 : domain is alread exists.
			-3 : domain name is not valid
			False : action failed
			True : action success.
		"""

		# check whether domain name is valid or not.
		self.__get_virtualdomains()

		if action == "add" :
			if domain in self.virtualdomains_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["virtualdomains"], "a")
				except :
					retval = False
				else :
					f.write("%s:%s\n" % (domain, domain))
					f.close()

					retval = True

		elif action == "remove" :
			if not domain in self.virtualdomains_list.keys() :
				retval = -2
			else :
				cur_list = self.virtualdomains_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["virtualdomains"], "w")
				except :
					retval = False
				else :
					a = []
					if len(cur_list) < 1 :
						pass
					else :
						for i in cur_list.keys() :
							a.append("%s:%s" % (i, i))

						f.write("%s\n" % "\n".join(a))

					f.close()

					retval = True
		else :
			retval = False

		if retval : self.__get_virtualdomains()

		return retval

	#--------------------------------------------------
	def __get_locals (self) :

		self.__check_file_permission(config.qmail["file"]["locals"])

		# make a locals list.
		try :
			f = open(config.qmail["file"]["locals"], "r")
		except :
			self.locals_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a : self.locals_list.update({i.strip() : True})

	def __get_rcpthosts (self) :

		self.__check_file_permission(config.qmail["file"]["rcpthosts"])

		# make a rcpthosts list.
		try :
			f = open(config.qmail["file"]["rcpthosts"], "r")
		except :
			self.rcpthosts_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a : self.rcpthosts_list.update({i.strip() : True})

	def __update_rcpthosts (self) :
		a = os.system(config.qmail["file"]["qmail-newmrh"])

		if a == 0 :
			retval = True
		else :
			retval = False

		return retval

	def __rcpthosts (self, action, domain) :
		"""
		retval
			-2 : domain is alread exists.
			-3 : domain name is not valid
			False : action failed
			True : action success.
		"""

		# check whether domain name is valid or not.
		self.__get_rcpthosts()

		if action == "add" :
			if domain in self.rcpthosts_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["rcpthosts"], "a")
				except :
					retval = False
				else :
					retval = True

				if retval :
					f.write("%s\n" % domain)
					f.close()

		elif action == "remove" :
			if not domain in self.rcpthosts_list.keys() :
				retval = -2
			else :
				cur_list = self.rcpthosts_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["rcpthosts"], "w")
				except :
					retval = False
				else :
					if len(cur_list) < 1 :
						pass
					else :
						f.write("%s\n" % "\n".join(cur_list.keys()))

					f.close()

					retval = True
		else :
			retval = False

		if retval :
			self.__update_rcpthosts()
			self.__get_rcpthosts()

		return retval

	#--------------------------------------------------
	def __get_assign (self) :

		self.__check_file_permission(config.qmail["file"]["assign"])

		try :
			f = open(config.qmail["file"]["assign"], "r")
		except :
			self.assign_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a :
				if i.strip() == "." : continue

				try :
					k = i.strip().split(":")[1]
				except IndexError :
					continue
				else :
					self.assign_list.update({ k : i.strip()})

	def __assign (self, action, domain) :

		# check whether domain name is valid or not.
		self.__get_assign()

		if action == "add" :
			if domain in self.assign_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["assign"], "w")
				except :
					retval = False
				else :

					self.QMAILD_UID = os.popen("id -u qmaild").read().strip()
					self.QMAIL_GID = os.popen("id -g qmaild").read().strip()

					if len(self.assign_list) < 1 :
						prev_assign_list = ""
					else :
						prev_assign_list = "\n".join(self.assign_list.values()) + "\n"

					f.write("%s%s\n." % (prev_assign_list, \
						self.ASSIGN_ONE % \
						(domain, domain, self.QMAILD_UID, self.QMAIL_GID, \
						config.qmail["directory"]["domains"])))
					f.close()

					retval = True

		elif action == "remove" :
			if not domain in self.assign_list.keys() :
				retval = -2
			else :
				cur_list = self.assign_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["assign"], "w")
				except :
					retval = False
				else :
					if len(cur_list) < 1 :
						f.write(".")
					else :
						f.write("%s\n.\n" % "\n".join(cur_list.values()))

					f.close()

					retval = True
		else :
			retval = False

		if retval :
			self.__update_assign()
			self.__get_assign()

		return retval

	def __update_assign (self) :
		a = os.system(config.qmail["file"]["qmail-newu"])

		if a == 0 :
			retval = True
		else :
			retval = False

		return retval

	#--------------------------------------------------
	def add (self, domain) :
		retval = self.__domain("add", domain);

		return retval

	def remove (self, domain) :
		retval = self.__domain("remove", domain);

		return retval
		
 	def __domain (self, action, domain) :
 		"""
		* job sequence
			rcpthosts
			virtualdomains
			make directory
			make .qmail-default file
			assign
			execute qmail-newu

		* return value
			True : success
			False : failed

			-4 : login failed
			-3 : it's not valid domain
			-2 : it's already exists
		"""
		self.domain_list = []

		self.rcpthosts_list = {}
		self.virtualdomains_list = {}
		self.assign_list = {}

		if not message.is_valid_domain(domain) : retval = -3

		self.__get_domain_list()

		# check the domain is duplicated or not.
		if self.__check_domain_in_list(action, domain) :
			retval = True
		else :
			retval = -2

		if retval == True :
			# locals
			#retval = self.__locals(action, domain)

			# rcpthosts
			retval = self.__rcpthosts(action, domain)

			# virtualdomains
			if retval == True :
				retval = self.__virtualdomains(action, domain)
			elif retval == False :
				self.__rcpthosts(self.action[action], domain)
				self.__locals(action, domain)

				retval = False

			# assign
			if retval == True :
				retval = self.__assign(action, domain)
			elif retval == False :
				#self.__locals(action, domain)
				self.__rcpthosts(self.action[action], domain)
				self.__virtualdomains(self.action[action], domain)

				retval = False

 		return retval

	def do_table (self, action, domain, **options) :

		if action == "add" :
			retval = self.__add_table (domain, **options)
		elif action == "remove" :
			retval = self.__remove_table (domain)
		else :
			retval = False

		return retval

	def __add_table (self, domain, **options) :

		id = int(time.time())

		query = sql.SQL_DOMAIN["add"] % \
			( \
				id, \
				domain, \
				int(options["quota"]) * 1000000, \
				id, \
				int(options["message_size_limit"]) * 1000000, \
				int(options["document_size_limit"]) * 1000000, \
				options["filter"], \
				options["block_address"], \
				options["user"], \
				myMySQLdb.escape_string(options["password"]), \
				myMySQLdb.escape_string(options["password"]), \
				myMySQLdb.escape_string(options["www_domain_name"]) \
			)

		self.DB.query(query)
		ret = self.DB.retval

		if ret :
			self.DB.query(sql.SQL_DOMAIN_BLOCK % (id)) # execute query.
			ret = self.DB.retval

			if ret :
				self.DB.query(sql.SQL_DOMAIN_FILTER % (id)) # execute query.

				ret = self.DB.retval

		retval = ret

		return retval

	def __remove_table (self, domain) :

		P = Privilege.Privilege(self.DB)

		id = P.get_domain_id(domain)

		self.DB.query(sql.SQL_DOMAIN["remove"] % domain)
		ret = self.DB.retval

		if ret :
			for i in sql.SQL_DOMAIN["remove_table"].split(" ") :
				if not ret : break
				table = i % id
				self.DB.query("drop table %s" % table)

				ret = self.DB.retval

		if ret :
			ret = self.__remove_user_table(domain)

		retval = ret

		return retval

	def __remove_user_table (self, domain) :

		P = Privilege.Privilege(self.DB)

		user_id_list = P.get_user_id_in_domain(domain)

		if not user_id_list :
			retval = True
		else :
			ret = True 
			for i in user_id_list :

				if not ret : break

				for j in sql.SQL_DOMAIN["remove_user_table"].split(" ") :

					if not ret : break

					table = j % i
					self.DB.query("drop table %s" % table)

					ret = self.DB.retval

			retval = ret

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Domain.py"

