import sha
import sys, os

ROOT = sys.path[0]

sys.path.append("%s/module" % ROOT)
sys.path.append("%s/resource" % ROOT)

import Config

# read configuration file, config.cfg
CC = Config.Config("%s/config.cfg" % ROOT)
Config_CFG = CC.get_all()

#-------------------------------------------------- db
default = {}
default["domain"] = "www.spikeekips.net"
default["interval"] = 10 # second
default["interval_remote_message"] = 300 # second
default["postmaster"] = "spike@www.spikeekips.net" # second

if not Config_CFG["Language"].has_key("encoding") :
	default["encoding"] = "euc-kr"
else :
	default["encoding"] = Config_CFG["Language"]["encoding"]

default["quota"] = {}
default["quota"]["default_quota"] = 50000000 # byte
default["quota"]["over_quota"] = 30 # %

default["item"] = {}
default["item"]["inbox"] = 1
default["item"]["sent"] = 2
default["item"]["tmp"] = 3
default["item"]["trash"] = 4
default["item"]["spam"] = 5

default["item"]["default"] = 3

#---------------------------------------------- send message
if not Config_CFG.has_key("SMTP") :
	raise ValueError, "%s must be set in config file." % "SMTP"

if not "method"	in Config_CFG["SMTP"].keys() :
	raise ValueError, "%s must be set in config file." % "Method"

if not "host"	in Config_CFG["SMTP"].keys() :
	raise ValueError, "%s must be set in config file." % "Host"

if not "port"	in Config_CFG["SMTP"].keys() :
	raise ValueError, "%s must be set in config file." % "Port"

default["send"] = Config_CFG["SMTP"]["method"]

smtp = {}
smtp["server"] = Config_CFG["SMTP"]["host"]
smtp["port"] = Config_CFG["SMTP"]["port"]

#-------------------------------------------------- db
db = {}

if not Config_CFG.has_key("Database") :
	raise ValueError, "Check the engine/config.cfg"
	sys.exit(1)
else :
	if not "host"			in Config_CFG["Database"].keys() :
		raise ValueError, "%s must be set in config file." % "Host"

	if (not "unix_socket" in Config_CFG["Database"].keys()) and \
			(not "port"	in Config_CFG["Database"].keys()) :
		raise ValueError, "%s must be set in config file." % "Unix_socket or Port"

	if not "db"				in Config_CFG["Database"].keys() :
		raise ValueError, "%s must be set in config file." % "Db"

	if not "user"			in Config_CFG["Database"].keys() :
		raise ValueError, "%s must be set in config file." % "User"

	if not "passwd"		in Config_CFG["Database"].keys() :
		raise ValueError, "%s must be set in config file." % "Passwd"

	db["host"]			= Config_CFG["Database"]["host"]
	db["db"]				= Config_CFG["Database"]["db"]
	db["user"]			= Config_CFG["Database"]["user"]
	db["passwd"]		= Config_CFG["Database"]["passwd"]

	if "unix_socket" in Config_CFG["Database"].keys() :
		db["unix_socket"]	= Config_CFG["Database"]["unix_socket"]
	else :
		db["port"]			= Config_CFG["Database"]["port"]

#-------------------------------------------------- directory
mail_server = {}
mail_server["root"] = Config_CFG["Directory"]["root"]

directory = {}
directory["root"] = Config_CFG["Directory"]["engine"]
directory["log"] = Config_CFG["Directory"]["log"]
directory["pid"] = directory["root"]

www_data = {}
www_data["root"] = Config_CFG["Directory"]["www-data"]

qmail = {}

qmail["directory"] = {}
qmail["file"] = {}

qmail["directory"]["root"] = "%s/server" % mail_server["root"]

qmail["directory"]["bin"] = "%s/bin" % qmail["directory"]["root"]
qmail["directory"]["domains"] = "%s/domains" % mail_server["root"]
qmail["directory"]["message"] = "%s/message" % mail_server["root"]
qmail["directory"]["control"] = "%s/control" % qmail["directory"]["root"]
qmail["directory"]["users"] = "%s/users" % qmail["directory"]["root"]

qmail["file"]["rcpthosts"] = "%s/morercpthosts" % qmail["directory"]["control"]
qmail["file"]["locals"] = "%s/locals" % qmail["directory"]["control"]
qmail["file"]["virtualdomains"] = "%s/virtualdomains" % qmail["directory"]["control"]
qmail["file"]["assign"] = "%s/assign" % qmail["directory"]["users"]
qmail["file"]["qmail-newu"] = "%s/qmail-newu" % qmail["directory"]["bin"]
qmail["file"]["qmail-newmrh"] = "%s/qmail-newmrh" % qmail["directory"]["bin"]
qmail["file"]["qmail_default"] = "%s/.qmail-default" % qmail["directory"]["domains"]

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "config.py"

