<?

include_once $global["root"] . "/config/tables.php";

class User {

	var $info;

	// sql
	var $SQL_GET_USER_INFO = "select SQL_CACHE * from user_priv where no = '%s'";
	var $SQL_GET_USER_INFO1 = "select SQL_CACHE * from user_priv where id = '%s'";
	var $SQL_GET_USER_INFO2 =
		"select SQL_CACHE * from user_priv where name = '%s' and domain = '%s'";

	var $SQL_REMOVE_USER_ALIAS = "delete from user_alias_priv where no = '%s'";
	var $SQL_REMOVE_USER_IN_USER_PRIV = "delete from user_priv where no = '%s'";

	var $SQL_SET_VALID_ALIAS = "update user_alias_priv set valid = '1' where no = '%s'";
	var $SQL_SET_NOT_VALID_ALIAS = "update user_alias_priv set valid = '0' where no = '%s'";
	var $SQL_SET_VALID = "update user_priv set valid = '1' where no = '%s'";
	var $SQL_SET_NOT_VALID = "update user_priv set valid = '0' where no = '%s'";

	var $SQL_FIND_USER = "select SQL_CACHE count(no) as num from user_priv
			where name = '%s' and domain = '%s'";
	var $SQL_FIND_USER_ALIAS = "select SQL_CACHE count(no) as num from user_alias_priv
			where name = '%s' and domain = '%s'";

	var $SQL_GET_USERS_IN_DOMAIN = "select SQL_CACHE count(no) as num from user_priv
			where domain = '%s'";
	var $SQL_GET_USER_ALIASES_IN_DOMAIN = "select SQL_CACHE
		count(no) as num from user_alias_priv where domain = '%s'";

	function User ($no=false, $id=false) {
		if ($no and ! $id) $this->get_info_by_no($no);
		if (! $no and $id) $this->get_info_by_id($id);
	}

	function get_info_by_address ($username, $domain_name) {

		$DB = new MySQLdb;

		$retval = $DB->fetch_one(sprintf($this->SQL_GET_USER_INFO2,
			$username, $domain_name));

		return $retval;

	}

	function get_info_by_no ($no) {
		$DB = new MySQLdb;
		$this->info = $DB->fetch_one(sprintf($this->SQL_GET_USER_INFO, $no));
	}

	function get_info_by_id ($id) {
		$DB = new MySQLdb;
		$this->info = $DB->fetch_one(sprintf($this->SQL_GET_USER_INFO1, $id));
	}

	function is_valid_name ($name) {

		if (eregi("^[a-z0-9\-][a-z0-9\-_]+$", $name)) {
			$retval = true;
		} else {
			$retval = false;
		}

		return $retval;
	}

	function is_duplicated ($username, $domain) {

		$DB = new MySQLdb;

		// check in user_alias_priv
		$o = $DB->fetch_one(sprintf($this->SQL_FIND_USER_ALIAS, $username, $domain));

		if ($o["num"] > 0) {
			$retval = true;
		} else {
			// check in user_priv
			$o = $DB->fetch_one(sprintf($this->SQL_FIND_USER, $username, $domain));

			if ($o["num"] > 0) {
				$retval = true;
			} else {
				$retval = false;
			}
		}

		return $retval;
	}

	function get_total_user_numbers_in_domain ($domain) {
		$DB = new MySQLdb;

		$total_num = 0;

		$o = $DB->fetch_one(sprintf($this->SQL_GET_USER_ALIASES_IN_DOMAIN, $domain));

		if ($o["num"] > 0) $total_num += $o["num"];
		
		$o = $DB->fetch_one(sprintf($this->SQL_GET_USERS_IN_DOMAIN, $domain));

		if ($o["num"] > 0) $total_num += $o["num"];

		return $total_num;
	}

	function set_not_valid_alias ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_SET_NOT_VALID_ALIAS, $no));

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function set_valid_alias ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_SET_VALID_ALIAS, $no));

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function set_not_valid ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_SET_NOT_VALID, $no));

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function set_valid ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_SET_VALID, $no));

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function add ($name, $domain, $password) {
		/*
		return value
			-3 : is not valid user name.
			-2 : user is already exists.
		*/

		$name = trim($name);
		$domain = trim($domain);
		$password = trim($password);

		if ($this->get_total_user_numbers_in_domain($domain) >=
				$_SESSION["config_user_limit"]) {

			$retval = "-4";
		} else {
			if ($this->is_duplicated($name, $domain)) {
				$retval = -2;
			} else if (! $this->is_valid_name($name)) {
				$retval = -3;
			} else {

				$id = $this->register_user_priv($name, $domain, $password);

				if (! $id) {
					$retval = false;
				} else {
					$retval = $this->create_table($id);
				}
			}
		}

		return $retval;
	}

	function add_alias ($name, $domain, $user_no) {
		/*
		return value
			-3 : is not valid user name.
			-2 : user is already exists.
		*/

		$name = trim($name);
		$domain = trim($domain);

		if ($this->get_total_user_numbers_in_domain($domain) >=
				$_SESSION["config_user_limit"]) {

			$retval = "-4";
		} else {
			if ($this->is_duplicated($name, $domain)) {
				$retval = -2;
			} else if (! $this->is_valid_name($name)) {
				$retval = -3;
			} else {
				$retval = $this->register_user_alias_priv($name, $domain, $user_no);
			}
		}

		return $retval;
	}

	function register_user_alias_priv ($name, $domain, $user_no) {
		global $insert;

		$DB = new MySQLdb(true);

		$DB->query(
			sprintf($insert["reg_user_alias"],
					$name,		// name
					$domain,		// domain
					$user_no	// user_no
				)
			);

		if ($DB->retval) {
			$retval = true;
		} else {
			$retval = false;
		}

		$DB->close();

		return $retval;
	}

	function register_user_priv ($name, $domain, $password) {
		global $insert;

		$id = mktime(); // create user id.

		$DB = new MySQLdb(true);

		$DB->query(
			sprintf($insert["reg_user"],
																					// no
					$name,														// name
					$domain,														// domain
					$password,													// password
					$password,													// password_plain
					$_SESSION["config_quota"],								// quota
																					// valid
																					// lang
																					// pageLimit
					$id,															// createdTime
					$id,															// id
																					// sort_method
																					// save_sort
																					// full_name
																					// reply_to
																					// signature
					$_SESSION["config_block_address"],					// block_address
					$_SESSION["config_filter"],							// filter
					$_SESSION["config_timeout"],							// timeout
																					// escape_filter_domain
					$_SESSION["config_message_size_limit"],			// message_size_limit
					$_SESSION["config_document_size_limit"]			// document_size_limit
				)
			);

		if ($DB->retval) {
			$retval = $id;
		} else {
			$retval = false;
		}

		$DB->close();

		return $retval;
	}

	function create_table ($id) {
		global $table, $insert;

		$DB = new MySQLdb(true);

		while (list($i, $j) = each($table["user"])) {
			$DB->query(sprintf($j, $id));
		}

		if ($DB->retval) {
			while (list($i, $j) = each($insert["user_value"])) {
				$DB->query(sprintf($j, $id));
			}
		}

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function remove_in_user_priv ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_REMOVE_USER_IN_USER_PRIV, $no));

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function remove_user_table ($id) {
		global $table;

		$DB = new MySQLdb(true);

		while (list($i, $j) = each($table["user"])) {
			$DB->query(sprintf("drop table %s_%s", $i, $id));

			if (! $DB->retval) break;
		}

		$retval = $DB->retval;

		$DB->close();

		return $retval;
	}

	function remove_alias ($no) {

		$DB = new MySQLdb(true);

		$DB->query(sprintf($this->SQL_REMOVE_USER_ALIAS, $no));

		$retval = $DB->retval;
		$DB->close();

		return $retval;
	}

	function remove ($no, $id="") {

		if (! $id) {
			$this->get_info_by_no($no);
			$id = $this->info["id"];
		}

		// remove user in user_priv.
		$retval = $this->remove_in_user_priv($no);

		// remove user's table.
		if ($retval) {
			$retval = $this->remove_user_table($id);
		}

		return $retval;
	}
}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
